/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.predicates;

import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.repurposedstructures.modinit.RSPredicates;
import java.util.Locale;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTestType;

public class MatterPhaseRuleTest
extends RuleTest {
    public static final MapCodec<MatterPhaseRuleTest> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)StringRepresentable.fromEnum(MATTER_PHASE::values).fieldOf("phase_to_test_for").stable().forGetter(ruletest -> ruletest.phaseToTestFor), (App)Codec.BOOL.fieldOf("invert_condition").orElse((Object)false).forGetter(ruletest -> ruletest.invertCondition)).apply((Applicative)instance, instance.stable(MatterPhaseRuleTest::new)));
    private final MATTER_PHASE phaseToTestFor;
    private final boolean invertCondition;

    private MatterPhaseRuleTest(MATTER_PHASE phaseToTestFor, boolean invertCondition) {
        this.phaseToTestFor = phaseToTestFor;
        this.invertCondition = invertCondition;
    }

    public boolean test(BlockState state, RandomSource random) {
        boolean phaseMatch = false;
        switch (this.phaseToTestFor.ordinal()) {
            case 2: {
                if (!state.isAir()) break;
                phaseMatch = true;
                break;
            }
            case 1: {
                if (state.getFluidState().isEmpty()) break;
                phaseMatch = true;
                break;
            }
            case 0: {
                if (state.isAir() || !state.getFluidState().isEmpty() || !state.canOcclude()) break;
                phaseMatch = true;
                break;
            }
            case 3: {
                if (!state.isAir() && !state.is(Blocks.IRON_CHAIN) && !state.is(Blocks.RAIL)) break;
                phaseMatch = true;
                break;
            }
            case 4: {
                if (state.getFluidState().isEmpty() && !state.is(Blocks.IRON_CHAIN) && !state.is(Blocks.RAIL)) break;
                phaseMatch = true;
            }
        }
        if (this.invertCondition) {
            phaseMatch = !phaseMatch;
        }
        return phaseMatch;
    }

    protected RuleTestType<?> getType() {
        return RSPredicates.MATTER_PHASE_RULE_TEST.get();
    }

    public static enum MATTER_PHASE implements StringRepresentable
    {
        SOLID("SOLID"),
        LIQUID("LIQUID"),
        AIR("AIR"),
        AIR_RAIL_OR_CHAIN("AIR_RAIL_OR_CHAIN"),
        LIQUID_RAIL_OR_CHAIN("LIQUID_RAIL_OR_CHAIN");

        private final String name;
        private static final Map<String, MATTER_PHASE> BY_NAME;

        private MATTER_PHASE(String name) {
            this.name = name;
        }

        public static MATTER_PHASE byName(String name) {
            return BY_NAME.get(name.toUpperCase(Locale.ROOT));
        }

        public String getSerializedName() {
            return this.name;
        }

        static {
            BY_NAME = (Map)Util.make((Object)Maps.newHashMap(), hashMap -> {
                MATTER_PHASE[] var1;
                for (MATTER_PHASE type : var1 = MATTER_PHASE.values()) {
                    hashMap.put(type.name, type);
                }
            });
        }
    }
}

