/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.features;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.repurposedstructures.world.features.configs.StructureTargetConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class StructureChains
extends Feature<StructureTargetConfig> {
    public StructureChains(Codec<StructureTargetConfig> config) {
        super(config);
    }

    public boolean place(FeaturePlaceContext<StructureTargetConfig> context) {
        WorldGenLevel world = context.level();
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int i = 0; i < ((StructureTargetConfig)context.config()).attempts; ++i) {
            mutable.set((Vec3i)context.origin()).move(context.random().nextInt(11) - 5, context.random().nextInt(3) - 1, context.random().nextInt(11) - 5);
            if (!world.getBlockState((BlockPos)mutable).isAir()) continue;
            int length = 0;
            boolean exitEarly = false;
            while (mutable.getY() > world.getMinY() + 3 && length < context.random().nextInt(context.random().nextInt(context.random().nextInt(8) + 1) + 1) + 1) {
                if (world.isEmptyBlock((BlockPos)mutable)) {
                    BlockState aboveBlockstate = world.getBlockState(mutable.above());
                    if (aboveBlockstate.is(Blocks.IRON_CHAIN) || aboveBlockstate.isFaceSturdy((BlockGetter)world, mutable.above(), Direction.DOWN)) {
                        world.setBlock((BlockPos)mutable, Blocks.IRON_CHAIN.defaultBlockState(), 2);
                        ++length;
                    }
                } else {
                    exitEarly = true;
                }
                mutable.move(Direction.DOWN);
            }
            if (exitEarly || mutable.getY() == world.getMinY() + 3 || !(context.random().nextFloat() < 0.075f) || !world.isEmptyBlock((BlockPos)mutable)) continue;
            if (world.getBiome((BlockPos)mutable).is(BiomeTags.IS_NETHER)) {
                world.setBlock((BlockPos)mutable, (BlockState)Blocks.SOUL_LANTERN.defaultBlockState().setValue((Property)LanternBlock.HANGING, (Comparable)Boolean.valueOf(true)), 2);
                continue;
            }
            world.setBlock((BlockPos)mutable, (BlockState)Blocks.LANTERN.defaultBlockState().setValue((Property)LanternBlock.HANGING, (Comparable)Boolean.valueOf(true)), 2);
        }
        return true;
    }
}

