/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.features;

import com.google.common.collect.ImmutableList;
import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import com.telepathicgrunt.repurposedstructures.utils.GeneralUtils;
import com.telepathicgrunt.repurposedstructures.world.features.configs.NbtFeatureConfig;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class NbtFeature
extends Feature<NbtFeatureConfig> {
    private final BlockIgnoreProcessor ignoreStructureVoid = new BlockIgnoreProcessor((List)ImmutableList.of((Object)Blocks.STRUCTURE_VOID));
    private final StructurePlaceSettings placementSettings = new StructurePlaceSettings().setMirror(Mirror.NONE).addProcessor((StructureProcessor)this.ignoreStructureVoid).setIgnoreEntities(false);

    public NbtFeature() {
        super(NbtFeatureConfig.CODEC);
    }

    public boolean place(FeaturePlaceContext<NbtFeatureConfig> context) {
        ResourceLocation nbtRL;
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos().set((Vec3i)context.origin());
        mutable.move(Direction.UP);
        while (context.level().isEmptyBlock((BlockPos)mutable) && mutable.getY() > 2) {
            mutable.move(Direction.DOWN);
        }
        if (context.level().getBlockState((BlockPos)mutable).isAir() || context.level().isEmptyBlock(mutable.below()) || context.level().isEmptyBlock(mutable.below(2))) {
            return false;
        }
        mutable.move(Direction.DOWN);
        if (((NbtFeatureConfig)context.config()).nbtResourcelocationsAndWeights.size() == 0) {
            return false;
        }
        BlockPos.MutableBlockPos blockpos$Mutable = new BlockPos.MutableBlockPos();
        StructureTemplateManager templatemanager = context.level().getLevel().getServer().getStructureManager();
        Optional template = templatemanager.get(nbtRL = (ResourceLocation)GeneralUtils.getRandomEntry(((NbtFeatureConfig)context.config()).nbtResourcelocationsAndWeights, context.random()));
        if (template.isEmpty()) {
            RepurposedStructures.LOGGER.warn(((NbtFeatureConfig)context.config()).nbtResourcelocationsAndWeights.toString() + " NTB does not exist!");
            return false;
        }
        int radius = ((StructureTemplate)template.get()).getSize().getX() / 2;
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                if (x * x + z * z >= radius * radius + 1) continue;
                blockpos$Mutable.set((Vec3i)context.origin()).move(x, 0, z);
                if (!((NbtFeatureConfig)context.config()).allowInWater && !context.level().getFluidState((BlockPos)blockpos$Mutable).isEmpty()) {
                    return false;
                }
                if (!context.level().getBlockState((BlockPos)blockpos$Mutable.move(Direction.UP)).canOcclude() && context.level().getBlockState((BlockPos)blockpos$Mutable.move(Direction.DOWN, 3)).canOcclude()) continue;
                return false;
            }
        }
        BlockPos halfLengths = new BlockPos(((StructureTemplate)template.get()).getSize().getX() / 2, 0, ((StructureTemplate)template.get()).getSize().getZ() / 2);
        this.placementSettings.setRotation(Rotation.getRandom((RandomSource)context.random())).setRotationPivot(halfLengths).setIgnoreEntities(false);
        if (((NbtFeatureConfig)context.config()).processor != null) {
            context.level().registryAccess().lookupOrThrow(Registries.PROCESSOR_LIST).getOptional(((NbtFeatureConfig)context.config()).processor).ifPresent(processor -> processor.list().forEach(arg_0 -> ((StructurePlaceSettings)this.placementSettings).addProcessor(arg_0)));
        }
        blockpos$Mutable.set((Vec3i)context.origin());
        BlockPos offset = new BlockPos(-((StructureTemplate)template.get()).getSize().getX() / 2, ((NbtFeatureConfig)context.config()).heightOffset, -((StructureTemplate)template.get()).getSize().getZ() / 2);
        ((StructureTemplate)template.get()).placeInWorld((ServerLevelAccessor)context.level(), blockpos$Mutable.offset((Vec3i)offset), blockpos$Mutable.offset((Vec3i)offset), this.placementSettings, context.random(), 2);
        return true;
    }
}

