/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.features;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.repurposedstructures.modinit.RSTags;
import com.telepathicgrunt.repurposedstructures.world.features.StructurePostProcessConnectiveBlocks;
import com.telepathicgrunt.repurposedstructures.world.features.configs.MineshaftSupportConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class MineshaftSupport
extends Feature<MineshaftSupportConfig> {
    public MineshaftSupport(Codec<MineshaftSupportConfig> config) {
        super(config);
    }

    public boolean place(FeaturePlaceContext<MineshaftSupportConfig> context) {
        block16: {
            BlockState tempBlock;
            ChunkAccess chunk;
            WorldGenLevel world;
            BlockPos.MutableBlockPos mutable;
            BlockPos jigsawPos;
            block17: {
                BlockState removalState;
                jigsawPos = context.origin().below();
                mutable = new BlockPos.MutableBlockPos().set((Vec3i)jigsawPos);
                world = context.level();
                chunk = world.getChunk((BlockPos)mutable);
                BlockState blockState = removalState = ((MineshaftSupportConfig)context.config()).waterBased ? Blocks.WATER.defaultBlockState() : Blocks.CAVE_AIR.defaultBlockState();
                if (((MineshaftSupportConfig)context.config()).archBlocks.contains(world.getBlockState(mutable.above(3)).getBlock())) {
                    for (int i = 0; i <= 1; ++i) {
                        if (chunk.getBlockState((BlockPos)mutable.move(Direction.UP)).getBlock() == ((MineshaftSupportConfig)context.config()).fenceState.getBlock()) continue;
                        StructurePostProcessConnectiveBlocks.placeConnectBlock(context, mutable, chunk.getPos(), chunk, ((MineshaftSupportConfig)context.config()).fenceState);
                        this.blockOffAirIfWaterBased(context, mutable, world);
                    }
                    return true;
                }
                for (int i = 0; i <= 2; ++i) {
                    BlockState checkArchState = chunk.getBlockState((BlockPos)mutable.move(Direction.UP));
                    if (!(i < 2 ? checkArchState.getBlock() == ((MineshaftSupportConfig)context.config()).fenceState.getBlock() : ((MineshaftSupportConfig)context.config()).archBlocks.contains(checkArchState.getBlock()))) continue;
                    chunk.setBlockState((BlockPos)mutable, removalState, 2);
                    this.blockOffAirIfWaterBased(context, mutable, world);
                }
                for (Direction direction : Direction.Plane.HORIZONTAL) {
                    BlockState checkArchState;
                    mutable.move(direction);
                    if (new ChunkPos((BlockPos)mutable).equals((Object)chunk.getPos()) && ((MineshaftSupportConfig)context.config()).archBlocks.contains((checkArchState = chunk.getBlockState((BlockPos)mutable)).getBlock())) {
                        chunk.setBlockState((BlockPos)mutable, removalState, 2);
                        this.blockOffAirIfWaterBased(context, mutable, world);
                    }
                    mutable.move(direction.getOpposite());
                }
                if (((MineshaftSupportConfig)context.config()).archOnly) {
                    return true;
                }
                mutable.set((Vec3i)jigsawPos);
                if (!world.getBlockState((BlockPos)mutable).is(((MineshaftSupportConfig)context.config()).targetFloorState)) break block16;
                if (world.canSeeSkyFromBelowWater(mutable.above())) {
                    return false;
                }
                boolean canMakePillar = false;
                mutable.move(Direction.DOWN);
                while (mutable.getY() > chunk.getMinY()) {
                    tempBlock = chunk.getBlockState((BlockPos)mutable);
                    if (this.canReplace(tempBlock)) {
                        mutable.move(Direction.DOWN);
                        continue;
                    }
                    if (jigsawPos.getY() - mutable.getY() > 20 || tempBlock.is(Blocks.LAVA) || tempBlock.is(Blocks.RAIL)) break;
                    canMakePillar = true;
                    break;
                }
                if (!canMakePillar) break block17;
                BlockPos.MutableBlockPos pillarPos = new BlockPos.MutableBlockPos().set((Vec3i)jigsawPos).move(Direction.DOWN);
                BlockState pillarBlockFinal = ((MineshaftSupportConfig)context.config()).pillarState;
                while (pillarPos.getY() > mutable.getY()) {
                    if (pillarBlockFinal.hasProperty((Property)BlockStateProperties.WATERLOGGED)) {
                        pillarBlockFinal = (BlockState)pillarBlockFinal.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(chunk.getBlockState((BlockPos)pillarPos).getFluidState().is(FluidTags.WATER)));
                    }
                    chunk.setBlockState((BlockPos)pillarPos, pillarBlockFinal, 2);
                    pillarPos.move(Direction.DOWN);
                }
                break block16;
            }
            mutable.set((Vec3i)jigsawPos);
            if (chunk.getBlockState(mutable.above(((MineshaftSupportConfig)context.config()).waterBased ? 4 : 3)).canOcclude()) break block16;
            boolean canMakeChain = false;
            mutable.move(Direction.UP);
            while (mutable.getY() < world.getMaxY()) {
                tempBlock = chunk.getBlockState((BlockPos)mutable);
                if (this.canReplace(tempBlock)) {
                    mutable.move(Direction.UP);
                    continue;
                }
                if (mutable.getY() - jigsawPos.getY() > 50 || !Block.canSupportCenter((LevelReader)world, (BlockPos)mutable, (Direction)Direction.DOWN) || tempBlock.getBlock() instanceof FallingBlock) break;
                canMakeChain = true;
                break;
            }
            if (canMakeChain) {
                BlockPos.MutableBlockPos chainPos = new BlockPos.MutableBlockPos().set((Vec3i)jigsawPos).move(Direction.UP);
                BlockState fenceBlockFinal = ((MineshaftSupportConfig)context.config()).fenceState;
                if (fenceBlockFinal.hasProperty((Property)BlockStateProperties.WATERLOGGED)) {
                    fenceBlockFinal = (BlockState)fenceBlockFinal.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(chunk.getBlockState((BlockPos)chainPos).getFluidState().is(FluidTags.WATER)));
                }
                chunk.setBlockState((BlockPos)chainPos, fenceBlockFinal, 2);
                chainPos.move(Direction.UP);
                while (chainPos.getY() < mutable.getY()) {
                    chunk.setBlockState((BlockPos)chainPos, (BlockState)Blocks.IRON_CHAIN.defaultBlockState().setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(chunk.getBlockState((BlockPos)chainPos).getFluidState().is(FluidTags.WATER))), 2);
                    chainPos.move(Direction.UP);
                }
            }
        }
        return true;
    }

    private void blockOffAirIfWaterBased(FeaturePlaceContext<MineshaftSupportConfig> context, BlockPos.MutableBlockPos mutable, WorldGenLevel world) {
        if (((MineshaftSupportConfig)context.config()).waterBased) {
            for (Direction direction : Direction.values()) {
                mutable.move(direction);
                if (world.getBlockState((BlockPos)mutable).isAir()) {
                    world.setBlock((BlockPos)mutable, ((MineshaftSupportConfig)context.config()).targetFloorState.defaultBlockState(), 3);
                }
                mutable.move(direction.getOpposite());
            }
        }
    }

    protected boolean canReplace(BlockState state) {
        return state.isAir() || !state.getFluidState().isEmpty() && !state.getFluidState().is(FluidTags.LAVA) || state.is(RSTags.MINESHAFT_SUPPORT_REPLACEABLES);
    }
}

