/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.utils;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Pair;
import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import com.telepathicgrunt.repurposedstructures.mixins.structures.JigsawJunctionAccessor;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.FrontAndTop;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.JigsawBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.StructureAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.shapes.VoxelShape;

public final class GeneralUtils {
    private static final Map<BlockState, Boolean> IS_FULLCUBE_MAP = new ConcurrentHashMap<BlockState, Boolean>();
    private static final ConcurrentHashMap<HeightKey, Integer> CACHED_HEIGHT = new ConcurrentHashMap(2048);

    private GeneralUtils() {
    }

    public static <T> T loadService(Class<T> service) {
        return ServiceLoader.load(service).findFirst().orElseThrow(() -> new IllegalStateException("No platform implementation found for " + service.getName()));
    }

    public static <T> T getRandomEntry(List<Pair<T, Integer>> rlList, RandomSource random) {
        int index;
        double totalWeight = 0.0;
        for (Pair<T, Integer> pair : rlList) {
            totalWeight += (double)((Integer)pair.getSecond()).intValue();
        }
        double randomWeightPicked = (double)random.nextFloat() * totalWeight;
        for (index = 0; index < rlList.size() - 1 && !((randomWeightPicked -= (double)((Integer)rlList.get(index).getSecond()).intValue()) <= 0.0); ++index) {
        }
        return (T)rlList.get(index).getFirst();
    }

    public static boolean isFullCube(BlockState state) {
        if (state == null) {
            return false;
        }
        return IS_FULLCUBE_MAP.computeIfAbsent(state, stateIn -> Block.isShapeFullBlock((VoxelShape)stateIn.getOcclusionShape()));
    }

    public static BlockState orientateChest(ServerLevelAccessor blockView, BlockPos blockPos, BlockState blockState) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        Direction wallDirection = (Direction)blockState.getValue((Property)HorizontalDirectionalBlock.FACING);
        for (Direction facing : Direction.Plane.HORIZONTAL) {
            mutable.set((Vec3i)blockPos).move(facing);
            if (!GeneralUtils.isFullCube(blockView.getBlockState((BlockPos)mutable))) continue;
            wallDirection = facing;
            mutable.move(facing.getOpposite(), 2);
            if (blockView.getBlockState((BlockPos)mutable).isSolid()) continue;
            break;
        }
        return (BlockState)blockState.setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)wallDirection.getOpposite());
    }

    public static ItemStack enchantRandomly(RegistryAccess registryAccess, RandomSource random, ItemStack itemToEnchant, float chance) {
        List<Holder.Reference> list;
        if (random.nextFloat() < chance && !(list = registryAccess.lookupOrThrow(Registries.ENCHANTMENT).listElements().filter(holder -> ((Enchantment)holder.value()).canEnchant(itemToEnchant) && holder.is(EnchantmentTags.ON_MOB_SPAWN_EQUIPMENT)).toList()).isEmpty()) {
            Holder.Reference enchantment = list.get(random.nextInt(list.size()));
            int enchantmentLevel = random.nextInt(Mth.nextInt((RandomSource)random, (int)((Enchantment)enchantment.value()).getMinLevel(), (int)((Enchantment)enchantment.value()).getMaxLevel()) + 1);
            itemToEnchant.enchant((Holder)enchantment, enchantmentLevel);
        }
        return itemToEnchant;
    }

    public static int getMaxTerrainLimit(ChunkGenerator chunkGenerator) {
        return chunkGenerator.getMinY() + chunkGenerator.getGenDepth();
    }

    public static BlockPos getHighestLand(ChunkGenerator chunkGenerator, RandomState randomState, BoundingBox boundingBox, LevelHeightAccessor heightLimitView, boolean canBeOnLiquid) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos().set(boundingBox.getCenter().getX(), GeneralUtils.getMaxTerrainLimit(chunkGenerator) - 40, boundingBox.getCenter().getZ());
        NoiseColumn blockView = chunkGenerator.getBaseColumn(mutable.getX(), mutable.getZ(), heightLimitView, randomState);
        while (mutable.getY() > chunkGenerator.getSeaLevel()) {
            BlockState currentBlockstate = blockView.getBlock(mutable.getY());
            if (!currentBlockstate.canOcclude()) {
                mutable.move(Direction.DOWN);
                continue;
            }
            if (blockView.getBlock(mutable.getY() + 3).isAir() && (canBeOnLiquid ? !currentBlockstate.isAir() : currentBlockstate.canOcclude())) {
                return mutable;
            }
            mutable.move(Direction.DOWN);
        }
        return mutable;
    }

    public static BlockPos getLowestLand(ChunkGenerator chunkGenerator, RandomState randomState, BoundingBox boundingBox, LevelHeightAccessor heightLimitView, boolean canBeOnLiquid) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos().set(boundingBox.getCenter().getX(), chunkGenerator.getSeaLevel() + 1, boundingBox.getCenter().getZ());
        NoiseColumn blockView = chunkGenerator.getBaseColumn(mutable.getX(), mutable.getZ(), heightLimitView, randomState);
        BlockState currentBlockstate = blockView.getBlock(mutable.getY());
        while (mutable.getY() <= GeneralUtils.getMaxTerrainLimit(chunkGenerator) - 40) {
            if ((canBeOnLiquid ? !currentBlockstate.isAir() : currentBlockstate.canOcclude()) && blockView.getBlock(mutable.getY() + 1).isAir() && blockView.getBlock(mutable.getY() + 5).isAir()) {
                mutable.move(Direction.UP);
                return mutable;
            }
            mutable.move(Direction.UP);
            currentBlockstate = blockView.getBlock(mutable.getY());
        }
        return mutable.set(mutable.getX(), chunkGenerator.getSeaLevel(), mutable.getZ());
    }

    public static int getFirstLandYFromPos(LevelReader worldView, BlockPos pos) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        mutable.set((Vec3i)pos);
        ChunkAccess currentChunk = worldView.getChunk((BlockPos)mutable);
        BlockState currentState = currentChunk.getBlockState((BlockPos)mutable);
        while (mutable.getY() >= worldView.getMinY() && GeneralUtils.isReplaceableByStructures(currentState)) {
            mutable.move(Direction.DOWN);
            currentState = currentChunk.getBlockState((BlockPos)mutable);
        }
        return mutable.getY();
    }

    private static boolean isReplaceableByStructures(BlockState blockState) {
        return blockState.isAir() || !blockState.getFluidState().isEmpty() || blockState.is(BlockTags.REPLACEABLE_BY_TREES);
    }

    public static void centerAllPieces(BlockPos targetPos, List<? extends StructurePiece> pieces) {
        if (pieces.isEmpty()) {
            return;
        }
        BlockPos structureCenter = pieces.get(0).getBoundingBox().getCenter();
        int xOffset = targetPos.getX() - structureCenter.getX();
        int zOffset = targetPos.getZ() - structureCenter.getZ();
        for (StructurePiece structurePiece : pieces) {
            structurePiece.move(xOffset, 0, zOffset);
        }
    }

    public static void movePieceProperly(StructurePiece piece, int x, int y, int z) {
        piece.move(x, y, z);
        if (piece instanceof PoolElementStructurePiece) {
            PoolElementStructurePiece poolElementStructurePiece = (PoolElementStructurePiece)piece;
            poolElementStructurePiece.getJunctions().forEach(junction -> {
                ((JigsawJunctionAccessor)junction).repurposedstructures$setSourceX(junction.getSourceX() + x);
                ((JigsawJunctionAccessor)junction).repurposedstructures$setSourceGroundY(junction.getSourceGroundY() + y);
                ((JigsawJunctionAccessor)junction).repurposedstructures$setSourceZ(junction.getSourceZ() + z);
            });
        }
    }

    public static boolean canJigsawsAttach(StructureTemplate.JigsawBlockInfo jigsaw1, StructureTemplate.JigsawBlockInfo jigsaw2) {
        FrontAndTop prop1 = (FrontAndTop)jigsaw1.info().state().getValue((Property)JigsawBlock.ORIENTATION);
        FrontAndTop prop2 = (FrontAndTop)jigsaw2.info().state().getValue((Property)JigsawBlock.ORIENTATION);
        return prop1.front() == prop2.front().getOpposite() && (prop1.top() == prop2.top() || GeneralUtils.isRollableJoint(jigsaw1, prop1)) && jigsaw1.info().nbt().getStringOr("target", "").equals(jigsaw2.info().nbt().getStringOr("name", ""));
    }

    private static boolean isRollableJoint(StructureTemplate.JigsawBlockInfo jigsaw1, FrontAndTop prop1) {
        String joint = jigsaw1.info().nbt().getStringOr("joint", "");
        if (!joint.equals("rollable") && !joint.equals("aligned")) {
            return !prop1.front().getAxis().isHorizontal();
        }
        return joint.equals("rollable");
    }

    public static Map<ResourceLocation, JsonElement> getDatapacksJSONElement(ResourceManager resourceManager, Gson gson, String dataType, int fileSuffixLength) {
        HashMap<ResourceLocation, JsonElement> map = new HashMap<ResourceLocation, JsonElement>();
        int dataTypeLength = dataType.length() + 1;
        for (Map.Entry resourceStackEntry : resourceManager.listResources(dataType, fileString -> true).entrySet()) {
            String identifierPath = ((ResourceLocation)resourceStackEntry.getKey()).getPath();
            ResourceLocation fileID = ResourceLocation.fromNamespaceAndPath((String)((ResourceLocation)resourceStackEntry.getKey()).getNamespace(), (String)identifierPath.substring(dataTypeLength, identifierPath.length() - fileSuffixLength));
            try {
                InputStream fileStream = ((Resource)resourceStackEntry.getValue()).open();
                try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileStream, StandardCharsets.UTF_8));){
                    JsonElement countsJSONElement = (JsonElement)GsonHelper.fromJson((Gson)gson, (Reader)bufferedReader, JsonElement.class);
                    map.put(fileID, countsJSONElement);
                }
            }
            catch (JsonParseException | IOException | IllegalArgumentException exception) {
                RepurposedStructures.LOGGER.error("(Repurposed Structures {} MERGER) Couldn't parse data file {} from {}", (Object)dataType, (Object)fileID, resourceStackEntry, (Object)exception);
            }
        }
        return map;
    }

    public static boolean isInvalidLootTableFound(MinecraftServer minecraftServer, Map.Entry<ResourceKey<LootTable>, ResourceKey<LootTable>> entry) {
        boolean invalidLootTableFound = false;
        HolderLookup.RegistryLookup lootTableRegistry = minecraftServer.reloadableRegistries().lookup().lookupOrThrow(Registries.LOOT_TABLE);
        if (lootTableRegistry.get(entry.getKey()).isEmpty()) {
            RepurposedStructures.LOGGER.error("Unable to find loot table key: {}", entry.getKey());
            invalidLootTableFound = true;
        }
        if (lootTableRegistry.get(entry.getValue()).isEmpty()) {
            RepurposedStructures.LOGGER.error("Unable to find loot table value: {}", entry.getValue());
            invalidLootTableFound = true;
        }
        return invalidLootTableFound;
    }

    public static boolean isMissingLootImporting(MinecraftServer minecraftServer, Set<ResourceKey<LootTable>> tableKeys) {
        AtomicBoolean invalidLootTableFound = new AtomicBoolean(false);
        Registry lootTableRegistry = (Registry)minecraftServer.reloadableRegistries().lookup().lookupOrThrow(Registries.LOOT_TABLE);
        lootTableRegistry.keySet().forEach(rl -> {
            ResourceKey key = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)rl);
            if (rl.getNamespace().equals("repurposed_structures") && !tableKeys.contains(key)) {
                if (rl.getPath().contains("mansions") && rl.getPath().contains("storage")) {
                    return;
                }
                if (rl.getPath().contains("monuments")) {
                    return;
                }
                if (rl.getPath().contains("dispensers/temples/wasteland_lava")) {
                    return;
                }
                if (rl.getPath().contains("lucky_pool")) {
                    return;
                }
                if (rl.getPath().contains("archaeology")) {
                    return;
                }
                RepurposedStructures.LOGGER.error("No loot importing found for: {}", rl);
                invalidLootTableFound.set(true);
            }
        });
        return invalidLootTableFound.get();
    }

    public static boolean nameMatch(String biomeName, String ... targetMatch) {
        return Arrays.stream(targetMatch).anyMatch(biomeName::contains);
    }

    public static boolean nameExactMatch(String biomeName, String ... targetMatch) {
        return Arrays.asList(targetMatch).contains(biomeName);
    }

    public static BlockState copyBlockProperties(BlockState oldBlockState, BlockState newBlockState) {
        for (Property property : oldBlockState.getProperties()) {
            if (!newBlockState.hasProperty(property)) continue;
            newBlockState = GeneralUtils.getStateWithProperty(newBlockState, oldBlockState, property);
        }
        return newBlockState;
    }

    public static <T extends Comparable<T>> BlockState getStateWithProperty(BlockState state, BlockState stateToCopy, Property<T> property) {
        return (BlockState)state.setValue(property, stateToCopy.getValue(property));
    }

    public static List<StructureStart> inboundsValidStartsForAllStructure(WorldGenRegion level, BlockPos position, Predicate<Structure> structureMatch) {
        StructureManager structureManager = level.getLevel().structureManager();
        SectionPos sectionPos = SectionPos.of((BlockPos)position);
        ChunkAccess chunkAccess = level.getChunk(sectionPos.x(), sectionPos.z(), ChunkStatus.STRUCTURE_REFERENCES);
        if (!chunkAccess.getHighestGeneratedStatus().isOrAfter(ChunkStatus.STRUCTURE_REFERENCES)) {
            return new ArrayList<StructureStart>();
        }
        Map references = chunkAccess.getAllReferences();
        ArrayList<StructureStart> list = new ArrayList<StructureStart>();
        for (Map.Entry entry : references.entrySet()) {
            if (!structureMatch.test((Structure)entry.getKey())) continue;
            GeneralUtils.fillStartsForStructure((LevelReader)level, structureManager, (Structure)entry.getKey(), (LongSet)entry.getValue(), position, list::add);
        }
        return list;
    }

    public static void fillStartsForStructure(LevelReader level, StructureManager structureManager, Structure structure, LongSet references, BlockPos position, Consumer<StructureStart> consumer) {
        LongIterator longIterator = references.iterator();
        while (longIterator.hasNext()) {
            StructureStart structureStart;
            long ref = (Long)longIterator.next();
            SectionPos sectionPos = SectionPos.of((ChunkPos)new ChunkPos(ref), (int)level.getMinY());
            if (!level.hasChunk(sectionPos.x(), sectionPos.z()) || (structureStart = structureManager.getStartForStructure(sectionPos, structure, (StructureAccess)level.getChunk(sectionPos.x(), sectionPos.z(), ChunkStatus.STRUCTURE_STARTS))) == null || !structureStart.isValid() || !structureStart.getBoundingBox().isInside((Vec3i)position)) continue;
            consumer.accept(structureStart);
        }
    }

    public static int getCachedFreeHeight(ChunkGenerator chunkGenerator, int x, int z, Heightmap.Types types, LevelHeightAccessor levelHeightAccessor, RandomState randomState) {
        HeightKey key = new HeightKey(chunkGenerator, x, z);
        Integer y = CACHED_HEIGHT.get(key);
        if (y == null) {
            if (CACHED_HEIGHT.size() >= 2048) {
                CACHED_HEIGHT.clear();
            }
            y = chunkGenerator.getFirstFreeHeight(x, z, types, levelHeightAccessor, randomState);
            CACHED_HEIGHT.put(key, y);
        }
        return y;
    }

    private record HeightKey(ChunkGenerator chunkGenerator, int x, int z) {
    }
}

