/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.mixins.features;

import com.telepathicgrunt.repurposedstructures.modinit.RSTags;
import com.telepathicgrunt.repurposedstructures.utils.GeneralUtils;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.LakeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.BlockStateConfiguration;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LakeFeature.class})
public class NoLakesInStructuresMixin {
    @Inject(method={"place(Lnet/minecraft/world/level/levelgen/feature/FeaturePlaceContext;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void repurposedstructures_noLakesInStructures(FeaturePlaceContext<BlockStateConfiguration> context, CallbackInfoReturnable<Boolean> cir) {
        WorldGenLevel worldGenLevel = context.level();
        if (!(worldGenLevel instanceof WorldGenRegion)) {
            return;
        }
        WorldGenRegion worldGenRegion = (WorldGenRegion)worldGenLevel;
        Registry structureRegistry = worldGenRegion.registryAccess().lookupOrThrow(Registries.STRUCTURE);
        List<StructureStart> structureStarts = GeneralUtils.inboundsValidStartsForAllStructure(worldGenRegion, context.origin(), struct -> ((Holder.Reference)structureRegistry.get((ResourceKey)structureRegistry.getResourceKey(struct).get()).get()).is(RSTags.NO_LAKES));
        if (!structureStarts.isEmpty()) {
            cir.setReturnValue((Object)false);
            return;
        }
    }
}

