/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.misc.maptrades;

import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import com.telepathicgrunt.repurposedstructures.mixins.entities.MerchantOfferAccessor;
import com.telepathicgrunt.repurposedstructures.mixins.items.MapItemAccessor;
import com.telepathicgrunt.repurposedstructures.utils.AsyncLocator;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.saveddata.maps.MapDecorationType;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;

public class MerchantMapUpdating {
    private MerchantMapUpdating() {
    }

    public static void invalidateMap(AbstractVillager merchant, ItemStack mapStack) {
        mapStack.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)"item.minecraft.map"));
        merchant.getOffers().stream().filter(offer -> offer.getResult() == mapStack).findFirst().ifPresentOrElse(offer -> MerchantMapUpdating.removeOffer(merchant, offer), () -> RepurposedStructures.LOGGER.warn("Failed to find merchant offer for map"));
    }

    public static void removeOffer(AbstractVillager merchant, MerchantOffer offer) {
        ((MerchantOfferAccessor)offer).repurposedstructures$setMaxUses(0);
        offer.setToOutOfStock();
    }

    public static void handleLocationFound(ServerLevel level, AbstractVillager merchant, ItemStack mapStack, String displayName, Holder.Reference<MapDecorationType> destinationType, BlockPos pos) {
        if (pos == null) {
            MerchantMapUpdating.invalidateMap(merchant, mapStack);
        } else {
            MerchantMapUpdating.updateMap(mapStack, level, pos, 2, destinationType, displayName);
        }
        Player player = merchant.getTradingPlayer();
        if (player instanceof ServerPlayer) {
            int n;
            ServerPlayer tradingPlayer = (ServerPlayer)player;
            int n2 = tradingPlayer.containerMenu.containerId;
            MerchantOffers merchantOffers = merchant.getOffers();
            if (merchant instanceof Villager) {
                Villager villager = (Villager)merchant;
                n = villager.getVillagerData().level();
            } else {
                n = 1;
            }
            tradingPlayer.sendMerchantOffers(n2, merchantOffers, n, merchant.getVillagerXp(), merchant.showProgressBar(), merchant.canRestock());
        }
    }

    public static MerchantOffer updateMapAsync(Entity pTrader, int emeraldCost, String displayName, Holder.Reference<MapDecorationType> destinationType, int maxUses, int villagerXp, TagKey<Structure> destination, int searchRadius) {
        return MerchantMapUpdating.updateMapAsyncInternal(pTrader, emeraldCost, maxUses, villagerXp, (level, merchant, mapStack) -> AsyncLocator.locate(level, destination, merchant.blockPosition(), searchRadius, true).thenOnServerThread(pos -> MerchantMapUpdating.handleLocationFound(level, merchant, mapStack, displayName, destinationType, pos)));
    }

    public static MerchantOffer updateMapAsync(Entity pTrader, int emeraldCost, String displayName, Holder.Reference<MapDecorationType> destinationType, int maxUses, int villagerXp, HolderSet<Structure> structureSet, int searchRadius) {
        return MerchantMapUpdating.updateMapAsyncInternal(pTrader, emeraldCost, maxUses, villagerXp, (level, merchant, mapStack) -> AsyncLocator.locate(level, structureSet, merchant.blockPosition(), searchRadius, true).thenOnServerThread(pair -> MerchantMapUpdating.handleLocationFound(level, merchant, mapStack, displayName, destinationType, pair == null ? null : (BlockPos)pair.getFirst())));
    }

    private static MerchantOffer updateMapAsyncInternal(Entity trader, int emeraldCost, int maxUses, int villagerXp, MapUpdateTask task) {
        if (trader instanceof AbstractVillager) {
            AbstractVillager merchant = (AbstractVillager)trader;
            ItemStack mapStack = MerchantMapUpdating.createEmptyMap();
            task.apply((ServerLevel)trader.level(), merchant, mapStack);
            return new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, emeraldCost), Optional.of(new ItemCost((ItemLike)Items.COMPASS, 1)), mapStack, maxUses, villagerXp, 0.2f);
        }
        return null;
    }

    public static ItemStack createEmptyMap() {
        ItemStack stack = new ItemStack((ItemLike)Items.FILLED_MAP);
        stack.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)"Locating... (Do not buy this map until finished)"));
        return stack;
    }

    public static void updateMap(ItemStack mapStack, ServerLevel level, BlockPos pos, int scale, Holder.Reference<MapDecorationType> destinationType, String displayName) {
        MapId mapId = MapItemAccessor.repurposedstructures$callCreateNewSavedData(level, pos.getX(), pos.getZ(), scale, true, true, (ResourceKey<Level>)level.dimension());
        mapStack.set(DataComponents.MAP_ID, (Object)mapId);
        MapItem.renderBiomePreviewMap((ServerLevel)level, (ItemStack)mapStack);
        MapItemSavedData.addTargetDecoration((ItemStack)mapStack, (BlockPos)pos, (String)"+", destinationType);
        if (displayName != null) {
            mapStack.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)displayName));
        }
    }

    public static interface MapUpdateTask {
        public void apply(ServerLevel var1, AbstractVillager var2, ItemStack var3);
    }
}

