/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective_common_neoforge.implementations.networking.api;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.LevelChunk;

public interface NetworkHandler {
    public <T> void sendToServer(T var1);

    public <T> void sendToServer(T var1, boolean var2);

    public <T> void sendToClient(T var1, ServerPlayer var2);

    default public <T> void sendToClients(T packet, List<ServerPlayer> players) {
        for (ServerPlayer player : players) {
            this.sendToClient(packet, player);
        }
    }

    default public <T> void sendToAllClients(T packet, MinecraftServer server) {
        this.sendToClients(packet, server.getPlayerList().getPlayers());
    }

    default public <T> void sendToClientsInLevel(T packet, ServerLevel level) {
        this.sendToClients(packet, level.players());
    }

    default public <T> void sendToClientsLoadingChunk(T packet, LevelChunk chunk) {
        ServerChunkCache chunkCache = (ServerChunkCache)chunk.getLevel().getChunkSource();
        this.sendToClients(packet, chunkCache.chunkMap.getPlayers(chunk.getPos(), false));
    }

    default public <T> void sendToClientsLoadingPos(T packet, ServerLevel level, ChunkPos pos) {
        this.sendToClientsLoadingChunk(packet, level.getChunk(pos.x, pos.z));
    }

    default public <T> void sendToClientsLoadingPos(T packet, ServerLevel level, BlockPos pos) {
        this.sendToClientsLoadingPos(packet, level, new ChunkPos(pos));
    }

    default public <T> void sendToClientsInRange(T packet, ServerLevel level, BlockPos pos, double range) {
        for (ServerPlayer player : level.players()) {
            if (!(player.distanceToSqr((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()) <= range * range)) continue;
            this.sendToClient(packet, player);
        }
    }
}

