/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.worldgen;

import com.mojang.serialization.Codec;
import dev.worldgen.lithostitched.Lithostitched;
import java.util.function.Function;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.NoiseRouter;

public enum NoiseRouterTarget implements StringRepresentable
{
    BARRIER("barrier", NoiseRouter::barrierNoise),
    FLUID_LEVEL_FLOODEDNESS("fluid_level_floodedness", NoiseRouter::fluidLevelFloodednessNoise),
    FLUID_LEVEL_SPREAD("fluid_level_spread", NoiseRouter::fluidLevelSpreadNoise),
    LAVA("lava", NoiseRouter::lavaNoise),
    TEMPERATURE("temperature", NoiseRouter::temperature),
    VEGETATION("vegetation", NoiseRouter::vegetation),
    CONTINENTS("continents", NoiseRouter::continents),
    EROSION("erosion", NoiseRouter::erosion),
    DEPTH("depth", NoiseRouter::depth),
    RIDGES("ridges", NoiseRouter::ridges),
    INITIAL_DENSITY("initial_density_without_jaggedness", Lithostitched::getInitialDensity),
    FINAL_DENSITY("final_density", NoiseRouter::finalDensity),
    VEIN_TOGGLE("vein_toggle", NoiseRouter::veinToggle),
    VEIN_RIDGED("vein_ridged", NoiseRouter::veinRidged),
    VEIN_GAP("vein_gap", NoiseRouter::veinGap);

    public static final Codec<NoiseRouterTarget> CODEC;
    private final String name;
    private final Function<NoiseRouter, DensityFunction> getter;

    private NoiseRouterTarget(String name, Function<NoiseRouter, DensityFunction> getter) {
        this.name = name.equals("initial_density") ? Lithostitched.getInitialDensityName() : name;
        this.getter = getter;
    }

    public DensityFunction getDensityFunction(NoiseRouter router) {
        return this.getter.apply(router);
    }

    public String getSerializedName() {
        return this.name;
    }

    static {
        CODEC = StringRepresentable.fromEnum(NoiseRouterTarget::values);
    }
}

