/*
 * Decompiled with CFR 0.152.
 */
package net.salju.kobolds.worldgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.QuartPos;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.CheckerboardColumnBiomeSource;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pools.DimensionPadding;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.pools.alias.PoolAliasLookup;
import net.minecraft.world.level.levelgen.structure.structures.JigsawStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;
import net.salju.kobolds.init.KoboldsStructures;
import net.salju.kobolds.init.KoboldsTags;

public class AbstractKoboldStructure
extends Structure {
    public static final MapCodec<AbstractKoboldStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)AbstractKoboldStructure.settingsCodec((RecordCodecBuilder.Instance)instance), (App)StructureTemplatePool.CODEC.fieldOf("start_pool").forGetter(structure -> structure.startPool), (App)ResourceLocation.CODEC.optionalFieldOf("start_jigsaw_name").forGetter(structure -> structure.jiggy), (App)HeightProvider.CODEC.fieldOf("start_height").forGetter(structure -> structure.startHeight), (App)Heightmap.Types.CODEC.optionalFieldOf("project_start_to_heightmap").forGetter(structure -> structure.heightmap), (App)DimensionPadding.CODEC.optionalFieldOf("dimension_padding", (Object)JigsawStructure.DEFAULT_DIMENSION_PADDING).forGetter(structure -> structure.dims), (App)LiquidSettings.CODEC.optionalFieldOf("liquid_settings", (Object)JigsawStructure.DEFAULT_LIQUID_SETTINGS).forGetter(structure -> structure.water), (App)RegistryCodecs.homogeneousList((ResourceKey)Registries.BIOME).optionalFieldOf("surface_biomes").forGetter(structure -> structure.underBiomes)).apply((Applicative)instance, AbstractKoboldStructure::new));
    private final Holder<StructureTemplatePool> startPool;
    private final Optional<ResourceLocation> jiggy;
    private final HeightProvider startHeight;
    private final Optional<Heightmap.Types> heightmap;
    private final DimensionPadding dims;
    private final LiquidSettings water;
    private final Optional<HolderSet<Biome>> underBiomes;

    public AbstractKoboldStructure(Structure.StructureSettings config, Holder<StructureTemplatePool> pool, Optional<ResourceLocation> jigsaw, HeightProvider height, Optional<Heightmap.Types> map, DimensionPadding d, LiquidSettings w, Optional<HolderSet<Biome>> under) {
        super(config);
        this.startPool = pool;
        this.jiggy = jigsaw;
        this.startHeight = height;
        this.heightmap = map;
        this.dims = d;
        this.water = w;
        this.underBiomes = under;
    }

    public Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext context) {
        BlockPos pos = new BlockPos(context.chunkPos().getMinBlockX(), this.startHeight.sample((RandomSource)context.random(), new WorldGenerationContext(context.chunkGenerator(), context.heightAccessor())), context.chunkPos().getMinBlockZ());
        if (!this.underCheck(context, pos) || this.waterCheck(context, pos)) {
            return Optional.empty();
        }
        return JigsawPlacement.addPieces((Structure.GenerationContext)context, this.startPool, this.jiggy, (int)7, (BlockPos)pos, (boolean)false, this.heightmap, (JigsawStructure.MaxDistance)new JigsawStructure.MaxDistance(120), (PoolAliasLookup)PoolAliasLookup.EMPTY, (DimensionPadding)this.dims, (LiquidSettings)this.water);
    }

    public StructureType<?> type() {
        return (StructureType)KoboldsStructures.KOBOLD_DEN.get();
    }

    protected boolean underCheck(Structure.GenerationContext context, BlockPos pos) {
        if (!(context.biomeSource() instanceof CheckerboardColumnBiomeSource)) {
            for (int x = context.chunkPos().x - 1; x <= context.chunkPos().x + 1; ++x) {
                for (int z = context.chunkPos().z - 1; z <= context.chunkPos().z + 1; ++z) {
                    Holder biome = context.biomeSource().getNoiseBiome(QuartPos.fromSection((int)x), QuartPos.fromBlock((int)pos.getY()), QuartPos.fromSection((int)z), context.randomState().sampler());
                    if (!(this.underBiomes.isPresent() ? this.underBiomes.get().contains(biome) : biome.is(KoboldsTags.BIOMES))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected boolean waterCheck(Structure.GenerationContext context, BlockPos pos) {
        if (!(context.biomeSource() instanceof CheckerboardColumnBiomeSource)) {
            for (int x = context.chunkPos().x - 3; x <= context.chunkPos().x + 3; ++x) {
                for (int z = context.chunkPos().z - 3; z <= context.chunkPos().z + 3; ++z) {
                    Holder biome = context.biomeSource().getNoiseBiome(QuartPos.fromSection((int)x), QuartPos.fromBlock((int)pos.getY()), QuartPos.fromSection((int)z), context.randomState().sampler());
                    if (!biome.is(BiomeTags.IS_RIVER) && !biome.is(BiomeTags.IS_OCEAN)) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

