/*
 * Decompiled with CFR 0.152.
 */
package net.salju.kobolds.client.renderer.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.EyesLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.salju.kobolds.client.model.KoboldModel;
import net.salju.kobolds.client.renderer.AbstractKoboldState;

public class KoboldEyesLayer<S extends AbstractKoboldState, M extends KoboldModel<S>>
extends EyesLayer<S, M> {
    public KoboldEyesLayer(RenderLayerParent<S, M> parent) {
        super(parent);
    }

    public void submit(PoseStack pose, SubmitNodeCollector buffer, int i, S kobold, float f1, float f2) {
        buffer.order(1).submitModel((Model)this.getParentModel(), kobold, pose, this.renderSpecialType(this.getKoboldEyes((AbstractKoboldState)((Object)kobold))), i, OverlayTexture.NO_OVERLAY, -1, null, ((AbstractKoboldState)((Object)kobold)).outlineColor, null);
    }

    public RenderType renderType() {
        return RenderType.eyes((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"kobolds", (String)"textures/entity/eyes/base.png"));
    }

    public RenderType renderSpecialType(String type) {
        if (!type.isEmpty()) {
            return RenderType.eyes((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"kobolds", (String)("textures/entity/eyes/" + type + ".png")));
        }
        return this.renderType();
    }

    public String getKoboldEyes(AbstractKoboldState kobold) {
        if (kobold.isDiamond) {
            return "diamond";
        }
        if (kobold.texture.getPath().contains("popper")) {
            return "popper";
        }
        if (kobold.dragonColor >= 1) {
            return "dragon/" + kobold.dragonColor;
        }
        return "base";
    }
}

