/*
 * Decompiled with CFR 0.152.
 */
package net.salju.kobolds.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.HumanoidMobRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.ArmedEntityRenderState;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.salju.kobolds.client.model.RascalModel;
import net.salju.kobolds.client.renderer.AbstractKoboldState;
import net.salju.kobolds.client.renderer.layers.KoboldEyesLayer;
import net.salju.kobolds.entity.AbstractKoboldEntity;
import net.salju.kobolds.init.KoboldsClient;

public class KoboldRascalRenderer
extends MobRenderer<AbstractKoboldEntity, AbstractKoboldState, RascalModel<AbstractKoboldState>> {
    public KoboldRascalRenderer(EntityRendererProvider.Context context) {
        super(context, new RascalModel(context.bakeLayer(KoboldsClient.KOBOLD_RASCAL)), 0.36f);
        this.addLayer((RenderLayer)new KoboldEyesLayer(this));
        this.addLayer((RenderLayer)new ItemInHandLayer<AbstractKoboldState, RascalModel<AbstractKoboldState>>(this, (RenderLayerParent)this){

            public void submit(PoseStack pose, SubmitNodeCollector buffer, int i, AbstractKoboldState kobold, float f1, float f2) {
                if (kobold.isAggressive) {
                    super.submit(pose, buffer, i, (ArmedEntityRenderState)kobold, f1, f2);
                }
            }
        });
    }

    public ResourceLocation getTextureLocation(AbstractKoboldState kobold) {
        return kobold.texture;
    }

    public AbstractKoboldState createRenderState() {
        return new AbstractKoboldState();
    }

    public void extractRenderState(AbstractKoboldEntity kobold, AbstractKoboldState state, float f1) {
        super.extractRenderState((LivingEntity)kobold, (LivingEntityRenderState)state, f1);
        HumanoidMobRenderer.extractHumanoidRenderState((LivingEntity)kobold, (HumanoidRenderState)state, (float)f1, (ItemModelResolver)this.itemModelResolver);
        state.texture = ResourceLocation.fromNamespaceAndPath((String)"kobolds", (String)("textures/entity/" + this.getKoboldType(kobold) + ".png"));
        state.isAggressive = kobold.isAggressive();
        state.isDiamond = kobold.isDiamond();
        state.isLeftHanded = kobold.isLeftHanded();
        state.rightStack = kobold.getItemHeldByArm(HumanoidArm.RIGHT);
        state.leftStack = kobold.getItemHeldByArm(HumanoidArm.LEFT);
        state.dragonColor = kobold.getDragonColor();
    }

    public void submit(AbstractKoboldState kobold, PoseStack pose, SubmitNodeCollector buffer, CameraRenderState c) {
        pose.pushPose();
        pose.translate(-0.025, 0.0, 0.0);
        float scale = 0.875f;
        pose.scale(scale, scale, scale);
        super.submit((LivingEntityRenderState)kobold, pose, buffer, c);
        pose.popPose();
    }

    public String getKoboldType(AbstractKoboldEntity kobold) {
        if (kobold.getDragonColor() >= 1) {
            return "special/dragon/rascal/" + kobold.getDragonColor();
        }
        return "kobolds/rascal";
    }
}

