/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.comforts.common;

import com.illusivesoulworks.comforts.common.ComfortsEvents;
import com.illusivesoulworks.spectrelib.config.SpectreConfigSpec;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.tuple.Pair;

public class ComfortsConfig {
    public static final SpectreConfigSpec SERVER_SPEC;
    public static final Server SERVER;
    public static final SpectreConfigSpec COMMON_SPEC;
    public static final Common COMMON;
    private static final String CONFIG_PREFIX = "gui.comforts.config.";

    public static void reload() {
        ComfortsEvents.effectsInitialized = false;
    }

    static {
        Pair specPair1 = new SpectreConfigSpec.Builder().configure(Server::new);
        SERVER_SPEC = (SpectreConfigSpec)specPair1.getRight();
        SERVER = (Server)specPair1.getLeft();
        Pair specPair2 = new SpectreConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (SpectreConfigSpec)specPair2.getRight();
        COMMON = (Common)specPair2.getLeft();
    }

    public static class Server {
        public final SpectreConfigSpec.BooleanValue autoUse;
        public final SpectreConfigSpec.BooleanValue restrictSleeping;
        public final SpectreConfigSpec.DoubleValue restMultiplier;
        public final SpectreConfigSpec.EnumValue<ComfortsTimeUse> hammockUse;
        public final SpectreConfigSpec.EnumValue<ComfortsTimeUse> sleepingBagUse;
        public final SpectreConfigSpec.IntValue daySleepingPercentage;
        public final SpectreConfigSpec.IntValue dayWakeTimeOffset;
        public final SpectreConfigSpec.IntValue nightWakeTimeOffset;
        public final SpectreConfigSpec.BooleanValue sleepingBagsStopPhantoms;
        public final SpectreConfigSpec.BooleanValue hammocksStopPhantoms;
        public final SpectreConfigSpec.IntValue sleepingBagBreakChance;
        public final SpectreConfigSpec.DoubleValue sleepingBagBreakChanceLuckMultiplier;
        public final SpectreConfigSpec.ConfigValue<List<? extends String>> sleepingBagEffects;

        public Server(SpectreConfigSpec.Builder builder) {
            this.autoUse = builder.comment("If enabled, players automatically attempt to use sleeping bags when placed.").translation("gui.comforts.config.autoUse").define("autoUse", true);
            this.restrictSleeping = builder.comment("If enabled, players cannot sleep again for a period of time after sleeping.").translation("gui.comforts.config.restrictSleeping").define("restrictSleeping", false);
            this.restMultiplier = builder.comment("If restrictSleeping is true, this value will determine the length of wait time (larger numbers sleep sooner).").translation("gui.comforts.config.restMultiplier").defineInRange("restMultiplier", 2.0, 1.0, 20.0);
            this.hammockUse = builder.comment("The time of day that hammocks can be used.").translation("gui.comforts.config.hammockUse").defineEnum("hammockUse", (Enum)ComfortsTimeUse.DAY);
            this.sleepingBagUse = builder.comment("The time of day that sleeping bags can be used.").translation("gui.comforts.config.sleepingBagUse").defineEnum("sleepingBagUse", (Enum)ComfortsTimeUse.NIGHT);
            this.daySleepingPercentage = builder.comment("What percentage of players must sleep to skip the day.\nA percentage value of 0 will allow the day to be skipped by just 1 player, and a percentage value of 100 will require all players to sleep before skipping the day.\nA value of less than 0 will default to the playerSleepingPercentage game rule.\n").translation("gui.comforts.config.daySleepingPercentage").defineInRange("daySleepingPercentage", -1, -1, 100);
            this.dayWakeTimeOffset = builder.comment("The amount of time, in ticks, to add or remove from the new time after sleeping through a night.").translation("gui.comforts.config.dayWakeTimeOffset").defineInRange("dayWakeTimeOffset", 0, -2000, 2000);
            this.nightWakeTimeOffset = builder.comment("The amount of time, in ticks, to add or remove from the new time after sleeping through a day.").translation("gui.comforts.config.nightWakeTimeOffset").defineInRange("nightWakeTimeOffset", 0, -2000, 2000);
            this.hammocksStopPhantoms = builder.comment("If enabled, attempting to sleep in hammocks stops phantoms from spawning.").translation("gui.comforts.config.hammocksStopPhantoms").define("hammocksStopPhantoms", true);
            this.sleepingBagsStopPhantoms = builder.comment("If enabled, attempting to sleep in sleeping bags stops phantoms from spawning.").translation("gui.comforts.config.sleepingBagsStopPhantoms").define("sleepingBagsStopPhantoms", true);
            this.sleepingBagBreakChance = builder.comment("The percentage chance that a sleeping bag will break upon use.").translation("gui.comforts.config.sleepingBagBreakChance").defineInRange("sleepingBagBreakChance", 0, 0, 100);
            this.sleepingBagBreakChanceLuckMultiplier = builder.comment("The value that will be multiplied by a player's luck then added to sleepingBagBreakChance.").translation("gui.comforts.config.sleepingBagBreakChanceLuckMultiplier").defineInRange("sleepingBagBreakChanceLuckMultiplier", 0.0, -1.0, 1.0);
            this.sleepingBagEffects = builder.comment("The status effects to apply to players after using the sleeping bag.\nFormat: effect;duration(secs);power").translation("gui.comforts.config.sleepingBagEffects").defineListAllowEmpty(List.of("sleepingBagEffects"), ArrayList::new, s -> {
                if (s instanceof String) {
                    String str = (String)s;
                    String[] split = str.split(";");
                    return split.length == 3 && ResourceLocation.tryParse((String)split[0]) != null && split[1].matches("\\d+") && split[2].matches("\\d+");
                }
                return false;
            });
        }
    }

    public static class Common {
        public final SpectreConfigSpec.BooleanValue enableHammockRecipes;
        public final SpectreConfigSpec.BooleanValue enableSleepingBagRecipes;

        public Common(SpectreConfigSpec.Builder builder) {
            this.enableHammockRecipes = builder.comment("If enabled, the default hammock recipes will be available.").translation("gui.comforts.config.enableHammockRecipes").define("enableHammockRecipes", true);
            this.enableSleepingBagRecipes = builder.comment("If enabled, the default sleeping bag recipes will be available.").translation("gui.comforts.config.enableSleepingBagRecipes").define("enableSleepingBagRecipes", true);
        }
    }

    public static enum ComfortsTimeUse {
        NONE((Component)Component.translatable((String)"item.comforts.no_sleep")),
        DAY((Component)Component.translatable((String)"item.comforts.hammock.no_sleep")),
        NIGHT((Component)Component.translatable((String)"block.minecraft.bed.no_sleep")),
        DAY_OR_NIGHT((Component)Component.translatable((String)"item.comforts.hammock.no_sleep.2"));

        private final Component message;

        private ComfortsTimeUse(Component message) {
            this.message = message;
        }

        public Component getMessage() {
            return this.message;
        }
    }
}

