/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.neoforge.client.rendering;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.blay09.mods.balm.api.client.rendering.BalmRenderers;
import net.blay09.mods.balm.common.NamespaceResolver;
import net.blay09.mods.balm.common.StaticNamespaceResolver;
import net.blay09.mods.balm.neoforge.ModBusEventRegisters;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;

public record NeoForgeBalmRenderers(NamespaceResolver namespaceResolver) implements BalmRenderers
{
    @Override
    public ModelLayerLocation registerModel(ResourceLocation location, String layer, Supplier<LayerDefinition> layerDefinition) {
        ModelLayerLocation modelLayerLocation = new ModelLayerLocation(location, layer);
        this.getActiveRegistrations().layerDefinitions.put(modelLayerLocation, layerDefinition);
        return modelLayerLocation;
    }

    @Override
    public <T extends Entity> void registerEntityRenderer(ResourceLocation identifier, Supplier<EntityType<T>> type, EntityRendererProvider<? super T> provider) {
        this.getActiveRegistrations().entityRenderers.add(Pair.of(type::get, provider));
    }

    @Override
    public <TBlockEntity extends BlockEntity, TBlockEntityRenderState extends BlockEntityRenderState> void registerBlockEntityRenderer(ResourceLocation identifier, Supplier<BlockEntityType<TBlockEntity>> type, BlockEntityRendererProvider<? super TBlockEntity, ? super TBlockEntityRenderState> provider) {
        this.getActiveRegistrations().blockEntityRenderers.add(Pair.of(type::get, provider));
    }

    @Override
    public void registerBlockColorHandler(ResourceLocation identifier, BlockColor color, Supplier<Block[]> blocks) {
        this.getActiveRegistrations().blockColors.add(new ColorRegistration(color, blocks));
    }

    @Override
    public void setBlockRenderType(Supplier<Block> block, ChunkSectionLayer renderType) {
        this.getActiveRegistrations().blockRenderTypes.add(new BlockRenderTypeRegistration(block, renderType));
    }

    @Override
    public <T extends ParticleOptions> void registerParticleProvider(ResourceLocation identifier, Supplier<ParticleType<T>> particleType, Function<SpriteSet, ParticleProvider<T>> factory) {
        this.getActiveRegistrations().particleProviderFactories.add(new ParticleProviderFactoryRegistration<T>(particleType, factory));
    }

    @Override
    public <T extends ParticleOptions> void registerParticleProvider(ResourceLocation identifier, Supplier<ParticleType<T>> particleType, ParticleProvider<T> provider) {
        this.getActiveRegistrations().particleProviders.add(new ParticleProviderRegistration<T>(particleType, provider));
    }

    @Override
    public BalmRenderers scoped(String modId) {
        return new NeoForgeBalmRenderers(new StaticNamespaceResolver(modId));
    }

    private Registrations getActiveRegistrations() {
        return ModBusEventRegisters.getRegistrations(this.namespaceResolver.getDefaultNamespace(), Registrations.class);
    }

    public static class Registrations {
        public final Map<ModelLayerLocation, Supplier<LayerDefinition>> layerDefinitions = new HashMap<ModelLayerLocation, Supplier<LayerDefinition>>();
        public final List<Pair<Supplier<BlockEntityType<?>>, BlockEntityRendererProvider<BlockEntity, BlockEntityRenderState>>> blockEntityRenderers = new ArrayList();
        public final List<Pair<Supplier<EntityType<?>>, EntityRendererProvider<Entity>>> entityRenderers = new ArrayList();
        public final List<ColorRegistration<BlockColor, Block>> blockColors = new ArrayList<ColorRegistration<BlockColor, Block>>();
        public final List<ParticleProviderFactoryRegistration<?>> particleProviderFactories = new ArrayList();
        public final List<ParticleProviderRegistration<?>> particleProviders = new ArrayList();
        public final List<BlockRenderTypeRegistration> blockRenderTypes = new ArrayList<BlockRenderTypeRegistration>();

        @SubscribeEvent
        public void setupClient(FMLClientSetupEvent event) {
            event.enqueueWork(() -> this.blockRenderTypes.forEach(blockRenderType -> ItemBlockRenderTypes.setRenderLayer((Block)blockRenderType.blockSupplier.get(), (ChunkSectionLayer)blockRenderType.renderType())));
        }

        @SubscribeEvent
        public void initRenderers(EntityRenderersEvent.RegisterRenderers event) {
            for (Pair<Supplier<BlockEntityType<?>>, BlockEntityRendererProvider<BlockEntity, BlockEntityRenderState>> pair : this.blockEntityRenderers) {
                event.registerBlockEntityRenderer((BlockEntityType)((Supplier)pair.getFirst()).get(), (BlockEntityRendererProvider)pair.getSecond());
            }
            for (Pair<Supplier<BlockEntityType<?>>, BlockEntityRendererProvider<BlockEntity, BlockEntityRenderState>> pair : this.entityRenderers) {
                event.registerEntityRenderer((EntityType)((Supplier)pair.getFirst()).get(), (EntityRendererProvider)pair.getSecond());
            }
        }

        @SubscribeEvent
        public void initLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
            for (Map.Entry<ModelLayerLocation, Supplier<LayerDefinition>> entry : this.layerDefinitions.entrySet()) {
                event.registerLayerDefinition(entry.getKey(), entry.getValue());
            }
        }

        @SubscribeEvent
        public void initBlockColors(RegisterColorHandlersEvent.Block event) {
            for (ColorRegistration<BlockColor, Block> blockColor : this.blockColors) {
                event.register(blockColor.color(), blockColor.objects().get());
            }
        }

        @SubscribeEvent
        public void initParticleProviders(RegisterParticleProvidersEvent event) {
            for (ParticleProviderFactoryRegistration<?> particleProviderFactoryRegistration : this.particleProviderFactories) {
                this.registerParticleProviderFactory(event, particleProviderFactoryRegistration);
            }
            for (ParticleProviderRegistration particleProviderRegistration : this.particleProviders) {
                this.registerParticleProvider(event, particleProviderRegistration);
            }
        }

        private <T extends ParticleOptions> void registerParticleProviderFactory(RegisterParticleProvidersEvent event, ParticleProviderFactoryRegistration<T> registration) {
            event.registerSpriteSet(registration.particleType.get(), spriteSet -> registration.value().apply(spriteSet));
        }

        private <T extends ParticleOptions> void registerParticleProvider(RegisterParticleProvidersEvent event, ParticleProviderRegistration<T> registration) {
            event.registerSpriteSet(registration.particleType.get(), spriteSet -> registration.value());
        }
    }

    public record ColorRegistration<THandler, TObject>(THandler color, Supplier<TObject[]> objects) {
    }

    public record BlockRenderTypeRegistration(Supplier<Block> blockSupplier, ChunkSectionLayer renderType) {
    }

    public record ParticleProviderFactoryRegistration<T extends ParticleOptions>(Supplier<ParticleType<T>> particleType, Function<SpriteSet, ParticleProvider<T>> value) {
    }

    public record ParticleProviderRegistration<T extends ParticleOptions>(Supplier<ParticleType<T>> particleType, ParticleProvider<T> value) {
    }
}

