/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.neoforge;

import java.util.function.BiFunction;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.capability.CapabilityType;
import net.blay09.mods.balm.api.container.BalmContainerProvider;
import net.blay09.mods.balm.api.energy.BalmEnergyStorageProvider;
import net.blay09.mods.balm.api.energy.EnergyStorage;
import net.blay09.mods.balm.api.fluid.BalmFluidTankProvider;
import net.blay09.mods.balm.api.fluid.FluidTank;
import net.blay09.mods.balm.common.BalmLoadContexts;
import net.blay09.mods.balm.common.CommonCapabilities;
import net.blay09.mods.balm.neoforge.DeferredRegisters;
import net.blay09.mods.balm.neoforge.ModBusEventRegisters;
import net.blay09.mods.balm.neoforge.NeoForgeBalmRuntime;
import net.blay09.mods.balm.neoforge.NeoForgeLoadContext;
import net.blay09.mods.balm.neoforge.capability.NeoForgeBalmCapabilities;
import net.blay09.mods.balm.neoforge.compat.hudinfo.TheOneProbeModCompat;
import net.blay09.mods.balm.neoforge.energy.NeoForgeEnergyStorage;
import net.blay09.mods.balm.neoforge.fluid.NeoForgeFluidTank;
import net.blay09.mods.balm.neoforge.world.NeoForgeBalmWorldGen;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.InterModEnqueueEvent;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.energy.EnergyHandler;
import net.neoforged.neoforge.transfer.fluid.FluidResource;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.item.VanillaContainerWrapper;
import net.neoforged.neoforge.transfer.item.WorldlyContainerWrapper;
import org.jetbrains.annotations.Nullable;

@Mod(value="balm")
public class NeoForgeBalm {
    public NeoForgeBalm(IEventBus modBus) {
        BalmLoadContexts.register("balm", new NeoForgeLoadContext(modBus));
        ((NeoForgeBalmRuntime)Balm.getRuntime()).initializeRuntime();
        DeferredRegisters.register("balm", modBus);
        ModBusEventRegisters.register("balm", modBus);
        NeoForgeBalmWorldGen.initializeBalmBiomeModifiers(modBus);
        modBus.addListener(this::enqueueIMC);
        NeoForgeBalmCapabilities capabilities = (NeoForgeBalmCapabilities)Balm.getCapabilities();
        CapabilityType nativeItemHandler = capabilities.addExistingType(ResourceLocation.fromNamespaceAndPath((String)"neoforge", (String)"item_handler"), Capabilities.Item.BLOCK);
        CapabilityType nativeFluidHandler = capabilities.addExistingType(ResourceLocation.fromNamespaceAndPath((String)"neoforge", (String)"fluid_handler"), Capabilities.Fluid.BLOCK);
        CapabilityType nativeEnergyStorage = capabilities.addExistingType(ResourceLocation.fromNamespaceAndPath((String)"neoforge", (String)"energy_storage"), Capabilities.Energy.BLOCK);
        capabilities.registerFallbackBlockEntityProvider(ResourceLocation.fromNamespaceAndPath((String)"balm", (String)"item_handler"), nativeItemHandler, new BiFunction<BlockEntity, Direction, ResourceHandler<ItemResource>>(this){
            private boolean running;

            @Override
            public ResourceHandler<ItemResource> apply(BlockEntity blockEntity, Direction direction) {
                if (this.running) {
                    return null;
                }
                if (blockEntity instanceof BalmContainerProvider) {
                    Container container;
                    BalmContainerProvider containerProvider = (BalmContainerProvider)blockEntity;
                    Container container2 = container = direction != null ? containerProvider.getContainer(direction) : containerProvider.getContainer();
                    if (container instanceof WorldlyContainer) {
                        WorldlyContainer worldlyContainer = (WorldlyContainer)container;
                        return new WorldlyContainerWrapper(worldlyContainer, direction);
                    }
                    if (container != null) {
                        return VanillaContainerWrapper.of((Container)container);
                    }
                } else if (blockEntity != null) {
                    this.running = true;
                    Container container = Balm.getCapabilities().getCapability(blockEntity, direction, CommonCapabilities.CONTAINER);
                    this.running = false;
                    if (container instanceof WorldlyContainer) {
                        WorldlyContainer worldlyContainer = (WorldlyContainer)container;
                        return new WorldlyContainerWrapper(worldlyContainer, direction);
                    }
                    if (container != null) {
                        return VanillaContainerWrapper.of((Container)container);
                    }
                }
                return null;
            }
        });
        capabilities.registerFallbackBlockEntityProvider(ResourceLocation.fromNamespaceAndPath((String)"balm", (String)"fluid_handler"), nativeFluidHandler, new BiFunction<BlockEntity, Direction, ResourceHandler<FluidResource>>(this){
            private boolean running;

            @Override
            public ResourceHandler<FluidResource> apply(BlockEntity blockEntity, Direction direction) {
                if (this.running) {
                    return null;
                }
                if (blockEntity instanceof BalmFluidTankProvider) {
                    FluidTank fluidTank;
                    BalmFluidTankProvider fluidTankProvider = (BalmFluidTankProvider)blockEntity;
                    FluidTank fluidTank2 = fluidTank = direction != null ? fluidTankProvider.getFluidTank(direction) : fluidTankProvider.getFluidTank();
                    if (fluidTank != null) {
                        return new NeoForgeFluidTank(fluidTank);
                    }
                } else if (blockEntity != null) {
                    this.running = true;
                    FluidTank fluidTank = Balm.getCapabilities().getCapability(blockEntity, direction, CommonCapabilities.FLUID_TANK);
                    this.running = false;
                    if (fluidTank != null) {
                        return new NeoForgeFluidTank(fluidTank);
                    }
                }
                return null;
            }
        });
        capabilities.registerFallbackBlockEntityProvider(ResourceLocation.fromNamespaceAndPath((String)"balm", (String)"energy_storage"), nativeEnergyStorage, new BiFunction<BlockEntity, Direction, EnergyHandler>(this){
            private boolean running;

            @Override
            public EnergyHandler apply(BlockEntity blockEntity, @Nullable Direction direction) {
                if (this.running) {
                    return null;
                }
                if (blockEntity instanceof BalmEnergyStorageProvider) {
                    EnergyStorage energyStorage;
                    BalmEnergyStorageProvider energyStorageProvider = (BalmEnergyStorageProvider)blockEntity;
                    EnergyStorage energyStorage2 = energyStorage = direction != null ? energyStorageProvider.getEnergyStorage(direction) : energyStorageProvider.getEnergyStorage();
                    if (energyStorage != null) {
                        return new NeoForgeEnergyStorage(energyStorage);
                    }
                } else if (blockEntity != null) {
                    this.running = true;
                    EnergyStorage energyStorage = Balm.getCapabilities().getCapability(blockEntity, direction, CommonCapabilities.ENERGY_STORAGE);
                    this.running = false;
                    if (energyStorage != null) {
                        return new NeoForgeEnergyStorage(energyStorage);
                    }
                }
                return null;
            }
        });
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
        if (Balm.isModLoaded("theoneprobe")) {
            TheOneProbeModCompat.register();
        }
    }
}

