/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.common.client;

import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.textures.GpuTexture;
import java.io.File;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IconExport {
    private static final Logger logger = LoggerFactory.getLogger(IconExport.class);

    public static void export(String filter) {
        Minecraft minecraft = Minecraft.getInstance();
        minecraft.execute(() -> {
            TextureTarget renderTarget = null;
            try {
                renderTarget = new TextureTarget("balm_icon_export", 64, 64, true);
                CreativeModeTabs.tryRebuildTabContents((FeatureFlagSet)minecraft.player.connection.enabledFeatures(), (boolean)((Boolean)minecraft.options.operatorItemsTab().get()), (HolderLookup.Provider)minecraft.level.registryAccess());
                int colonIndex = filter.indexOf(58);
                String filterModId = colonIndex != -1 ? filter.substring(0, colonIndex) : filter;
                String filterItemId = colonIndex != -1 ? filter.substring(colonIndex + 1) : null;
                File exportFolder = new File("exports/icons/" + filterModId);
                if (!exportFolder.exists() && !exportFolder.mkdirs()) {
                    throw new RuntimeException("Failed to create export folder: " + String.valueOf(exportFolder));
                }
                for (CreativeModeTab creativeModeTab : CreativeModeTabs.allTabs()) {
                    for (ItemStack itemStack : creativeModeTab.getDisplayItems()) {
                        ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)itemStack.getItem());
                        if (!itemId.getNamespace().equals(filterModId) || filterItemId != null && !itemId.getPath().equals(filterItemId)) continue;
                        int width = renderTarget.width;
                        int height = renderTarget.height;
                        GpuTexture colorTexture = renderTarget.getColorTexture();
                        if (colorTexture != null) continue;
                        throw new IllegalStateException("Tried to capture screenshot of an incomplete framebuffer");
                    }
                }
            }
            catch (Exception e) {
                logger.error("Failed to export icons", (Throwable)e);
            }
            finally {
                if (renderTarget != null) {
                    renderTarget.destroyBuffers();
                }
            }
        });
    }
}

