/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.platform;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mrcrayfish.furniture.refurbished.client.FluidSprites;
import com.mrcrayfish.furniture.refurbished.client.NeoForgeRenderType;
import com.mrcrayfish.furniture.refurbished.client.gui.screen.FreezerScreen;
import com.mrcrayfish.furniture.refurbished.client.gui.screen.MicrowaveScreen;
import com.mrcrayfish.furniture.refurbished.client.gui.screen.StoveScreen;
import com.mrcrayfish.furniture.refurbished.inventory.FreezerMenu;
import com.mrcrayfish.furniture.refurbished.inventory.MicrowaveMenu;
import com.mrcrayfish.furniture.refurbished.inventory.StoveMenu;
import com.mrcrayfish.furniture.refurbished.platform.services.IClientHelper;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.data.AtlasIds;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;

public class NeoForgeClientHelper
implements IClientHelper {
    @Override
    public int getGuiLeft(AbstractContainerScreen<?> screen) {
        return screen.getGuiLeft();
    }

    @Override
    public int getGuiTop(AbstractContainerScreen<?> screen) {
        return screen.getGuiTop();
    }

    @Override
    public CreativeModeTab getSelectedCreativeModeTab() {
        return CreativeModeInventoryScreen.selectedTab;
    }

    @Override
    public void setTooltipCache(Tooltip tooltip, List<FormattedCharSequence> lines) {
        tooltip.cachedTooltip = ImmutableList.copyOf(lines);
        tooltip.splitWithLanguage = Language.getInstance();
    }

    @Override
    public FluidSprites getFluidSprites(Fluid fluid, BlockAndTintGetter getter, BlockPos pos, FluidState state) {
        IClientFluidTypeExtensions extensions = IClientFluidTypeExtensions.of((Fluid)fluid);
        return new FluidSprites(this.getBlockTextures().apply(extensions.getStillTexture(state, getter, pos)), this.getBlockTextures().apply(extensions.getFlowingTexture(state, getter, pos)));
    }

    @Override
    public RenderType getElectricityRenderType() {
        return NeoForgeRenderType.ELECTRICITY;
    }

    @Override
    public RenderType getTelevisionScreenRenderType(ResourceLocation id) {
        return NeoForgeRenderType.televisionScreen(id);
    }

    @Override
    public RenderType createPaletteImageRenderType(ResourceLocation id) {
        return NeoForgeRenderType.createPaletteImage(id);
    }

    @Override
    public AbstractContainerScreen createFreezerScreen(AbstractContainerMenu menu, Inventory playerInventory, Component title) {
        return new FreezerScreen((FreezerMenu)menu, playerInventory, title);
    }

    @Override
    public AbstractContainerScreen createMicrowaveScreen(AbstractContainerMenu menu, Inventory playerInventory, Component title) {
        return new MicrowaveScreen((MicrowaveMenu)menu, playerInventory, title);
    }

    @Override
    public AbstractContainerScreen createStoveScreen(AbstractContainerMenu menu, Inventory playerInventory, Component title) {
        return new StoveScreen((StoveMenu)menu, playerInventory, title);
    }

    @Override
    public RenderPipeline.Snippet getMatricesProjectionSnippet() {
        return RenderPipelines.MATRICES_PROJECTION_SNIPPET;
    }

    private Function<ResourceLocation, TextureAtlasSprite> getBlockTextures() {
        return arg_0 -> ((TextureAtlas)Minecraft.getInstance().getAtlasManager().getAtlasOrThrow(AtlasIds.BLOCKS)).getSprite(arg_0);
    }
}

