/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.electricity;

import com.mojang.serialization.Codec;
import com.mrcrayfish.furniture.refurbished.Config;
import com.mrcrayfish.furniture.refurbished.electricity.Connection;
import com.mrcrayfish.furniture.refurbished.electricity.ElectricityTicker;
import com.mrcrayfish.furniture.refurbished.electricity.ISourceNode;
import com.mrcrayfish.furniture.refurbished.util.BlockEntityHelper;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;

public interface IElectricityNode {
    public BlockPos getNodePosition();

    public Level getNodeLevel();

    public BlockEntity getNodeOwner();

    public AABB getNodeInteractBox();

    public boolean isSourceNode();

    public boolean isNodePowered();

    public void setNodePowered(boolean var1);

    public Set<Connection> getNodeConnections();

    public void setNodeReceivingPower(boolean var1);

    public Set<BlockPos> getPowerSources();

    default public boolean isNodeInPowerableNetwork() {
        return !this.getPowerSources().isEmpty();
    }

    default public boolean isNodeInPowerableNetwork(BlockPos source) {
        return this.getPowerSources().contains(source);
    }

    public boolean isNodeReceivingPower();

    default public boolean isNodeValid() {
        return !this.getNodeOwner().isRemoved();
    }

    default public void onNodeDestroyed() {
        this.removeAllNodeConnections();
    }

    default public void onNodeConnectedTo(IElectricityNode other) {
    }

    default public boolean canPowerTraverseNode() {
        return true;
    }

    default public Set<Connection> updateAndGetNodeConnections() {
        this.updateNodeConnections();
        return this.getNodeConnections();
    }

    default public void syncDataToTrackingClients() {
        BlockEntity entity = this.getNodeOwner();
        BlockEntityHelper.sendCustomUpdate(entity, BlockEntity::getUpdateTag);
    }

    default public void readNodeNbt(ValueInput input) {
        BlockPos previous;
        BlockPos current;
        BlockPos offset = BlockPos.ZERO;
        Optional nodePos = input.getLong("NodePos");
        if (nodePos.isPresent() && !(current = this.getNodePosition()).equals((Object)(previous = BlockPos.of((long)((Long)nodePos.get()))))) {
            offset = current.subtract((Vec3i)previous);
        }
        BlockPos pos = this.getNodePosition();
        Set<Connection> connections = this.getNodeConnections();
        connections.clear();
        Iterator iterator = input.listOrEmpty("Connections", (Codec)Codec.LONG).iterator();
        while (iterator.hasNext()) {
            long node = (Long)iterator.next();
            connections.add(Connection.of(pos, BlockPos.of((long)node).offset((Vec3i)offset)));
        }
    }

    default public void writeNodeNbt(ValueOutput output) {
        Set<Connection> connections = this.getNodeConnections();
        ValueOutput.TypedOutputList nodes = output.list("Connections", (Codec)Codec.LONG);
        connections.stream().map(c -> c.getOtherPos(this.getNodePosition())).filter(Objects::nonNull).map(BlockPos::asLong).mapToLong(Long::longValue).forEach(arg_0 -> ((ValueOutput.TypedOutputList)nodes).add(arg_0));
        output.putLong("NodePos", this.getNodePosition().asLong());
    }

    default public void saveNodeNbtToItem(ItemStack stack, HolderLookup.Provider provider) {
        ProblemReporter.Collector reporter = new ProblemReporter.Collector();
        TagValueOutput output = TagValueOutput.createWithContext((ProblemReporter)reporter, (HolderLookup.Provider)provider);
        BlockEntity entity = this.getNodeOwner();
        entity.saveWithoutMetadata((ValueOutput)output);
        output.discard("Connections");
        output.discard("NodePos");
        output.discard("Powered");
        output.discard("Overloaded");
        BlockItem.setBlockEntityData((ItemStack)stack, (BlockEntityType)entity.getType(), (TagValueOutput)output);
    }

    default public void removeNodeConnection(Connection connection) {
        if (this.getNodeConnections().remove(connection)) {
            this.syncDataToTrackingClients();
            this.getNodeOwner().setChanged();
        }
    }

    default public void removeAllNodeConnections() {
        Set<Connection> connections = this.getNodeConnections();
        connections.forEach(c -> {
            IElectricityNode node = c.getOtherNode(this);
            if (node != null && node.isNodeValid()) {
                node.removeNodeConnection((Connection)c);
                node.syncDataToTrackingClients();
            }
        });
        connections.clear();
        this.getNodeOwner().setChanged();
    }

    default public void updateNodeConnections() {
        Level level = this.getNodeLevel();
        this.getNodeConnections().removeIf(c -> {
            if (!c.isConnected(level)) {
                IElectricityNode node = c.getOtherNode(this);
                if (node != null) {
                    node.removeNodeConnection((Connection)c);
                }
                return true;
            }
            return false;
        });
    }

    default public int getNodeMaximumConnections() {
        return (Integer)Config.SERVER.electricity.maximumLinksPerElectricityNode.get();
    }

    default public boolean isNodeConnectionLimitReached() {
        return this.getNodeConnections().size() >= this.getNodeMaximumConnections();
    }

    default public boolean connectToNode(IElectricityNode other) {
        BlockPos pos = this.getNodePosition();
        Set<Connection> connections = this.getNodeConnections();
        if (connections.add(Connection.of(pos, other.getNodePosition()))) {
            other.connectToNode(this);
            this.onNodeConnectedTo(other);
            this.syncDataToTrackingClients();
            this.getNodeOwner().setChanged();
            return true;
        }
        return false;
    }

    default public boolean isConnectedToNode(IElectricityNode node) {
        Set<Connection> connections = this.getNodeConnections();
        return connections.contains(Connection.of(this.getNodePosition(), node.getNodePosition()));
    }

    default public AABB getPositionedNodeInteractBox() {
        return this.getNodeInteractBox().move(this.getNodePosition());
    }

    default public void registerElectricityNodeTicker(Level level) {
        ElectricityTicker.get(level).addElectricityNode(this);
    }

    default public void earlyNodeTick(Level level) {
    }

    public static List<IElectricityNode> searchNodes(IElectricityNode start) {
        return IElectricityNode.searchNodes(start, (Integer)Config.SERVER.electricity.maximumNodesInNetwork.get(), false, node -> true, node -> true);
    }

    public static List<IElectricityNode> searchNodes(IElectricityNode start, int searchLimit, boolean cancelAtLimit, Predicate<IElectricityNode> searchPredicate, Predicate<IElectricityNode> matchPredicate) {
        AABB box = ISourceNode.createPowerableZone(start.getNodeLevel(), start.getNodePosition());
        HashSet<IElectricityNode> found = new HashSet<IElectricityNode>(List.of(start));
        ArrayDeque<IElectricityNode> queue = new ArrayDeque<IElectricityNode>(searchLimit);
        queue.add(start);
        block0: while (!queue.isEmpty()) {
            IElectricityNode node = (IElectricityNode)queue.poll();
            for (Connection connection : node.getNodeConnections()) {
                BlockPos pos;
                IElectricityNode other = connection.getOtherNode(node);
                if (other == null || found.contains(other) || !box.contains((double)(pos = other.getNodePosition()).getX(), (double)pos.getY(), (double)pos.getZ())) continue;
                found.add(other);
                if (cancelAtLimit && found.size() >= searchLimit) break block0;
                if (!searchPredicate.test(other)) continue;
                queue.add(other);
            }
        }
        return found.stream().filter(matchPredicate).collect(Collectors.toList());
    }
}

