/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mrcrayfish.furniture.refurbished.blockentity.PlateBlockEntity;
import com.mrcrayfish.furniture.refurbished.client.renderer.blockentity.state.PlateRenderState;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

public class PlateBlockEntityRenderer
implements BlockEntityRenderer<PlateBlockEntity, PlateRenderState> {
    private final ItemModelResolver itemModelResolver;

    public PlateBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        this.itemModelResolver = context.itemModelResolver();
    }

    public PlateRenderState createRenderState() {
        return new PlateRenderState();
    }

    public void extractRenderState(PlateBlockEntity entity, PlateRenderState renderState, float partialTick, Vec3 camera, @Nullable ModelFeatureRenderer.CrumblingOverlay overlay) {
        super.extractRenderState((BlockEntity)entity, (BlockEntityRenderState)renderState, partialTick, camera, overlay);
        ItemStack stack = entity.getItem(0);
        if (stack.isEmpty()) {
            return;
        }
        ItemStackRenderState itemState = new ItemStackRenderState();
        this.itemModelResolver.updateForTopItem(itemState, stack, ItemDisplayContext.FIXED, entity.getLevel(), null, 0);
        renderState.item = itemState;
        renderState.direction = entity.getPlacedDirection();
    }

    public void submit(PlateRenderState renderState, PoseStack poseStack, SubmitNodeCollector collector, CameraRenderState cameraState) {
        if (renderState.item != null) {
            poseStack.pushPose();
            poseStack.translate(0.5, 0.046875, 0.5);
            poseStack.mulPose((Quaternionfc)renderState.direction.getRotation());
            poseStack.scale(0.499f, 0.499f, 0.499f);
            renderState.item.submit(poseStack, collector, renderState.lightCoords, OverlayTexture.NO_OVERLAY, 0);
            poseStack.popPose();
        }
    }
}

