/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.mrcrayfish.furniture.refurbished.block.DoorMatBlock;
import com.mrcrayfish.furniture.refurbished.blockentity.DoorMatBlockEntity;
import com.mrcrayfish.furniture.refurbished.client.renderer.blockentity.state.DoorMatRenderState;
import com.mrcrayfish.furniture.refurbished.image.TextureCache;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

public class DoorMatBlockEntityRenderer
implements BlockEntityRenderer<DoorMatBlockEntity, DoorMatRenderState> {
    public DoorMatBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public DoorMatRenderState createRenderState() {
        return new DoorMatRenderState();
    }

    public void extractRenderState(DoorMatBlockEntity entity, DoorMatRenderState renderState, float partialTick, Vec3 camera, @Nullable ModelFeatureRenderer.CrumblingOverlay overlay) {
        super.extractRenderState((BlockEntity)entity, (BlockEntityRenderState)renderState, partialTick, camera, overlay);
        renderState.direction = (Direction)entity.getBlockState().getValueOrElse((Property)DoorMatBlock.DIRECTION, (Comparable)Direction.NORTH);
        renderState.renderType = TextureCache.get().getRenderType(entity);
    }

    public void submit(DoorMatRenderState renderState, PoseStack stack, SubmitNodeCollector collector, CameraRenderState cameraState) {
        if (renderState.renderType == null) {
            return;
        }
        stack.translate(0.5, 0.0, 0.5);
        stack.mulPose((Quaternionfc)Axis.YN.rotation(1.5707964f * (float)renderState.direction.get2DDataValue()));
        stack.mulPose((Quaternionfc)Axis.YP.rotation((float)Math.PI));
        stack.translate(-0.5, 0.0, -0.5);
        collector.submitCustomGeometry(stack, renderState.renderType, (pose, consumer) -> {
            consumer.addVertex(pose, 0.0625f, 0.063f, 0.1875f).setColor(255, 255, 255, 255).setUv(0.0f, 0.0f).setLight(renderState.lightCoords).setNormal(0.0f, 1.0f, 0.0f);
            consumer.addVertex(pose, 0.0625f, 0.063f, 0.8125f).setColor(255, 255, 255, 255).setUv(0.0f, 1.0f).setLight(renderState.lightCoords).setNormal(0.0f, 1.0f, 0.0f);
            consumer.addVertex(pose, 0.9375f, 0.063f, 0.8125f).setColor(255, 255, 255, 255).setUv(1.0f, 1.0f).setLight(renderState.lightCoords).setNormal(0.0f, 1.0f, 0.0f);
            consumer.addVertex(pose, 0.9375f, 0.063f, 0.1875f).setColor(255, 255, 255, 255).setUv(1.0f, 0.0f).setLight(renderState.lightCoords).setNormal(0.0f, 1.0f, 0.0f);
        });
    }

    public int getViewDistance() {
        return 24;
    }
}

