/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.mrcrayfish.furniture.refurbished.block.CuttingBoardBlock;
import com.mrcrayfish.furniture.refurbished.blockentity.CuttingBoardBlockEntity;
import com.mrcrayfish.furniture.refurbished.client.renderer.blockentity.state.CuttingBoardItemStackRenderState;
import com.mrcrayfish.furniture.refurbished.client.renderer.blockentity.state.CuttingBoardRenderState;
import com.mrcrayfish.furniture.refurbished.core.ModTags;
import java.util.ArrayList;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

public class CuttingBoardBlockEntityRenderer
implements BlockEntityRenderer<CuttingBoardBlockEntity, CuttingBoardRenderState> {
    private final ItemModelResolver itemModelResolver;
    private final RandomSource random = RandomSource.create();

    public CuttingBoardBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        this.itemModelResolver = context.itemModelResolver();
    }

    public CuttingBoardRenderState createRenderState() {
        return new CuttingBoardRenderState();
    }

    public void extractRenderState(CuttingBoardBlockEntity entity, CuttingBoardRenderState renderState, float partialTick, Vec3 camera, @Nullable ModelFeatureRenderer.CrumblingOverlay overlay) {
        super.extractRenderState((BlockEntity)entity, (BlockEntityRenderState)renderState, partialTick, camera, overlay);
        renderState.direction = (Direction)entity.getBlockState().getValueOrElse((Property)CuttingBoardBlock.DIRECTION, (Comparable)Direction.NORTH);
        renderState.items = new ArrayList<CuttingBoardItemStackRenderState>();
        for (int i = 0; i < entity.getContainerSize(); ++i) {
            ItemStack stack = entity.getItem(i);
            if (stack.isEmpty()) continue;
            CuttingBoardItemStackRenderState state = new CuttingBoardItemStackRenderState();
            state.setDisplayAsBlock(stack.is(ModTags.Items.DISPLAY_AS_BLOCK));
            this.itemModelResolver.updateForTopItem((ItemStackRenderState)state, stack, ItemDisplayContext.NONE, entity.getLevel(), null, i + i);
            renderState.items.add(state);
        }
    }

    public void submit(CuttingBoardRenderState renderState, PoseStack poseStack, SubmitNodeCollector collector, CameraRenderState cameraState) {
        poseStack.pushPose();
        poseStack.translate(0.5, 0.078125, 0.5);
        poseStack.mulPose((Quaternionfc)renderState.direction.getRotation());
        poseStack.mulPose((Quaternionfc)Axis.YP.rotation((float)Math.PI));
        poseStack.scale(0.5f, 0.5f, 0.5f);
        for (int i = 0; i < renderState.items.size(); ++i) {
            CuttingBoardItemStackRenderState state = renderState.items.get(i);
            this.random.setSeed((long)(renderState.blockPos.hashCode() + i));
            poseStack.pushPose();
            if (state.isDisplayAsBlock()) {
                poseStack.mulPose((Quaternionfc)Axis.XP.rotation(1.5707964f));
                poseStack.scale(0.5f, 0.5f, 0.5f);
                poseStack.translate(0.0, 0.4375, 0.0);
            } else {
                poseStack.mulPose((Quaternionfc)Axis.ZP.rotation((float)this.random.nextGaussian() * (float)Math.PI * 0.025f));
            }
            state.submit(poseStack, collector, renderState.lightCoords, OverlayTexture.NO_OVERLAY, 0);
            poseStack.popPose();
            poseStack.translate(0.0, 0.0, state.isDisplayAsBlock() ? 0.5 : 0.0625);
        }
        poseStack.popPose();
    }
}

