/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.client.electricity;

import com.mrcrayfish.framework.api.config.event.FrameworkConfigEvents;
import com.mrcrayfish.furniture.refurbished.Config;
import com.mrcrayfish.furniture.refurbished.client.electricity.ElectricityRenderer;
import com.mrcrayfish.furniture.refurbished.client.electricity.PowerableArea;
import com.mrcrayfish.furniture.refurbished.client.electricity.WrenchContext;
import com.mrcrayfish.furniture.refurbished.client.electricity.state.ConnectionRenderState;
import com.mrcrayfish.furniture.refurbished.client.electricity.state.ElectricityRenderState;
import com.mrcrayfish.furniture.refurbished.client.electricity.state.LinkingConnectionRenderState;
import com.mrcrayfish.furniture.refurbished.client.electricity.state.PowerableAreaRenderState;
import com.mrcrayfish.furniture.refurbished.core.ModItems;
import com.mrcrayfish.furniture.refurbished.core.ModSounds;
import com.mrcrayfish.furniture.refurbished.electricity.Connection;
import com.mrcrayfish.furniture.refurbished.electricity.ConnectionHitResult;
import com.mrcrayfish.furniture.refurbished.electricity.IElectricityNode;
import com.mrcrayfish.furniture.refurbished.electricity.NodeHitResult;
import com.mrcrayfish.furniture.refurbished.item.WrenchItem;
import com.mrcrayfish.furniture.refurbished.network.Network;
import com.mrcrayfish.furniture.refurbished.network.message.MessageDeleteLink;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import org.joml.Intersectiond;
import org.joml.Vector3d;

public class WrenchHandler {
    private static final int DEFAULT_LINK_COLOUR = -1;
    private static final int SUCCESS_LINK_COLOUR = -4849844;
    private static final int ERROR_LINK_COLOUR = -3983818;
    private static final double NEAR_DISTANCE = 10.0;
    private static WrenchHandler instance;
    private final PowerableArea powerableArea = new PowerableArea();
    @Nullable
    private BlockPos selectedNodePos;
    private HitResult result;
    private double linkLength;
    private boolean linkInsideArea;

    public static WrenchHandler get() {
        if (instance == null) {
            instance = new WrenchHandler();
        }
        return instance;
    }

    private WrenchHandler() {
        FrameworkConfigEvents.RELOAD.register(object -> {
            if (object == Config.SERVER) {
                this.powerableArea.invalidate();
            }
        });
    }

    public void setSelectedNodePos(@Nullable BlockPos pos) {
        this.selectedNodePos = pos;
    }

    public boolean isSelectedNode(IElectricityNode node) {
        return this.selectedNodePos != null && this.selectedNodePos.equals((Object)node.getNodePosition());
    }

    public boolean isCreatingLink() {
        return this.selectedNodePos != null;
    }

    public boolean isLinkOutsidePowerableArea() {
        return !this.linkInsideArea;
    }

    public double getLinkLength() {
        return this.selectedNodePos != null ? this.linkLength : 0.0;
    }

    public boolean isTargetNode(IElectricityNode node) {
        NodeHitResult nodeResult;
        HitResult hitResult = this.result;
        return hitResult instanceof NodeHitResult && (nodeResult = (NodeHitResult)hitResult).getNode() == node;
    }

    @Nullable
    public IElectricityNode getTargetNode() {
        IElectricityNode iElectricityNode;
        HitResult hitResult = this.result;
        if (hitResult instanceof NodeHitResult) {
            NodeHitResult nodeResult = (NodeHitResult)hitResult;
            iElectricityNode = nodeResult.getNode();
        } else {
            iElectricityNode = null;
        }
        return iElectricityNode;
    }

    @Nullable
    public Connection getTargetConnection() {
        Connection connection;
        HitResult hitResult = this.result;
        if (hitResult instanceof ConnectionHitResult) {
            ConnectionHitResult linkResult = (ConnectionHitResult)hitResult;
            connection = linkResult.getConnection();
        } else {
            connection = null;
        }
        return connection;
    }

    @Nullable
    public IElectricityNode getSelectedNode() {
        IElectricityNode node;
        Level level = WrenchHandler.getClientLevel();
        if (level == null || this.selectedNodePos == null) {
            return null;
        }
        LevelChunk chunk = level.getChunkAt(this.selectedNodePos);
        if (chunk == null) {
            return null;
        }
        Object v = chunk.getBlockEntities().get(this.selectedNodePos);
        if (v instanceof IElectricityNode && (node = (IElectricityNode)v).isNodeValid()) {
            return node;
        }
        return null;
    }

    public void startRenderLevel(float partialTick) {
        if (!WrenchHandler.isHoldingWrench()) {
            this.selectedNodePos = null;
        }
        this.updateHitResult(partialTick);
        this.updateLinkState(partialTick);
    }

    private void updateHitResult(float partialTick) {
        HitResult last = this.result;
        this.result = null;
        Player player = WrenchHandler.getClientPlayer();
        Level level = WrenchHandler.getClientLevel();
        if (player == null || level == null) {
            return;
        }
        if (!player.getMainHandItem().is((Item)ModItems.WRENCH.get())) {
            return;
        }
        double range = player.blockInteractionRange();
        NodeHitResult newResult = WrenchItem.pickElectricityNode(level, player, range, partialTick);
        if (newResult.getType() == HitResult.Type.MISS) {
            newResult = this.pickConnection(player, partialTick, range);
        }
        if (newResult.getType() != HitResult.Type.MISS) {
            this.playHoverSound(last, newResult, player, level);
            this.result = newResult;
        }
    }

    private void playHoverSound(@Nullable HitResult oldResult, @Nullable HitResult newResult, Player player, Level level) {
        if (this.selectedNodePos != null) {
            return;
        }
        if ((oldResult == null || !oldResult.equals(newResult)) && newResult instanceof ConnectionHitResult) {
            Vec3 pos = newResult.getLocation();
            float pitch = 1.0f + 0.05f * level.random.nextFloat();
            level.playSound((Entity)player, pos.x, pos.y, pos.z, (SoundEvent)ModSounds.ITEM_WRENCH_HOVER_LINK.get(), SoundSource.BLOCKS, 1.0f, pitch);
        }
    }

    private void updateLinkState(float partialTick) {
        ConnectionHitResult hitResult;
        Connection connection;
        Vec3 end;
        Vec3 start;
        this.linkInsideArea = false;
        Player player = WrenchHandler.getClientPlayer();
        Level level = WrenchHandler.getClientLevel();
        if (player == null || level == null) {
            return;
        }
        this.powerableArea.updatePowerSources(level, this.createWrenchContext());
        if (this.selectedNodePos != null) {
            start = Vec3.atCenterOf((Vec3i)this.selectedNodePos);
            end = this.getLinkEnd(player, partialTick);
            this.linkLength = end.subtract(start).length();
        }
        if (!this.powerableArea.exists()) {
            this.linkInsideArea = true;
            return;
        }
        if (this.selectedNodePos != null) {
            start = this.selectedNodePos.getCenter();
            end = this.getLinkEnd(player, partialTick);
            this.linkInsideArea = this.powerableArea.containsLine(level, start, end);
            return;
        }
        end = this.result;
        if (end instanceof ConnectionHitResult && (connection = (hitResult = (ConnectionHitResult)end).getConnection()) != null) {
            Vec3 start2 = connection.getPosA().getCenter();
            Vec3 end2 = connection.getPosB().getCenter();
            this.linkInsideArea = this.powerableArea.containsLine(level, start2, end2);
        }
    }

    private WrenchContext createWrenchContext() {
        IElectricityNode linkingNode = this.getSelectedNode();
        IElectricityNode targetNode = this.getTargetNode();
        Connection targetConnection = this.getTargetConnection();
        return new WrenchContext(linkingNode, targetNode, targetConnection);
    }

    public void extractLinkingConnection(ElectricityRenderState renderState) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player != null && mc.player.getMainHandItem().is((Item)ModItems.WRENCH.get()) && this.selectedNodePos != null) {
            LinkingConnectionRenderState state = new LinkingConnectionRenderState();
            state.start = Vec3.atCenterOf((Vec3i)this.selectedNodePos);
            state.end = this.getLinkEnd((Player)mc.player, mc.getDeltaTracker().getGameTimeDeltaPartialTick(false));
            state.colour = this.getLinkColour();
            renderState.link = state;
        }
    }

    public void extractPowerableArea(PowerableAreaRenderState renderState, Vec3 camera) {
        VoxelShape areaShape = this.powerableArea.getPowerableAreaShape();
        if (areaShape == null) {
            return;
        }
        renderState.shape = areaShape;
        renderState.alpha = 1.0f;
        boolean bl = renderState.invalid = !this.linkInsideArea;
        if (this.linkInsideArea) {
            double nearDistanceSqr = 100.0;
            renderState.alpha = renderState.shape.closestPointTo(camera).map(vec -> vec.distanceToSqr(camera)).map(val -> Float.valueOf(1.0f - (float)Mth.clamp((double)(val / nearDistanceSqr), (double)0.0, (double)1.0))).orElse(Float.valueOf(0.0f)).floatValue();
            renderState.alpha = 1.0f - (float)Math.pow(1.0f - renderState.alpha, 5.0);
        }
    }

    private Vec3 getLinkEnd(Player player, float partialTick) {
        IElectricityNode node = this.getTargetNode();
        if (node != null && !this.isSelectedNode(node) && this.canLinkToNode(node)) {
            return node.getNodePosition().getCenter();
        }
        return player.getViewVector(partialTick).normalize().scale(1.5).add(player.getEyePosition(partialTick));
    }

    public int getLinkColour() {
        IElectricityNode linking = this.getSelectedNode();
        if (linking == null) {
            return -1;
        }
        if (this.linkLength > 512.0) {
            return -3983818;
        }
        IElectricityNode target = this.getTargetNode();
        if (target != null && !this.isSelectedNode(target)) {
            if (this.canLinkToNode(target)) {
                return -4849844;
            }
            return -3983818;
        }
        if (!this.linkInsideArea) {
            return -3983818;
        }
        return -1;
    }

    public boolean canLinkToNode(IElectricityNode target) {
        IElectricityNode lastNode;
        Level level = WrenchHandler.getClientLevel();
        if (level != null && this.selectedNodePos != null && (lastNode = this.getSelectedNode()) != null && target != null && lastNode != target) {
            if (level != target.getNodeLevel()) {
                return false;
            }
            if (target.isSourceNode() && lastNode.isSourceNode()) {
                return false;
            }
            if (target.isNodeConnectionLimitReached()) {
                return false;
            }
            return !lastNode.isConnectedToNode(target);
        }
        return false;
    }

    private HitResult pickConnection(Player player, float partialTick, double range) {
        double closestDistance = Double.POSITIVE_INFINITY;
        ConnectionRenderState closestConnection = null;
        Vec3 hit = Vec3.ZERO;
        ElectricityRenderState renderState = ElectricityRenderer.get().getRenderState();
        for (ConnectionRenderState connectionRenderState : renderState.connections) {
            Vec3 rayStart = player.getEyePosition(partialTick);
            Vec3 rayEnd = rayStart.add(player.getViewVector(partialTick).normalize().scale(range));
            Vec3 linkStart = connectionRenderState.a().getCenter();
            Vec3 linkEnd = connectionRenderState.b().getCenter();
            Vector3d result = new Vector3d();
            double squareDistance = Intersectiond.findClosestPointsLineSegments((double)rayStart.x, (double)rayStart.y, (double)rayStart.z, (double)rayEnd.x, (double)rayEnd.y, (double)rayEnd.z, (double)linkStart.x, (double)linkStart.y, (double)linkStart.z, (double)linkEnd.x, (double)linkEnd.y, (double)linkEnd.z, (Vector3d)new Vector3d(), (Vector3d)result);
            double distance = Math.sqrt(squareDistance);
            if (!(distance < 0.1) || !(distance < closestDistance)) continue;
            closestDistance = distance;
            closestConnection = connectionRenderState;
            hit = new Vec3(result.x, result.y, result.z);
        }
        if (closestConnection != null) {
            return new ConnectionHitResult(hit, Connection.of(closestConnection.a(), closestConnection.b()));
        }
        return new ConnectionHitResult(hit, null);
    }

    public boolean onPerformAttack(Level level) {
        ConnectionHitResult connectionHitResult;
        Connection connection;
        HitResult hitResult;
        if (!this.isCreatingLink() && (hitResult = this.result) instanceof ConnectionHitResult && (connection = (connectionHitResult = (ConnectionHitResult)hitResult).getConnection()) != null) {
            Vec3 hit = connectionHitResult.getLocation();
            level.playLocalSound(hit.x, hit.y, hit.z, (SoundEvent)ModSounds.ITEM_WRENCH_REMOVE_LINK.get(), SoundSource.BLOCKS, 1.0f, 1.0f, false);
            Network.getPlay().sendToServer((Object)new MessageDeleteLink(connection.getPosA(), connection.getPosB()));
            return true;
        }
        return false;
    }

    public static boolean isHoldingWrench() {
        Minecraft mc = Minecraft.getInstance();
        return mc.player != null && mc.player.isAlive() && mc.player.getMainHandItem().is((Item)ModItems.WRENCH.get());
    }

    @Nullable
    private static Player getClientPlayer() {
        return Minecraft.getInstance().player;
    }

    @Nullable
    private static Level getClientLevel() {
        return Minecraft.getInstance().level;
    }
}

