/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.blockentity;

import com.google.common.base.Preconditions;
import com.mojang.serialization.Codec;
import com.mrcrayfish.furniture.refurbished.block.ToasterBlock;
import com.mrcrayfish.furniture.refurbished.blockentity.ElectricityModuleProcessingLootBlockEntity;
import com.mrcrayfish.furniture.refurbished.core.ModBlockEntities;
import com.mrcrayfish.furniture.refurbished.core.ModRecipeTypes;
import com.mrcrayfish.furniture.refurbished.core.ModSounds;
import com.mrcrayfish.furniture.refurbished.crafting.ProcessingRecipe;
import com.mrcrayfish.furniture.refurbished.util.BlockEntityHelper;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;

public class ToasterBlockEntity
extends ElectricityModuleProcessingLootBlockEntity {
    public static final int[] INPUT_SLOTS = new int[]{0, 1};
    public static final int[] OUTPUT_SLOTS = new int[]{0, 1};
    protected boolean heating;
    protected boolean sync;

    public ToasterBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.TOASTER.get(), pos, state, 2, (RecipeType<? extends ProcessingRecipe>)((RecipeType)ModRecipeTypes.TOASTER_HEATING.get()));
    }

    public ToasterBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, int containerSize, RecipeType<? extends ProcessingRecipe.Item> recipeType) {
        super(type, pos, state, containerSize, recipeType);
    }

    @Override
    public void setNodePowered(boolean powered) {
        super.setNodePowered(powered);
        if (!powered && this.isHeating()) {
            this.setHeating(false);
        }
    }

    public void startHeating() {
        if (!this.heating && this.canProcessInput() && this.isNodePowered()) {
            this.setHeating(true);
        }
    }

    public boolean toggleHeating() {
        if (this.heating || this.canProcessInput() && this.isNodePowered()) {
            this.setHeating(!this.heating);
            return true;
        }
        return false;
    }

    private void setHeating(boolean heating) {
        this.heating = heating;
        this.level.setBlock(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)ToasterBlock.POWERED, (Comparable)Boolean.valueOf(this.heating)), 3);
        this.playLeverSound(heating);
        this.setChanged();
        this.sync();
    }

    public boolean isHeating() {
        return this.heating;
    }

    @Override
    public int[] getInputSlots() {
        return INPUT_SLOTS;
    }

    @Override
    public int[] getOutputSlots() {
        return OUTPUT_SLOTS;
    }

    @Override
    public int[] getEnergySlots() {
        return NO_SLOTS;
    }

    @Override
    protected boolean shouldProcessAll() {
        return true;
    }

    @Override
    public boolean canProcess() {
        return this.heating && super.canProcessInput();
    }

    @Override
    public void onCompleteProcess() {
        super.onCompleteProcess();
        this.setHeating(false);
        this.sync();
    }

    @Override
    protected boolean handleProcessed(ItemStack stack) {
        BlockPos pos = this.worldPosition;
        ItemEntity entity = new ItemEntity(this.level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, stack.copy());
        entity.setDefaultPickUpDelay();
        entity.setDeltaMovement(new Vec3(0.0, 0.35, 0.0));
        this.level.addFreshEntity((Entity)entity);
        return true;
    }

    @Override
    public boolean processTick() {
        boolean result = super.processTick();
        if (this.sync) {
            BlockEntityHelper.sendCustomUpdate((BlockEntity)this, BlockEntity::getUpdateTag);
            this.sync = false;
        }
        return result;
    }

    public int getMaxStackSize() {
        return 1;
    }

    @Override
    public boolean isMatchingContainerMenu(AbstractContainerMenu menu) {
        return false;
    }

    protected Component getDefaultName() {
        return Utils.translation("container", "toaster", new Object[0]);
    }

    protected AbstractContainerMenu createMenu(int windowId, Inventory playerInventory) {
        return null;
    }

    @Override
    public boolean canPlaceItem(int slotIndex, ItemStack stack) {
        return !this.isHeating() && super.canPlaceItem(slotIndex, stack);
    }

    @Override
    public boolean canTakeItem(Container container, int slotIndex, ItemStack stack) {
        return !this.isHeating() && super.canTakeItem(container, slotIndex, stack);
    }

    public void setChanged() {
        super.setChanged();
        this.sync();
    }

    protected void sync() {
        this.sync = true;
    }

    public boolean insertItem(ItemStack heldItem, ServerLevel level) {
        if (this.isHeating()) {
            return false;
        }
        if (heldItem.isEmpty() || this.isFull()) {
            return this.extractItem();
        }
        if (this.isRecipe(heldItem, level)) {
            for (int i = 0; i < this.getContainerSize(); ++i) {
                if (!this.getItem(i).isEmpty()) continue;
                ItemStack stack = heldItem.copy();
                stack.setCount(1);
                heldItem.shrink(1);
                this.setItem(i, stack);
                this.playInsertSound();
                this.sync();
                return true;
            }
        }
        return false;
    }

    public boolean extractItem() {
        for (int i = 0; i < this.getContainerSize(); ++i) {
            ItemStack stack = this.getItem(i);
            if (stack.isEmpty()) continue;
            BlockPos pos = this.worldPosition;
            ItemEntity entity = new ItemEntity(this.level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, stack.copy());
            this.setItem(i, ItemStack.EMPTY);
            this.level.addFreshEntity((Entity)entity);
            this.sync();
            return true;
        }
        return false;
    }

    private boolean isFull() {
        for (int i = 0; i < this.getContainerSize(); ++i) {
            if (!this.getItem(i).isEmpty()) continue;
            return false;
        }
        return true;
    }

    private void playLeverSound(boolean heating) {
        Preconditions.checkNotNull((Object)this.level);
        SoundEvent event = heating ? (SoundEvent)ModSounds.BLOCK_TOASTER_DOWN.get() : (SoundEvent)ModSounds.BLOCK_TOASTER_POP.get();
        this.level.playSound(null, this.worldPosition, event, SoundSource.BLOCKS, 1.0f, 0.9f + 0.1f * this.level.random.nextFloat());
    }

    private void playInsertSound() {
        Preconditions.checkNotNull((Object)this.level);
        this.level.playSound(null, this.worldPosition, (SoundEvent)ModSounds.BLOCK_TOASTER_INSERT.get(), SoundSource.BLOCKS, 0.5f, 0.9f + 0.1f * this.level.random.nextFloat());
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, ToasterBlockEntity entity) {
        if (((Boolean)state.getValue((Property)ToasterBlock.POWERED)).booleanValue()) {
            level.addParticle((ParticleOptions)ParticleTypes.SMOKE, (double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, 0.0, 0.1 * level.random.nextDouble(), 0.0);
        }
    }

    @Override
    public void loadAdditional(ValueInput input) {
        super.loadAdditional(input);
        input.read("Heating", (Codec)Codec.BOOL).ifPresent(value -> {
            this.heating = value;
        });
    }

    @Override
    protected void saveAdditional(ValueOutput output) {
        super.saveAdditional(output);
        output.store("Heating", (Codec)Codec.BOOL, (Object)this.heating);
    }

    @Override
    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.saveWithoutMetadata(provider);
    }
}

