/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.block;

import com.google.common.collect.ImmutableList;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class FurnitureAttachedFaceBlock
extends FaceAttachedHorizontalDirectionalBlock {
    protected final Map<BlockState, VoxelShape> shapes = this.generateShapes((ImmutableList<BlockState>)this.getStateDefinition().getPossibleStates());

    protected FurnitureAttachedFaceBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected abstract Map<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> var1);

    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return this.shapes.get(state);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING});
        builder.add(new Property[]{FACE});
    }

    public int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos, Direction direction) {
        return AbstractContainerMenu.getRedstoneSignalFromBlockEntity((BlockEntity)level.getBlockEntity(pos));
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return state.getBlock() instanceof EntityBlock;
    }

    public boolean triggerEvent(BlockState state, Level level, BlockPos pos, int id, int type) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        return blockEntity != null && blockEntity.triggerEvent(id, type);
    }

    protected boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }
}

