/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mrcrayfish.furniture.refurbished.block.FurnitureHorizontalBlock;
import com.mrcrayfish.furniture.refurbished.core.ModTags;
import com.mrcrayfish.furniture.refurbished.data.tag.BlockTagSupplier;
import com.mrcrayfish.furniture.refurbished.util.VoxelShapeHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.phys.shapes.VoxelShape;

public class DeskBlock
extends FurnitureHorizontalBlock
implements BlockTagSupplier {
    private static final MapCodec<DeskBlock> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)WoodType.CODEC.fieldOf("wood_type").forGetter(block -> block.type), (App)DeskBlock.propertiesCodec()).apply((Applicative)builder, DeskBlock::new));
    protected final WoodType type;

    public DeskBlock(WoodType type, BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)DIRECTION, (Comparable)Direction.NORTH)).setValue((Property)LEFT, (Comparable)Boolean.valueOf(false))).setValue((Property)RIGHT, (Comparable)Boolean.valueOf(false)));
        this.type = type;
    }

    public WoodType getWoodType() {
        return this.type;
    }

    protected MapCodec<? extends DeskBlock> codec() {
        return CODEC;
    }

    @Override
    protected Map<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        VoxelShape topShape = Block.box((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        VoxelShape backLeftLegShape = Block.box((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)2.0);
        VoxelShape backRightLegShape = Block.box((double)14.0, (double)0.0, (double)14.0, (double)16.0, (double)14.0, (double)16.0);
        VoxelShape frontLeftLegShape = Block.box((double)1.0, (double)0.0, (double)0.0, (double)3.0, (double)14.0, (double)2.0);
        VoxelShape frontRightLegShape = Block.box((double)1.0, (double)0.0, (double)14.0, (double)3.0, (double)14.0, (double)16.0);
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (BlockState state : states) {
            Direction direction = (Direction)state.getValue((Property)DIRECTION);
            boolean left = (Boolean)state.getValue((Property)LEFT);
            boolean right = (Boolean)state.getValue((Property)RIGHT);
            ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
            shapes.add(topShape);
            if (!left) {
                shapes.add(VoxelShapeHelper.rotateHorizontally(backRightLegShape, direction));
                shapes.add(VoxelShapeHelper.rotateHorizontally(frontRightLegShape, direction));
            }
            if (!right) {
                shapes.add(VoxelShapeHelper.rotateHorizontally(backLeftLegShape, direction));
                shapes.add(VoxelShapeHelper.rotateHorizontally(frontLeftLegShape, direction));
            }
            builder.put((Object)state, (Object)VoxelShapeHelper.combine(shapes));
        }
        return builder.build();
    }

    protected BlockState updateShape(BlockState state, LevelReader reader, ScheduledTickAccess access, BlockPos pos, Direction direction, BlockPos pos1, BlockState state1, RandomSource rand) {
        Direction facing = (Direction)state.getValue((Property)DIRECTION);
        boolean left = this.isConnectable(reader, pos, facing.getClockWise(), facing);
        boolean right = this.isConnectable(reader, pos, facing.getCounterClockWise(), facing);
        return (BlockState)((BlockState)state.setValue((Property)LEFT, (Comparable)Boolean.valueOf(left))).setValue((Property)RIGHT, (Comparable)Boolean.valueOf(right));
    }

    public boolean isConnectable(LevelReader level, BlockPos pos, Direction checkDirection, Direction tableDirection) {
        BlockState state = level.getBlockState(pos.relative(checkDirection));
        return state.getBlock() instanceof DeskBlock && state.getValue((Property)DIRECTION) == tableDirection;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{LEFT});
        builder.add(new Property[]{RIGHT});
    }

    @Override
    public List<TagKey<Block>> getTags() {
        return List.of(BlockTags.MINEABLE_WITH_AXE, ModTags.Blocks.TUCKABLE);
    }
}

