/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished;

import com.mrcrayfish.framework.api.event.FrameworkPlayerEvents;
import com.mrcrayfish.framework.api.event.FrameworkTickEvents;
import com.mrcrayfish.furniture.refurbished.block.DoorMatBlock;
import com.mrcrayfish.furniture.refurbished.block.FryingPanBlock;
import com.mrcrayfish.furniture.refurbished.blockentity.CuttingBoardBlockEntity;
import com.mrcrayfish.furniture.refurbished.blockentity.FryingPanBlockEntity;
import com.mrcrayfish.furniture.refurbished.blockentity.GrillBlockEntity;
import com.mrcrayfish.furniture.refurbished.computer.Computer;
import com.mrcrayfish.furniture.refurbished.computer.IService;
import com.mrcrayfish.furniture.refurbished.computer.app.CoinMiner;
import com.mrcrayfish.furniture.refurbished.computer.app.HomeControl;
import com.mrcrayfish.furniture.refurbished.computer.app.Marketplace;
import com.mrcrayfish.furniture.refurbished.computer.app.PaddleBall;
import com.mrcrayfish.furniture.refurbished.core.ModBlocks;
import com.mrcrayfish.furniture.refurbished.core.ModDataComponents;
import com.mrcrayfish.furniture.refurbished.core.ModItems;
import com.mrcrayfish.furniture.refurbished.electricity.LinkManager;
import com.mrcrayfish.furniture.refurbished.image.PaletteImage;
import com.mrcrayfish.furniture.refurbished.item.PackageItem;
import com.mrcrayfish.furniture.refurbished.mail.DeliveryService;
import com.mrcrayfish.furniture.refurbished.network.Network;
import com.mrcrayfish.furniture.refurbished.network.message.MessageToolAnimation;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class Bootstrap {
    public static void init() {
        Bootstrap.registerDispenserBehaviours();
        Bootstrap.registerCauldronBehaviours();
        Bootstrap.registerFrameworkEvents();
        Computer computer = Computer.get();
        computer.installProgram(Utils.resource("paddle_ball"), PaddleBall::new);
        computer.installProgram(Utils.resource("home_control"), HomeControl::new);
        computer.installProgram(Utils.resource("marketplace"), Marketplace::new);
        computer.installProgram(Utils.resource("coin_miner"), CoinMiner::new);
        computer.installService(PaddleBall.SERVICE);
    }

    private static void registerFrameworkEvents() {
        FrameworkTickEvents.START_SERVER.register(server -> {
            DeliveryService.get(server).ifPresent(DeliveryService::serverTick);
            Computer.get().getServices().forEach(IService::tick);
        });
        FrameworkTickEvents.END_PLAYER.register(player -> {
            MinecraftServer server = player.level().getServer();
            if (server != null) {
                LinkManager.get(server).ifPresent(manager -> manager.onPlayerTick(player));
            }
        });
        FrameworkPlayerEvents.LOGGED_OUT.register(player -> {
            MinecraftServer server = player.level().getServer();
            if (server != null) {
                LinkManager.get(server).ifPresent(manager -> manager.onPlayerLoggedOut(player));
            }
        });
    }

    private static void registerDispenserBehaviours() {
        DispenserBlock.registerBehavior(() -> ModItems.SPATULA.get(), (source, stack) -> {
            FryingPanBlockEntity fryingPan;
            GrillBlockEntity grill;
            Direction direction = (Direction)source.state().getValue((Property)DispenserBlock.FACING);
            BlockPos pos = source.pos().relative(direction).below();
            BlockEntity patt0$temp = source.level().getBlockEntity(pos);
            if (patt0$temp instanceof GrillBlockEntity && (grill = (GrillBlockEntity)patt0$temp).flipItems()) {
                FryingPanBlock.playSpatulaScoopSound((Level)source.level(), pos.above(), 0.0);
                Network.getPlay().sendToTrackingBlockEntity(() -> grill, (Object)new MessageToolAnimation(MessageToolAnimation.Tool.SPATULA, source.pos(), direction));
                return stack;
            }
            pos = source.pos().relative(direction);
            BlockEntity patt1$temp = source.level().getBlockEntity(pos);
            if (patt1$temp instanceof FryingPanBlockEntity && (fryingPan = (FryingPanBlockEntity)patt1$temp).isFlippingNeeded()) {
                fryingPan.flipItem();
                FryingPanBlock.playSpatulaScoopSound((Level)source.level(), pos, 0.1875);
                Network.getPlay().sendToTrackingBlockEntity(() -> fryingPan, (Object)new MessageToolAnimation(MessageToolAnimation.Tool.SPATULA, source.pos(), direction));
                return stack;
            }
            return stack;
        });
        DispenserBlock.registerBehavior(() -> ModItems.KNIFE.get(), (source, stack) -> {
            CuttingBoardBlockEntity cuttingBoard;
            Direction direction = (Direction)source.state().getValue((Property)DispenserBlock.FACING);
            BlockPos pos = source.pos().relative(direction);
            BlockEntity patt0$temp = source.level().getBlockEntity(pos);
            if (patt0$temp instanceof CuttingBoardBlockEntity && (cuttingBoard = (CuttingBoardBlockEntity)patt0$temp).sliceItem((Level)source.level(), false)) {
                stack.hurtAndBreak(1, source.level(), null, item -> stack.setCount(0));
                Network.getPlay().sendToTrackingBlockEntity(() -> cuttingBoard, (Object)new MessageToolAnimation(MessageToolAnimation.Tool.KNIFE, source.pos(), direction));
            }
            return stack;
        });
        DispenserBlock.registerBehavior(() -> ModItems.PACKAGE.get(), (source, stack) -> {
            Direction direction = (Direction)source.state().getValue((Property)DispenserBlock.FACING);
            Vec3 pos = source.pos().relative(direction).getCenter();
            PackageItem.getPackagedItems(stack).stream().forEach(s -> Containers.dropItemStack((Level)source.level(), (double)pos.x, (double)pos.y, (double)pos.z, (ItemStack)s));
            return ItemStack.EMPTY;
        });
    }

    private static void registerCauldronBehaviours() {
        CauldronInteraction.WATER.map().put(((DoorMatBlock)ModBlocks.DOOR_MAT.get()).asItem(), (state, level, pos, player, hand, stack) -> {
            PaletteImage image;
            Block block = Block.byItem((Item)stack.getItem());
            if (block == ModBlocks.DOOR_MAT.get() && (image = (PaletteImage)stack.get((DataComponentType)ModDataComponents.PALETTE_IMAGE.get())) != null) {
                if (!level.isClientSide()) {
                    ItemStack copy = stack.copyWithCount(1);
                    copy.remove((DataComponentType)ModDataComponents.PALETTE_IMAGE.get());
                    stack.shrink(1);
                    if (stack.isEmpty()) {
                        player.setItemInHand(hand, copy);
                    } else if (player.addItem(copy)) {
                        player.inventoryMenu.sendAllDataToRemote();
                    } else {
                        player.drop(copy, false);
                    }
                    LayeredCauldronBlock.lowerFillLevel((BlockState)state, (Level)level, (BlockPos)pos);
                }
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.TRY_WITH_EMPTY_HAND;
        });
    }
}

