/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.neoforge.impl.event;

import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.CommandDispatcher;
import fuzs.puzzleslib.api.event.v1.AddBlockEntityTypeBlocksCallback;
import fuzs.puzzleslib.api.event.v1.BuildCreativeModeTabContentsCallback;
import fuzs.puzzleslib.api.event.v1.CommonSetupCallback;
import fuzs.puzzleslib.api.event.v1.ComputeItemAttributeModifiersCallback;
import fuzs.puzzleslib.api.event.v1.FinalizeItemComponentsCallback;
import fuzs.puzzleslib.api.event.v1.LoadCompleteCallback;
import fuzs.puzzleslib.api.event.v1.RegistryEntryAddedCallback;
import fuzs.puzzleslib.api.event.v1.core.EventInvoker;
import fuzs.puzzleslib.api.event.v1.core.EventPhase;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.puzzleslib.api.event.v1.core.EventResultHolder;
import fuzs.puzzleslib.api.event.v1.data.MutableDouble;
import fuzs.puzzleslib.api.event.v1.data.MutableFloat;
import fuzs.puzzleslib.api.event.v1.data.MutableInt;
import fuzs.puzzleslib.api.event.v1.data.MutableValue;
import fuzs.puzzleslib.api.event.v1.entity.EnderPearlTeleportCallback;
import fuzs.puzzleslib.api.event.v1.entity.EntityRidingEvents;
import fuzs.puzzleslib.api.event.v1.entity.EntityTickEvents;
import fuzs.puzzleslib.api.event.v1.entity.ProjectileImpactCallback;
import fuzs.puzzleslib.api.event.v1.entity.RefreshEntityDimensionsCallback;
import fuzs.puzzleslib.api.event.v1.entity.ServerEntityLevelEvents;
import fuzs.puzzleslib.api.event.v1.entity.living.AnimalTameCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.BabyEntitySpawnCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.CalculateLivingVisibilityCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.CheckMobDespawnCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingAttackCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingChangeTargetCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingConversionCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingDeathCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingDropsCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingEquipmentChangeCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingExperienceDropCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingFallCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingHurtCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingJumpCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingKnockBackCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LookingAtEndermanCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.MobEffectEvents;
import fuzs.puzzleslib.api.event.v1.entity.living.PickProjectileCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.ShieldBlockCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.UseItemEvents;
import fuzs.puzzleslib.api.event.v1.entity.player.AfterChangeDimensionCallback;
import fuzs.puzzleslib.api.event.v1.entity.player.ArrowLooseCallback;
import fuzs.puzzleslib.api.event.v1.entity.player.CalculateBlockBreakSpeedCallback;
import fuzs.puzzleslib.api.event.v1.entity.player.ContainerEvents;
import fuzs.puzzleslib.api.event.v1.entity.player.CreateAnvilResultCallback;
import fuzs.puzzleslib.api.event.v1.entity.player.CreateGrindstoneResultCallback;
import fuzs.puzzleslib.api.event.v1.entity.player.ItemEntityEvents;
import fuzs.puzzleslib.api.event.v1.entity.player.PickupExperienceCallback;
import fuzs.puzzleslib.api.event.v1.entity.player.PlayerCopyEvents;
import fuzs.puzzleslib.api.event.v1.entity.player.PlayerInteractEvents;
import fuzs.puzzleslib.api.event.v1.entity.player.PlayerNetworkEvents;
import fuzs.puzzleslib.api.event.v1.entity.player.PlayerTickEvents;
import fuzs.puzzleslib.api.event.v1.entity.player.PlayerTrackingEvents;
import fuzs.puzzleslib.api.event.v1.level.BlockEvents;
import fuzs.puzzleslib.api.event.v1.level.ExplosionEvents;
import fuzs.puzzleslib.api.event.v1.level.GatherPotentialSpawnsCallback;
import fuzs.puzzleslib.api.event.v1.level.PlaySoundEvents;
import fuzs.puzzleslib.api.event.v1.level.ServerChunkEvents;
import fuzs.puzzleslib.api.event.v1.level.ServerLevelEvents;
import fuzs.puzzleslib.api.event.v1.level.ServerLevelTickEvents;
import fuzs.puzzleslib.api.event.v1.level.UseBoneMealCallback;
import fuzs.puzzleslib.api.event.v1.server.AddDataPackReloadListenersCallback;
import fuzs.puzzleslib.api.event.v1.server.LootTableLoadCallback;
import fuzs.puzzleslib.api.event.v1.server.RegisterCommandsCallback;
import fuzs.puzzleslib.api.event.v1.server.RegisterConfigurationTasksCallback;
import fuzs.puzzleslib.api.event.v1.server.RegisterPotionBrewingMixesCallback;
import fuzs.puzzleslib.api.event.v1.server.ServerLifecycleEvents;
import fuzs.puzzleslib.api.event.v1.server.ServerTickEvents;
import fuzs.puzzleslib.api.event.v1.server.SyncDataPackContentsCallback;
import fuzs.puzzleslib.api.event.v1.server.TagsUpdatedCallback;
import fuzs.puzzleslib.impl.PuzzlesLib;
import fuzs.puzzleslib.impl.event.CopyOnWriteForwardingList;
import fuzs.puzzleslib.impl.event.EventImplHelper;
import fuzs.puzzleslib.impl.event.PotentialSpawnsList;
import fuzs.puzzleslib.impl.event.core.EventInvokerImpl;
import fuzs.puzzleslib.impl.event.data.DefaultedDouble;
import fuzs.puzzleslib.impl.event.data.DefaultedFloat;
import fuzs.puzzleslib.impl.event.data.DefaultedInt;
import fuzs.puzzleslib.impl.event.data.DefaultedValue;
import fuzs.puzzleslib.neoforge.api.core.v1.NeoForgeModContainerHelper;
import fuzs.puzzleslib.neoforge.api.event.v1.core.NeoForgeEventInvokerRegistry;
import fuzs.puzzleslib.neoforge.impl.event.ForwardingLootTableBuilder;
import fuzs.puzzleslib.neoforge.impl.init.NeoForgePotionBrewingBuilder;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerConfigurationPacketListenerImpl;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.TriState;
import net.minecraft.util.random.Weighted;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.GrindstoneMenu;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.GameMasterBlock;
import net.minecraft.world.level.chunk.LevelChunk;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.event.IModBusEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.damagesource.DamageContainer;
import net.neoforged.neoforge.event.AddServerReloadListenersEvent;
import net.neoforged.neoforge.event.AnvilUpdateEvent;
import net.neoforged.neoforge.event.BlockEntityTypeAddBlocksEvent;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.GrindstoneEvent;
import net.neoforged.neoforge.event.LootTableLoadEvent;
import net.neoforged.neoforge.event.ModifyDefaultComponentsEvent;
import net.neoforged.neoforge.event.OnDatapackSyncEvent;
import net.neoforged.neoforge.event.PlayLevelSoundEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.TagsUpdatedEvent;
import net.neoforged.neoforge.event.brewing.RegisterBrewingRecipesEvent;
import net.neoforged.neoforge.event.entity.EntityEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.EntityLeaveLevelEvent;
import net.neoforged.neoforge.event.entity.EntityMountEvent;
import net.neoforged.neoforge.event.entity.EntityTeleportEvent;
import net.neoforged.neoforge.event.entity.ProjectileImpactEvent;
import net.neoforged.neoforge.event.entity.item.ItemTossEvent;
import net.neoforged.neoforge.event.entity.living.AnimalTameEvent;
import net.neoforged.neoforge.event.entity.living.BabyEntitySpawnEvent;
import net.neoforged.neoforge.event.entity.living.EnderManAngerEvent;
import net.neoforged.neoforge.event.entity.living.LivingChangeTargetEvent;
import net.neoforged.neoforge.event.entity.living.LivingConversionEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;
import net.neoforged.neoforge.event.entity.living.LivingEquipmentChangeEvent;
import net.neoforged.neoforge.event.entity.living.LivingEvent;
import net.neoforged.neoforge.event.entity.living.LivingExperienceDropEvent;
import net.neoforged.neoforge.event.entity.living.LivingFallEvent;
import net.neoforged.neoforge.event.entity.living.LivingGetProjectileEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingKnockBackEvent;
import net.neoforged.neoforge.event.entity.living.LivingShieldBlockEvent;
import net.neoforged.neoforge.event.entity.living.MobDespawnEvent;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.event.entity.player.ArrowLooseEvent;
import net.neoforged.neoforge.event.entity.player.AttackEntityEvent;
import net.neoforged.neoforge.event.entity.player.BonemealEvent;
import net.neoforged.neoforge.event.entity.player.ItemEntityPickupEvent;
import net.neoforged.neoforge.event.entity.player.PlayerContainerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.entity.player.PlayerXpEvent;
import net.neoforged.neoforge.event.level.BlockDropsEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.level.ChunkEvent;
import net.neoforged.neoforge.event.level.ChunkWatchEvent;
import net.neoforged.neoforge.event.level.ExplosionEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.server.ServerAboutToStartEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.event.server.ServerStoppedEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.neoforged.neoforge.network.event.RegisterConfigurationTasksEvent;
import net.neoforged.neoforge.registries.ModifyRegistriesEvent;
import net.neoforged.neoforge.registries.callback.AddCallback;
import net.neoforged.neoforge.registries.callback.BakeCallback;
import net.neoforged.neoforge.registries.callback.RegistryCallback;
import org.jetbrains.annotations.Nullable;

public final class NeoForgeEventInvokerRegistryImpl
implements NeoForgeEventInvokerRegistry {
    private static boolean frozenModBusEvents;

    public static void registerLoadingHandlers() {
        INSTANCE.register(CommonSetupCallback.class, FMLCommonSetupEvent.class, (T callback, E event) -> event.enqueueWork(callback::onCommonSetup));
        INSTANCE.register(LoadCompleteCallback.class, FMLLoadCompleteEvent.class, (T callback, E event) -> event.enqueueWork(callback::onLoadComplete));
        INSTANCE.register(RegistryEntryAddedCallback.class, ModifyRegistriesEvent.class, NeoForgeEventInvokerRegistryImpl::onRegistryEntryAdded);
        INSTANCE.register(FinalizeItemComponentsCallback.class, ModifyDefaultComponentsEvent.class, (T callback, E event) -> event.getAllItems().forEach(item -> callback.onFinalizeItemComponents((Item)item, function -> event.modify((ItemLike)item, builder -> {
            DataComponentPatch.SplitResult splitResult = ((DataComponentPatch)function.apply(item.components())).split();
            splitResult.added().stream().forEach(arg_0 -> ((DataComponentPatch.Builder)builder).set(arg_0));
            splitResult.removed().forEach(arg_0 -> ((DataComponentPatch.Builder)builder).remove(arg_0));
        }))));
        INSTANCE.register(ComputeItemAttributeModifiersCallback.class, ModifyDefaultComponentsEvent.class, (T callback, E event) -> event.getAllItems().forEach(item -> {
            ItemAttributeModifiers itemAttributeModifiers = (ItemAttributeModifiers)item.components().getOrDefault(DataComponents.ATTRIBUTE_MODIFIERS, (Object)ItemAttributeModifiers.EMPTY);
            CopyOnWriteForwardingList<ItemAttributeModifiers.Entry> entries = new CopyOnWriteForwardingList<ItemAttributeModifiers.Entry>(itemAttributeModifiers.modifiers());
            callback.onComputeItemAttributeModifiers((Item)item, (List<ItemAttributeModifiers.Entry>)entries);
            if (entries.delegate() != itemAttributeModifiers.modifiers()) {
                event.modify((ItemLike)item, builder -> builder.set(DataComponents.ATTRIBUTE_MODIFIERS, (Object)new ItemAttributeModifiers((List)ImmutableList.copyOf((Collection)entries))));
            }
        }));
        INSTANCE.register(AddBlockEntityTypeBlocksCallback.class, BlockEntityTypeAddBlocksEvent.class, (T callback, E event) -> callback.onAddBlockEntityTypeBlocks((x$0, xva$1) -> event.modify(x$0, new Block[]{xva$1})));
        INSTANCE.register(BuildCreativeModeTabContentsCallback.class, BuildCreativeModeTabContentsEvent.class, (T callback, E event, Object context) -> {
            Objects.requireNonNull(context, "context is null");
            ResourceKey resourceKey = (ResourceKey)context;
            if (resourceKey == event.getTabKey()) {
                callback.onBuildCreativeModeTabContents(event.getTab(), event.getParameters(), (CreativeModeTab.Output)event);
            }
        });
        INSTANCE.register(RegisterConfigurationTasksCallback.class, RegisterConfigurationTasksEvent.class, (T callback, E event) -> {
            ServerConfigurationPacketListenerImpl listener = (ServerConfigurationPacketListenerImpl)event.getListener();
            callback.onRegisterConfigurationTasks(listener.server, listener, arg_0 -> ((RegisterConfigurationTasksEvent)event).register(arg_0));
        });
    }

    private static <T> void onRegistryEntryAdded(RegistryEntryAddedCallback<T> callback, ModifyRegistriesEvent event, @Nullable Object context) {
        Objects.requireNonNull(context, "context is null");
        ResourceKey resourceKey = (ResourceKey)context;
        Registry registry = event.getRegistry(resourceKey);
        boolean[] loadComplete = new boolean[1];
        registry.addCallback((RegistryCallback)((AddCallback)(callbackRegistry, id, key, value) -> {
            if (!loadComplete[0]) {
                try {
                    callback.onRegistryEntryAdded(callbackRegistry, key.location(), value, NeoForgeEventInvokerRegistryImpl.onRegistryEntryAdded(registry));
                }
                catch (Exception exception) {
                    PuzzlesLib.LOGGER.error("Failed to run registry entry added callback", (Throwable)exception);
                }
            }
        }));
        registry.addCallback((RegistryCallback)((BakeCallback)registryx -> {
            loadComplete[0] = true;
        }));
        LinkedList<Consumer<BiConsumer>> callbacks = new LinkedList<Consumer<BiConsumer>>();
        for (Map.Entry entry : registry.entrySet()) {
            callbacks.offer(consumer -> {
                try {
                    callback.onRegistryEntryAdded((Registry)registry, ((ResourceKey)entry.getKey()).location(), (Object)entry.getValue(), (BiConsumer)consumer);
                }
                catch (Exception exception) {
                    PuzzlesLib.LOGGER.error("Failed to run registry entry added callback", (Throwable)exception);
                }
            });
        }
        IEventBus eventBus = NeoForgeModContainerHelper.getModEventBus("puzzleslib");
        eventBus.addListener(eventX -> {
            Consumer consumer;
            if (eventX.getRegistryKey() != resourceKey) {
                return;
            }
            while ((consumer = (Consumer)callbacks.poll()) != null) {
                consumer.accept(NeoForgeEventInvokerRegistryImpl.onRegistryEntryAdded(eventX.getRegistry()));
            }
        });
    }

    private static <T> BiConsumer<ResourceLocation, Supplier<T>> onRegistryEntryAdded(Registry<T> registry) {
        return (resourceLocation, supplier) -> {
            try {
                Object t = supplier.get();
                Objects.requireNonNull(t, "entry is null");
                Registry.register((Registry)registry, (ResourceLocation)resourceLocation, t);
            }
            catch (Exception exception) {
                PuzzlesLib.LOGGER.error("Failed to register new entry", (Throwable)exception);
            }
        };
    }

    public static void freezeModBusEvents() {
        frozenModBusEvents = true;
    }

    public static void registerEventHandlers() {
        INSTANCE.register(PlayerInteractEvents.UseBlock.class, PlayerInteractEvent.RightClickBlock.class, (T callback, E event) -> callback.onUseBlock(event.getEntity(), event.getLevel(), event.getHand(), event.getHitVec()).ifInterrupt(interactionResult -> {
            event.setCancellationResult(interactionResult);
            event.setCanceled(true);
        }));
        INSTANCE.register(PlayerInteractEvents.AttackBlock.class, PlayerInteractEvent.LeftClickBlock.class, (T callback, E event) -> {
            if (callback.onAttackBlock(event.getEntity(), event.getLevel(), event.getHand(), event.getPos(), event.getFace()).isInterrupt()) {
                event.setCanceled(true);
            }
        });
        INSTANCE.register(PlayerInteractEvents.UseItem.class, PlayerInteractEvent.RightClickItem.class, (T callback, E event) -> callback.onUseItem(event.getEntity(), event.getLevel(), event.getHand()).ifInterrupt(interactionResult -> {
            event.setCancellationResult(interactionResult);
            event.setCanceled(true);
        }));
        INSTANCE.register(PlayerInteractEvents.UseEntity.class, PlayerInteractEvent.EntityInteract.class, (T callback, E event) -> callback.onUseEntity(event.getEntity(), event.getLevel(), event.getHand(), event.getTarget()).ifInterrupt(interactionResult -> {
            event.setCancellationResult(interactionResult);
            event.setCanceled(true);
        }));
        INSTANCE.register(PlayerInteractEvents.UseEntityAt.class, PlayerInteractEvent.EntityInteractSpecific.class, (T callback, E event) -> callback.onUseEntityAt(event.getEntity(), event.getLevel(), event.getHand(), event.getTarget(), event.getLocalPos()).ifInterrupt(interactionResult -> {
            event.setCancellationResult(interactionResult);
            event.setCanceled(true);
        }));
        INSTANCE.register(PlayerInteractEvents.AttackEntity.class, AttackEntityEvent.class, (T callback, E event) -> {
            if (callback.onAttackEntity(event.getEntity(), event.getEntity().level(), InteractionHand.MAIN_HAND, event.getTarget()).isInterrupt()) {
                event.setCanceled(true);
            }
        });
        INSTANCE.register(PickupExperienceCallback.class, PlayerXpEvent.PickupXp.class, (T callback, E event) -> {
            if (callback.onPickupExperience(event.getEntity(), event.getOrb()).isInterrupt()) {
                event.setCanceled(true);
            }
        });
        INSTANCE.register(UseBoneMealCallback.class, BonemealEvent.class, (T callback, E event) -> {
            EventResult eventResult = callback.onUseBoneMeal(event.getLevel(), event.getPos(), event.getState(), event.getStack());
            if (eventResult.isInterrupt()) {
                event.setSuccessful(eventResult.getAsBoolean());
            }
        });
        INSTANCE.register(LivingExperienceDropCallback.class, LivingExperienceDropEvent.class, (T callback, E event) -> {
            DefaultedInt droppedExperience = DefaultedInt.fromEvent(arg_0 -> ((LivingExperienceDropEvent)event).setDroppedExperience(arg_0), () -> ((LivingExperienceDropEvent)event).getDroppedExperience(), () -> ((LivingExperienceDropEvent)event).getOriginalExperience());
            if (callback.onLivingExperienceDrop(event.getEntity(), event.getAttackingPlayer(), droppedExperience).isInterrupt()) {
                event.setCanceled(true);
            }
        });
        INSTANCE.register(BlockEvents.Break.class, BlockEvent.BreakEvent.class, (T callback, E event) -> {
            LevelAccessor patt0$temp = event.getLevel();
            if (!(patt0$temp instanceof ServerLevel)) {
                return;
            }
            ServerLevel serverLevel = (ServerLevel)patt0$temp;
            Player patt1$temp = event.getPlayer();
            if (!(patt1$temp instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer serverPlayer = (ServerPlayer)patt1$temp;
            if (event.getState().getBlock() instanceof GameMasterBlock && !serverPlayer.canUseGameMasterBlocks()) {
                return;
            }
            GameType gameType = serverPlayer.gameMode.getGameModeForPlayer();
            if (serverPlayer.blockActionRestricted((Level)event.getLevel(), event.getPos(), gameType)) {
                return;
            }
            EventResult eventResult = callback.onBreakBlock(serverLevel, event.getPos(), event.getState(), serverPlayer, serverPlayer.getMainHandItem());
            if (eventResult.isInterrupt()) {
                event.setCanceled(true);
            }
        });
        INSTANCE.register(BlockEvents.DropExperience.class, BlockDropsEvent.class, (T callback, E event) -> {
            Entity patt0$temp = event.getBreaker();
            if (!(patt0$temp instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer serverPlayer = (ServerPlayer)patt0$temp;
            MutableInt experienceAmount = MutableInt.fromEvent(arg_0 -> ((BlockDropsEvent)event).setDroppedExperience(arg_0), () -> ((BlockDropsEvent)event).getDroppedExperience());
            callback.onDropExperience(event.getLevel(), event.getPos(), event.getState(), serverPlayer, event.getTool(), experienceAmount);
        });
        INSTANCE.register(PlayerTickEvents.Start.class, PlayerTickEvent.Pre.class, (T callback, E event) -> callback.onStartPlayerTick(event.getEntity()));
        INSTANCE.register(PlayerTickEvents.End.class, PlayerTickEvent.Post.class, (T callback, E event) -> callback.onEndPlayerTick(event.getEntity()));
        INSTANCE.register(LivingFallCallback.class, LivingFallEvent.class, (T callback, E event) -> {
            MutableDouble fallDistance = MutableDouble.fromEvent(arg_0 -> ((LivingFallEvent)event).setDistance(arg_0), () -> ((LivingFallEvent)event).getDistance());
            MutableFloat damageMultiplier = MutableFloat.fromEvent(arg_0 -> ((LivingFallEvent)event).setDamageMultiplier(arg_0), () -> ((LivingFallEvent)event).getDamageMultiplier());
            if (callback.onLivingFall(event.getEntity(), fallDistance, damageMultiplier).isInterrupt()) {
                event.setCanceled(true);
            }
        });
        INSTANCE.register(RegisterCommandsCallback.class, RegisterCommandsEvent.class, (T callback, E event) -> callback.onRegisterCommands((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getBuildContext(), event.getCommandSelection()));
        INSTANCE.register(LootTableLoadCallback.class, LootTableLoadEvent.class, (T callback, E event) -> callback.onLootTableLoad(event.getName(), new ForwardingLootTableBuilder(event.getTable()), event.getRegistries()));
        INSTANCE.register(ItemEntityEvents.Touch.class, ItemEntityPickupEvent.Pre.class, (T callback, E event) -> {
            EventResult eventResult = callback.onItemTouch(event.getPlayer(), event.getItemEntity());
            if (eventResult.isInterrupt()) {
                event.setCanPickup(eventResult.getAsBoolean() ? TriState.TRUE : TriState.FALSE);
            }
        });
        INSTANCE.register(ItemEntityEvents.Pickup.class, ItemEntityPickupEvent.Post.class, (T callback, E event) -> callback.onItemPickup(event.getPlayer(), event.getItemEntity(), event.getOriginalStack()));
        INSTANCE.register(CreateAnvilResultCallback.class, AnvilUpdateEvent.class, (T callback, E event) -> {
            DefaultedValue<ItemStack> outputItemStack = DefaultedValue.fromEvent(arg_0 -> ((AnvilUpdateEvent)event).setOutput(arg_0), () -> ((AnvilUpdateEvent)event).getOutput(), () -> ((AnvilUpdateEvent.VanillaResult)event.getVanillaResult()).output());
            DefaultedInt enchantmentLevelCost = DefaultedInt.fromEvent(arg_0 -> ((AnvilUpdateEvent)event).setXpCost(arg_0), () -> ((AnvilUpdateEvent)event).getXpCost(), () -> ((AnvilUpdateEvent.VanillaResult)event.getVanillaResult()).xpCost());
            DefaultedInt repairMaterialCost = DefaultedInt.fromEvent(arg_0 -> ((AnvilUpdateEvent)event).setMaterialCost(arg_0), () -> ((AnvilUpdateEvent)event).getMaterialCost(), () -> ((AnvilUpdateEvent.VanillaResult)event.getVanillaResult()).materialCost());
            if (callback.onCreateAnvilResult(event.getPlayer(), event.getLeft(), event.getRight(), outputItemStack, event.getName(), enchantmentLevelCost, repairMaterialCost).isInterrupt()) {
                event.setCanceled(true);
            }
        });
        INSTANCE.register(CreateGrindstoneResultCallback.class, GrindstoneEvent.OnPlaceItem.class, (T callback, E event) -> {
            Map.Entry<GrindstoneMenu, Player> entry = EventImplHelper.getGrindstoneMenuFromInputs(event.getTopItem(), event.getBottomItem());
            if (entry != null) {
                com.google.common.base.Supplier outputItemStackSupplier = Suppliers.memoize(() -> ((GrindstoneMenu)entry.getKey()).computeResult(event.getTopItem(), event.getBottomItem()));
                MutableValue<ItemStack> outputItemStack = MutableValue.fromEvent(arg_0 -> ((GrindstoneEvent.OnPlaceItem)event).setOutput(arg_0), () -> NeoForgeEventInvokerRegistryImpl.lambda$registerEventHandlers$42(event, (Supplier)outputItemStackSupplier));
                MutableInt experiencePointReward = MutableInt.fromEvent(arg_0 -> ((GrindstoneEvent.OnPlaceItem)event).setXp(arg_0), () -> ((GrindstoneEvent.OnPlaceItem)event).getXp());
                EventResult eventResult = callback.onCreateGrindstoneResult(entry.getValue(), event.getTopItem(), event.getBottomItem(), outputItemStack, experiencePointReward);
                if (eventResult.isInterrupt()) {
                    event.setCanceled(true);
                }
            }
        });
        INSTANCE.register(LivingDropsCallback.class, LivingDropsEvent.class, (T callback, E event) -> {
            if (callback.onLivingDrops(event.getEntity(), event.getSource(), event.getDrops(), event.isRecentlyHit()).isInterrupt()) {
                event.setCanceled(true);
            }
        });
        INSTANCE.register(EntityTickEvents.Start.class, EntityTickEvent.Pre.class, (T callback, E event) -> {
            if (callback.onStartEntityTick(event.getEntity()).isInterrupt()) {
                event.setCanceled(true);
            }
        });
        INSTANCE.register(EntityTickEvents.End.class, EntityTickEvent.Post.class, (T callback, E event) -> callback.onEndEntityTick(event.getEntity()));
        INSTANCE.register(ArrowLooseCallback.class, ArrowLooseEvent.class, (T callback, E event) -> {
            MutableInt charge = MutableInt.fromEvent(arg_0 -> ((ArrowLooseEvent)event).setCharge(arg_0), () -> ((ArrowLooseEvent)event).getCharge());
            if (callback.onArrowLoose(event.getEntity(), event.getBow(), event.getLevel(), charge, event.hasAmmo()).isInterrupt()) {
                event.setCanceled(true);
            }
        });
        INSTANCE.register(LivingHurtCallback.class, LivingDamageEvent.Pre.class, (T callback, E event) -> {
            MutableFloat damageAmount = MutableFloat.fromEvent(arg_0 -> ((DamageContainer)event.getContainer()).setNewDamage(arg_0), () -> ((DamageContainer)event.getContainer()).getNewDamage());
            if (callback.onLivingHurt(event.getEntity(), event.getContainer().getSource(), damageAmount).isInterrupt()) {
                event.getContainer().setNewDamage(0.0f);
            }
        });
        INSTANCE.register(UseItemEvents.Start.class, LivingEntityUseItemEvent.Start.class, (T callback, E event) -> {
            MutableInt useDuration = MutableInt.fromEvent(arg_0 -> ((LivingEntityUseItemEvent.Start)event).setDuration(arg_0), () -> ((LivingEntityUseItemEvent.Start)event).getDuration());
            if (callback.onUseItemStart(event.getEntity(), event.getItem(), useDuration).isInterrupt()) {
                event.setCanceled(true);
            }
        });
        INSTANCE.register(UseItemEvents.Tick.class, LivingEntityUseItemEvent.Tick.class, (T callback, E event) -> {
            MutableInt useItemRemaining = MutableInt.fromEvent(arg_0 -> ((LivingEntityUseItemEvent.Tick)event).setDuration(arg_0), () -> ((LivingEntityUseItemEvent.Tick)event).getDuration());
            if (callback.onUseItemTick(event.getEntity(), event.getItem(), useItemRemaining).isInterrupt()) {
                event.setCanceled(true);
            }
        });
        INSTANCE.register(UseItemEvents.Stop.class, LivingEntityUseItemEvent.Stop.class, (T callback, E event) -> {
            if (callback.onUseItemStop(event.getEntity(), event.getItem(), event.getDuration()).isInterrupt()) {
                event.setCanceled(true);
            }
        });
        INSTANCE.register(UseItemEvents.Finish.class, LivingEntityUseItemEvent.Finish.class, (T callback, E event) -> {
            MutableValue<ItemStack> itemStack = MutableValue.fromEvent(arg_0 -> ((LivingEntityUseItemEvent.Finish)event).setResultStack(arg_0), () -> ((LivingEntityUseItemEvent.Finish)event).getResultStack());
            callback.onUseItemFinish(event.getEntity(), itemStack, event.getItem());
        });
        INSTANCE.register(ShieldBlockCallback.class, LivingShieldBlockEvent.class, (T callback, E event) -> {
            if (!event.getBlocked()) {
                return;
            }
            DefaultedFloat blockedDamage = DefaultedFloat.fromEvent(arg_0 -> ((LivingShieldBlockEvent)event).setBlockedDamage(arg_0), () -> ((LivingShieldBlockEvent)event).getBlockedDamage(), () -> ((LivingShieldBlockEvent)event).getOriginalBlockedDamage());
            if (callback.onShieldBlock(event.getEntity(), event.getDamageSource(), blockedDamage).isInterrupt()) {
                event.setBlocked(true);
            }
        });
        INSTANCE.register(TagsUpdatedCallback.class, TagsUpdatedEvent.class, (T callback, E event) -> callback.onTagsUpdated(event.getLookupProvider(), event.getUpdateCause() == TagsUpdatedEvent.UpdateCause.CLIENT_PACKET_RECEIVED));
        INSTANCE.register(ExplosionEvents.Start.class, ExplosionEvent.Start.class, (T callback, E event) -> {
            Level patt0$temp = event.getLevel();
            if (!(patt0$temp instanceof ServerLevel)) {
                return;
            }
            ServerLevel serverLevel = (ServerLevel)patt0$temp;
            if (callback.onExplosionStart(serverLevel, event.getExplosion()).isInterrupt()) {
                event.setCanceled(true);
            }
        });
        INSTANCE.register(ExplosionEvents.Detonate.class, ExplosionEvent.Detonate.class, (T callback, E event) -> {
            Level patt0$temp = event.getLevel();
            if (!(patt0$temp instanceof ServerLevel)) {
                return;
            }
            ServerLevel serverLevel = (ServerLevel)patt0$temp;
            callback.onExplosionDetonate(serverLevel, event.getExplosion(), event.getAffectedBlocks(), event.getAffectedEntities());
        });
        INSTANCE.register(SyncDataPackContentsCallback.class, OnDatapackSyncEvent.class, (T callback, E event) -> event.getRelevantPlayers().forEach(player -> callback.onSyncDataPackContents((ServerPlayer)player, event.getPlayer() != null)));
        INSTANCE.register(ServerLifecycleEvents.Starting.class, ServerAboutToStartEvent.class, (T callback, E event) -> callback.onServerStarting(event.getServer()));
        INSTANCE.register(ServerLifecycleEvents.Started.class, ServerStartedEvent.class, (T callback, E event) -> callback.onServerStarted(event.getServer()));
        INSTANCE.register(ServerLifecycleEvents.Stopping.class, ServerStoppingEvent.class, (T callback, E event) -> callback.onServerStopping(event.getServer()));
        INSTANCE.register(ServerLifecycleEvents.Stopped.class, ServerStoppedEvent.class, (T callback, E event) -> callback.onServerStopped(event.getServer()));
        INSTANCE.register(PlaySoundEvents.AtPosition.class, PlayLevelSoundEvent.AtPosition.class, (T callback, E event) -> {
            MutableValue<Holder<SoundEvent>> soundEvent = MutableValue.fromEvent(arg_0 -> ((PlayLevelSoundEvent.AtPosition)event).setSound(arg_0), () -> ((PlayLevelSoundEvent.AtPosition)event).getSound());
            MutableValue<SoundSource> soundSource = MutableValue.fromEvent(arg_0 -> ((PlayLevelSoundEvent.AtPosition)event).setSource(arg_0), () -> ((PlayLevelSoundEvent.AtPosition)event).getSource());
            MutableFloat soundVolume = MutableFloat.fromEvent(arg_0 -> ((PlayLevelSoundEvent.AtPosition)event).setNewVolume(arg_0), () -> ((PlayLevelSoundEvent.AtPosition)event).getNewVolume());
            MutableFloat soundPitch = MutableFloat.fromEvent(arg_0 -> ((PlayLevelSoundEvent.AtPosition)event).setNewPitch(arg_0), () -> ((PlayLevelSoundEvent.AtPosition)event).getNewPitch());
            if (callback.onPlaySoundAtPosition(event.getLevel(), event.getPosition(), soundEvent, soundSource, soundVolume, soundPitch).isInterrupt()) {
                event.setCanceled(true);
            }
        });
        INSTANCE.register(PlaySoundEvents.AtEntity.class, PlayLevelSoundEvent.AtEntity.class, (T callback, E event) -> {
            MutableValue<Holder<SoundEvent>> soundEvent = MutableValue.fromEvent(arg_0 -> ((PlayLevelSoundEvent.AtEntity)event).setSound(arg_0), () -> ((PlayLevelSoundEvent.AtEntity)event).getSound());
            MutableValue<SoundSource> soundSource = MutableValue.fromEvent(arg_0 -> ((PlayLevelSoundEvent.AtEntity)event).setSource(arg_0), () -> ((PlayLevelSoundEvent.AtEntity)event).getSource());
            MutableFloat soundVolume = MutableFloat.fromEvent(arg_0 -> ((PlayLevelSoundEvent.AtEntity)event).setNewVolume(arg_0), () -> ((PlayLevelSoundEvent.AtEntity)event).getNewVolume());
            MutableFloat soundPitch = MutableFloat.fromEvent(arg_0 -> ((PlayLevelSoundEvent.AtEntity)event).setNewPitch(arg_0), () -> ((PlayLevelSoundEvent.AtEntity)event).getNewPitch());
            if (callback.onPlaySoundAtEntity(event.getLevel(), event.getEntity(), soundEvent, soundSource, soundVolume, soundPitch).isInterrupt()) {
                event.setCanceled(true);
            }
        });
        INSTANCE.register(ServerEntityLevelEvents.Load.class, EntityJoinLevelEvent.class, (T callback, E event) -> {
            Level patt0$temp = event.getLevel();
            if (!(patt0$temp instanceof ServerLevel)) {
                return;
            }
            ServerLevel serverLevel = (ServerLevel)patt0$temp;
            if (callback.onEntityLoad(event.getEntity(), serverLevel, !event.loadedFromDisk()).isInterrupt()) {
                if (event.getEntity() instanceof Player) {
                    throw new UnsupportedOperationException("Cannot prevent player from loading in!");
                }
                event.setCanceled(true);
            }
        });
        INSTANCE.register(ServerEntityLevelEvents.Unload.class, EntityLeaveLevelEvent.class, (T callback, E event) -> {
            Level patt0$temp = event.getLevel();
            if (!(patt0$temp instanceof ServerLevel)) {
                return;
            }
            ServerLevel serverLevel = (ServerLevel)patt0$temp;
            callback.onEntityUnload(event.getEntity(), serverLevel);
        });
        INSTANCE.register(LivingDeathCallback.class, LivingDeathEvent.class, (T callback, E event) -> {
            if (callback.onLivingDeath(event.getEntity(), event.getSource()).isInterrupt()) {
                event.setCanceled(true);
            }
        });
        INSTANCE.register(PlayerTrackingEvents.Start.class, PlayerEvent.StartTracking.class, (T callback, E event) -> {
            Player patt0$temp = event.getEntity();
            if (!(patt0$temp instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer serverPlayer = (ServerPlayer)patt0$temp;
            callback.onStartTracking(event.getTarget(), serverPlayer);
        });
        INSTANCE.register(PlayerTrackingEvents.Stop.class, PlayerEvent.StopTracking.class, (T callback, E event) -> {
            Player patt0$temp = event.getEntity();
            if (!(patt0$temp instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer serverPlayer = (ServerPlayer)patt0$temp;
            callback.onStopTracking(event.getTarget(), serverPlayer);
        });
        INSTANCE.register(PlayerNetworkEvents.LoggedIn.class, PlayerEvent.PlayerLoggedInEvent.class, (T callback, E event) -> {
            Player patt0$temp = event.getEntity();
            if (!(patt0$temp instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer serverPlayer = (ServerPlayer)patt0$temp;
            callback.onLoggedIn(serverPlayer);
        });
        INSTANCE.register(PlayerNetworkEvents.LoggedOut.class, PlayerEvent.PlayerLoggedOutEvent.class, (T callback, E event) -> {
            Player patt0$temp = event.getEntity();
            if (!(patt0$temp instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer serverPlayer = (ServerPlayer)patt0$temp;
            callback.onLoggedOut(serverPlayer);
        });
        INSTANCE.register(AfterChangeDimensionCallback.class, PlayerEvent.PlayerChangedDimensionEvent.class, (T callback, E event) -> {
            Player patt0$temp = event.getEntity();
            if (!(patt0$temp instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer serverPlayer = (ServerPlayer)patt0$temp;
            ServerLevel originalLevel = serverPlayer.level().getServer().getLevel(event.getFrom());
            ServerLevel newLevel = serverPlayer.level().getServer().getLevel(event.getTo());
            Objects.requireNonNull(originalLevel, "original level is null");
            Objects.requireNonNull(newLevel, "new level is null");
            callback.onAfterChangeDimension(serverPlayer, originalLevel, newLevel);
        });
        INSTANCE.register(BabyEntitySpawnCallback.class, BabyEntitySpawnEvent.class, (T callback, E event) -> {
            MutableValue<AgeableMob> child = MutableValue.fromEvent(arg_0 -> ((BabyEntitySpawnEvent)event).setChild(arg_0), () -> ((BabyEntitySpawnEvent)event).getChild());
            if (callback.onBabyEntitySpawn(event.getParentA(), event.getParentB(), child).isInterrupt()) {
                event.setCanceled(true);
            }
        });
        INSTANCE.register(AnimalTameCallback.class, AnimalTameEvent.class, (T callback, E event) -> {
            if (callback.onAnimalTame(event.getAnimal(), event.getTamer()).isInterrupt()) {
                event.setCanceled(true);
            }
        });
        INSTANCE.register(LivingAttackCallback.class, LivingIncomingDamageEvent.class, (T callback, E event) -> {
            if (callback.onLivingAttack(event.getEntity(), event.getSource(), event.getAmount()).isInterrupt()) {
                event.setCanceled(true);
            }
        });
        INSTANCE.register(PlayerCopyEvents.Copy.class, PlayerEvent.Clone.class, (T callback, E event) -> {
            Player patt0$temp = event.getOriginal();
            if (!(patt0$temp instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer originalServerPlayer = (ServerPlayer)patt0$temp;
            Player patt1$temp = event.getEntity();
            if (!(patt1$temp instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer newServerPlayer = (ServerPlayer)patt1$temp;
            callback.onCopy(originalServerPlayer, newServerPlayer, !event.isWasDeath());
        });
        INSTANCE.register(PlayerCopyEvents.Respawn.class, PlayerEvent.PlayerRespawnEvent.class, (T callback, E event) -> {
            Player patt0$temp = event.getEntity();
            if (!(patt0$temp instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer serverPlayer = (ServerPlayer)patt0$temp;
            callback.onRespawn(serverPlayer, event.isEndConquered());
        });
        INSTANCE.register(ServerTickEvents.Start.class, ServerTickEvent.Pre.class, (T callback, E event) -> callback.onStartServerTick(event.getServer()));
        INSTANCE.register(ServerTickEvents.End.class, ServerTickEvent.Post.class, (T callback, E event) -> callback.onEndServerTick(event.getServer()));
        INSTANCE.register(ServerLevelTickEvents.Start.class, LevelTickEvent.Pre.class, (T callback, E event) -> {
            Level patt0$temp = event.getLevel();
            if (!(patt0$temp instanceof ServerLevel)) {
                return;
            }
            ServerLevel serverLevel = (ServerLevel)patt0$temp;
            callback.onStartLevelTick(serverLevel.getServer(), serverLevel);
        });
        INSTANCE.register(ServerLevelTickEvents.End.class, LevelTickEvent.Post.class, (T callback, E event) -> {
            Level patt0$temp = event.getLevel();
            if (!(patt0$temp instanceof ServerLevel)) {
                return;
            }
            ServerLevel serverLevel = (ServerLevel)patt0$temp;
            callback.onEndLevelTick(serverLevel.getServer(), serverLevel);
        });
        INSTANCE.register(ServerLevelEvents.Load.class, LevelEvent.Load.class, (T callback, E event) -> {
            LevelAccessor patt0$temp = event.getLevel();
            if (!(patt0$temp instanceof ServerLevel)) {
                return;
            }
            ServerLevel serverLevel = (ServerLevel)patt0$temp;
            callback.onLevelLoad(serverLevel.getServer(), serverLevel);
        });
        INSTANCE.register(ServerLevelEvents.Unload.class, LevelEvent.Unload.class, (T callback, E event) -> {
            LevelAccessor patt0$temp = event.getLevel();
            if (!(patt0$temp instanceof ServerLevel)) {
                return;
            }
            ServerLevel serverLevel = (ServerLevel)patt0$temp;
            callback.onLevelUnload(serverLevel.getServer(), serverLevel);
        });
        INSTANCE.register(ServerChunkEvents.Load.class, ChunkEvent.Load.class, (T callback, E event) -> {
            LevelAccessor patt0$temp = event.getLevel();
            if (!(patt0$temp instanceof ServerLevel)) {
                return;
            }
            ServerLevel serverLevel = (ServerLevel)patt0$temp;
            callback.onChunkLoad(serverLevel, (LevelChunk)event.getChunk());
        });
        INSTANCE.register(ServerChunkEvents.Unload.class, ChunkEvent.Unload.class, (T callback, E event) -> {
            LevelAccessor patt0$temp = event.getLevel();
            if (!(patt0$temp instanceof ServerLevel)) {
                return;
            }
            ServerLevel serverLevel = (ServerLevel)patt0$temp;
            callback.onChunkUnload(serverLevel, (LevelChunk)event.getChunk());
        });
        INSTANCE.register(ItemEntityEvents.Toss.class, ItemTossEvent.class, (T callback, E event) -> {
            Player patt0$temp = event.getPlayer();
            if (!(patt0$temp instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer serverPlayer = (ServerPlayer)patt0$temp;
            if (callback.onItemToss(serverPlayer, event.getEntity().getItem()).isInterrupt()) {
                event.setCanceled(true);
            }
        });
        INSTANCE.register(LivingKnockBackCallback.class, LivingKnockBackEvent.class, (T callback, E event) -> {
            DefaultedDouble strength = DefaultedDouble.fromEvent(v -> event.setStrength((float)v), () -> ((LivingKnockBackEvent)event).getStrength(), () -> ((LivingKnockBackEvent)event).getOriginalStrength());
            DefaultedDouble ratioX = DefaultedDouble.fromEvent(arg_0 -> ((LivingKnockBackEvent)event).setRatioX(arg_0), () -> ((LivingKnockBackEvent)event).getRatioX(), () -> ((LivingKnockBackEvent)event).getOriginalRatioX());
            DefaultedDouble ratioZ = DefaultedDouble.fromEvent(arg_0 -> ((LivingKnockBackEvent)event).setRatioZ(arg_0), () -> ((LivingKnockBackEvent)event).getRatioZ(), () -> ((LivingKnockBackEvent)event).getOriginalRatioZ());
            if (callback.onLivingKnockBack(event.getEntity(), strength, ratioX, ratioZ).isInterrupt()) {
                event.setCanceled(true);
            }
        });
        INSTANCE.register(ProjectileImpactCallback.class, ProjectileImpactEvent.class, (T callback, E event) -> {
            if (callback.onProjectileImpact(event.getProjectile(), event.getRayTraceResult()).isInterrupt()) {
                event.setCanceled(true);
            }
        });
        INSTANCE.register(CalculateBlockBreakSpeedCallback.class, PlayerEvent.BreakSpeed.class, (T callback, E event) -> {
            DefaultedFloat breakSpeed = DefaultedFloat.fromEvent(arg_0 -> ((PlayerEvent.BreakSpeed)event).setNewSpeed(arg_0), () -> ((PlayerEvent.BreakSpeed)event).getNewSpeed(), () -> ((PlayerEvent.BreakSpeed)event).getOriginalSpeed());
            if (callback.onCalculateBlockBreakSpeed(event.getEntity(), event.getState(), breakSpeed).isInterrupt()) {
                event.setCanceled(true);
            }
        });
        INSTANCE.register(MobEffectEvents.Affects.class, MobEffectEvent.Applicable.class, (T callback, E event) -> {
            EventResult eventResult = callback.onMobEffectAffects(event.getEntity(), event.getEffectInstance());
            if (eventResult.isInterrupt()) {
                event.setResult(eventResult.getAsBoolean() ? MobEffectEvent.Applicable.Result.APPLY : MobEffectEvent.Applicable.Result.DO_NOT_APPLY);
            }
        });
        INSTANCE.register(MobEffectEvents.Apply.class, MobEffectEvent.Added.class, (T callback, E event) -> callback.onMobEffectApply(event.getEntity(), event.getEffectInstance(), event.getOldEffectInstance(), event.getEffectSource()));
        INSTANCE.register(MobEffectEvents.Remove.class, MobEffectEvent.Remove.class, (T callback, E event) -> {
            if (callback.onMobEffectRemove(event.getEntity(), event.getEffectInstance()).isInterrupt()) {
                event.setCanceled(true);
            }
        });
        INSTANCE.register(MobEffectEvents.Expire.class, MobEffectEvent.Expired.class, (T callback, E event) -> callback.onMobEffectExpire(event.getEntity(), event.getEffectInstance()));
        INSTANCE.register(LivingJumpCallback.class, LivingEvent.LivingJumpEvent.class, (T callback, E event) -> EventImplHelper.onLivingJump(callback, event.getEntity()));
        INSTANCE.register(CalculateLivingVisibilityCallback.class, LivingEvent.LivingVisibilityEvent.class, (T callback, E event) -> callback.onCalculateLivingVisibility(event.getEntity(), event.getLookingEntity(), MutableDouble.fromEvent(visibilityModifier -> event.modifyVisibility(visibilityModifier / event.getVisibilityModifier()), () -> ((LivingEvent.LivingVisibilityEvent)event).getVisibilityModifier())));
        INSTANCE.register(LivingChangeTargetCallback.class, LivingChangeTargetEvent.class, (T callback, E event) -> {
            DefaultedValue<LivingEntity> target = DefaultedValue.fromEvent(arg_0 -> ((LivingChangeTargetEvent)event).setNewAboutToBeSetTarget(arg_0), () -> ((LivingChangeTargetEvent)event).getNewAboutToBeSetTarget(), () -> ((LivingChangeTargetEvent)event).getOriginalAboutToBeSetTarget());
            if (callback.onLivingChangeTarget(event.getEntity(), target).isInterrupt()) {
                event.setCanceled(true);
            }
        });
        INSTANCE.register(CheckMobDespawnCallback.class, MobDespawnEvent.class, (T callback, E event) -> {
            ServerLevelAccessor patt0$temp = event.getLevel();
            if (!(patt0$temp instanceof ServerLevel)) {
                return;
            }
            ServerLevel serverLevel = (ServerLevel)patt0$temp;
            EventResult eventResult = callback.onCheckMobDespawn(event.getEntity(), serverLevel);
            if (eventResult.isInterrupt()) {
                event.setResult(eventResult.getAsBoolean() ? MobDespawnEvent.Result.ALLOW : MobDespawnEvent.Result.DENY);
            }
        });
        INSTANCE.register(GatherPotentialSpawnsCallback.class, LevelEvent.PotentialSpawns.class, (T callback, E event) -> {
            LevelAccessor patt0$temp = event.getLevel();
            if (!(patt0$temp instanceof ServerLevel)) {
                return;
            }
            ServerLevel serverLevel = (ServerLevel)patt0$temp;
            PotentialSpawnsList<Weighted<MobSpawnSettings.SpawnerData>> mobs = new PotentialSpawnsList<Weighted<MobSpawnSettings.SpawnerData>>(() -> ((LevelEvent.PotentialSpawns)event).getSpawnerDataList(), spawnerData -> {
                int size = event.getSpawnerDataList().size();
                event.addSpawnerData(spawnerData);
                return size != event.getSpawnerDataList().size();
            }, spawnerData -> {
                int size = event.getSpawnerDataList().size();
                event.removeSpawnerData(spawnerData);
                return size != event.getSpawnerDataList().size();
            });
            callback.onGatherPotentialSpawns(serverLevel, serverLevel.structureManager(), serverLevel.getChunkSource().getGenerator(), event.getMobCategory(), event.getPos(), mobs);
        });
        INSTANCE.register(EntityRidingEvents.Start.class, EntityMountEvent.class, (T callback, E event) -> {
            if (event.isDismounting()) {
                return;
            }
            if (!event.getEntityMounting().canRide(event.getEntityBeingMounted())) {
                return;
            }
            if (!event.getEntityBeingMounted().canAddPassenger(event.getEntityMounting())) {
                return;
            }
            if (callback.onStartRiding(event.getLevel(), event.getEntityMounting(), event.getEntityBeingMounted()).isInterrupt()) {
                event.setCanceled(true);
            }
        });
        INSTANCE.register(EntityRidingEvents.Stop.class, EntityMountEvent.class, (T callback, E event) -> {
            if (event.isMounting()) {
                return;
            }
            if (callback.onStopRiding(event.getLevel(), event.getEntity(), event.getEntityBeingMounted()).isInterrupt()) {
                event.setCanceled(true);
            }
        });
        INSTANCE.register(ServerChunkEvents.Watch.class, ChunkWatchEvent.Watch.class, (T callback, E event) -> callback.onChunkWatch(event.getPlayer(), event.getChunk(), event.getLevel()));
        INSTANCE.register(ServerChunkEvents.Unwatch.class, ChunkWatchEvent.UnWatch.class, (T callback, E event) -> callback.onChunkUnwatch(event.getPlayer(), event.getPos(), event.getLevel()));
        INSTANCE.register(LivingEquipmentChangeCallback.class, LivingEquipmentChangeEvent.class, (T callback, E event) -> callback.onLivingEquipmentChange(event.getEntity(), event.getSlot(), event.getFrom(), event.getTo()));
        INSTANCE.register(LivingConversionCallback.class, LivingConversionEvent.Post.class, (T callback, E event) -> callback.onLivingConversion(event.getEntity(), event.getOutcome()));
        INSTANCE.register(ContainerEvents.Open.class, PlayerContainerEvent.Open.class, (T callback, E event) -> {
            Player patt0$temp = event.getEntity();
            if (!(patt0$temp instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer serverPlayer = (ServerPlayer)patt0$temp;
            callback.onContainerOpen(serverPlayer, event.getContainer());
        });
        INSTANCE.register(ContainerEvents.Close.class, PlayerContainerEvent.Close.class, (T callback, E event) -> {
            Player patt0$temp = event.getEntity();
            if (!(patt0$temp instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer serverPlayer = (ServerPlayer)patt0$temp;
            callback.onContainerClose(serverPlayer, event.getContainer());
        });
        INSTANCE.register(LookingAtEndermanCallback.class, EnderManAngerEvent.class, (T callback, E event) -> {
            if (callback.onLookingAtEnderManCallback(event.getEntity(), event.getPlayer()).isInterrupt()) {
                event.setCanceled(true);
            }
        });
        INSTANCE.register(RegisterPotionBrewingMixesCallback.class, RegisterBrewingRecipesEvent.class, (T callback, E event) -> callback.onRegisterPotionBrewingMixes(new NeoForgePotionBrewingBuilder(event.getBuilder())));
        INSTANCE.register(AddDataPackReloadListenersCallback.class, AddServerReloadListenersEvent.class, (T callback, E event) -> callback.onAddDataPackReloadListeners(event.getServerResources(), event.getServerResources().getRegistryLookup(), (arg_0, arg_1) -> ((AddServerReloadListenersEvent)event).addListener(arg_0, arg_1)));
        INSTANCE.register(RefreshEntityDimensionsCallback.class, EntityEvent.Size.class, (T callback, E event) -> {
            EventResultHolder<EntityDimensions> eventResult = callback.onRefreshEntityDimensions(event.getEntity(), event.getPose(), event.getOldSize());
            eventResult.ifInterrupt(arg_0 -> ((EntityEvent.Size)event).setNewSize(arg_0));
        });
        INSTANCE.register(PickProjectileCallback.class, LivingGetProjectileEvent.class, (T callback, E event) -> {
            MutableValue<ItemStack> ammoItemStack = MutableValue.fromEvent(arg_0 -> ((LivingGetProjectileEvent)event).setProjectileItemStack(arg_0), () -> ((LivingGetProjectileEvent)event).getProjectileItemStack());
            callback.onPickProjectile(event.getEntity(), event.getProjectileWeaponItemStack(), ammoItemStack);
        });
        INSTANCE.register(EnderPearlTeleportCallback.class, EntityTeleportEvent.EnderPearl.class, (T callback, E event) -> {
            EventResult eventResult = callback.onEnderPearlTeleport(event.getPlayer(), event.getTarget(), event.getPearlEntity(), MutableFloat.fromEvent(arg_0 -> ((EntityTeleportEvent.EnderPearl)event).setAttackDamage(arg_0), () -> ((EntityTeleportEvent.EnderPearl)event).getAttackDamage()), event.getHitResult());
            if (eventResult.isInterrupt()) {
                event.setCanceled(true);
            }
        });
    }

    @Override
    public <T, E extends Event> void register(Class<T> clazz, Class<E> eventClazz, NeoForgeEventInvokerRegistry.NeoForgeEventContextConsumer<T, E> converter, UnaryOperator<EventPhase> eventPhaseConverter, boolean joinInvokers) {
        IEventBus eventBus;
        Objects.requireNonNull(clazz, "type is null");
        Objects.requireNonNull(eventClazz, "event type is null");
        Objects.requireNonNull(converter, "converter is null");
        Preconditions.checkArgument((!Modifier.isAbstract(eventClazz.getModifiers()) ? 1 : 0) != 0, (Object)(String.valueOf(eventClazz) + " is abstract"));
        if (IModBusEvent.class.isAssignableFrom(eventClazz)) {
            Preconditions.checkState((!frozenModBusEvents ? 1 : 0) != 0, (Object)"Mod bus events already frozen");
            eventBus = NeoForgeModContainerHelper.getOptionalActiveModEventBus().orElse(null);
        } else {
            eventBus = NeoForge.EVENT_BUS;
        }
        EventInvokerImpl.register(clazz, new NeoForgeEventInvoker<T, E>(eventBus, eventClazz, converter, eventPhaseConverter), joinInvokers);
    }

    public static EventPriority getEventPriorityFromPhase(EventPhase eventPhase) {
        return NeoForgeEventInvoker.getEventPriority(eventPhase);
    }

    private static /* synthetic */ ItemStack lambda$registerEventHandlers$42(GrindstoneEvent.OnPlaceItem event, Supplier outputItemStackSupplier) {
        return !event.getOutput().isEmpty() ? event.getOutput() : (ItemStack)outputItemStackSupplier.get();
    }

    private record NeoForgeEventInvoker<T, E extends Event>(@Nullable IEventBus eventBus, Class<E> event, NeoForgeEventInvokerRegistry.NeoForgeEventContextConsumer<T, E> converter, UnaryOperator<EventPhase> eventPhaseConverter) implements EventInvoker<T>,
    EventInvokerImpl.EventInvokerLike<T>
    {
        private static final Map<EventPhase, EventPriority> PHASE_TO_PRIORITY = Map.of(EventPhase.FIRST, EventPriority.HIGHEST, EventPhase.BEFORE, EventPriority.HIGH, EventPhase.DEFAULT, EventPriority.NORMAL, EventPhase.AFTER, EventPriority.LOW, EventPhase.LAST, EventPriority.LOWEST);
        private static final IntFunction<EventPriority> PRIORITY_IDS = ByIdMap.continuous(Enum::ordinal, (Object[])EventPriority.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.CLAMP);

        @Override
        public EventInvoker<T> asEventInvoker(@Nullable Object context) {
            return context != null ? (phase, callback) -> this.register(phase, callback, context) : this;
        }

        @Override
        public void register(EventPhase eventPhase, T callback) {
            this.register(eventPhase, callback, null);
        }

        private void register(EventPhase eventPhase, T callback, @Nullable Object context) {
            Objects.requireNonNull(eventPhase, "phase is null");
            Objects.requireNonNull(callback, "callback is null");
            eventPhase = (EventPhase)this.eventPhaseConverter.apply(eventPhase);
            IEventBus eventBus = this.getEventBus(context);
            EventPriority eventPriority = NeoForgeEventInvoker.getEventPriority(eventPhase);
            Object eventContext = this.eventBus != eventBus ? null : context;
            eventBus.addListener(eventPriority, false, this.event, event -> this.converter.accept(callback, (Event)event, eventContext));
        }

        private IEventBus getEventBus(@Nullable Object context) {
            if (this.eventBus == null) {
                Objects.requireNonNull(context, "mod id context is null");
                return NeoForgeModContainerHelper.getModEventBus((String)context);
            }
            return this.eventBus;
        }

        private static EventPriority getEventPriority(EventPhase eventPhase) {
            if (PHASE_TO_PRIORITY.containsKey(eventPhase)) {
                return PHASE_TO_PRIORITY.get(eventPhase);
            }
            Objects.requireNonNull(eventPhase.parent(), "parent is null");
            EventPriority eventPriority = PHASE_TO_PRIORITY.getOrDefault(eventPhase.parent(), EventPriority.NORMAL);
            return PRIORITY_IDS.apply(eventPriority.ordinal() + eventPhase.getOrderingValue());
        }
    }
}

