/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.content.client;

import com.mojang.blaze3d.platform.InputConstants;
import fuzs.puzzleslib.api.client.core.v1.ClientModConstructor;
import fuzs.puzzleslib.api.client.core.v1.context.GuiLayersContext;
import fuzs.puzzleslib.api.client.event.v1.gui.AddToastCallback;
import fuzs.puzzleslib.api.client.event.v1.gui.ScreenEvents;
import fuzs.puzzleslib.api.client.event.v1.gui.ScreenMouseEvents;
import fuzs.puzzleslib.api.client.event.v1.gui.ScreenOpeningCallback;
import fuzs.puzzleslib.api.client.gui.v2.ScreenHelper;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.puzzleslib.api.event.v1.core.EventResultHolder;
import fuzs.puzzleslib.impl.content.ServerPropertiesHelper;
import fuzs.puzzleslib.impl.content.client.ScreenSkipper;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.screens.LoadingOverlay;
import net.minecraft.client.gui.screens.Overlay;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.worldselection.CreateWorldScreen;
import net.minecraft.client.gui.screens.worldselection.WorldCreationUiState;
import net.minecraft.client.tutorial.TutorialSteps;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.scores.DisplaySlot;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.Scoreboard;

public class PuzzlesLibClientDevelopment
implements ClientModConstructor {
    @Override
    public void onConstructMod() {
        PuzzlesLibClientDevelopment.registerEventHandlers();
    }

    private static void registerEventHandlers() {
        ScreenOpeningCallback.EVENT.register((oldScreen, newScreen) -> {
            if (newScreen instanceof TitleScreen) {
                TitleScreen screen = (TitleScreen)newScreen;
                screen.fading = false;
            } else if (newScreen instanceof CreateWorldScreen) {
                CreateWorldScreen screen = (CreateWorldScreen)newScreen;
                screen.getUiState().setGameMode(WorldCreationUiState.SelectedGameMode.CREATIVE);
                screen.getUiState().setAllowCommands(true);
            }
            return EventResultHolder.pass();
        });
        ScreenEvents.beforeInit(TitleScreen.class).register((minecraft, screen, screenWidth, screenHeight, widgets) -> {
            Overlay patt0$temp = minecraft.getOverlay();
            if (patt0$temp instanceof LoadingOverlay) {
                LoadingOverlay loadingOverlay = (LoadingOverlay)patt0$temp;
                if (loadingOverlay.fadeOutStart != 0L) {
                    loadingOverlay.fadeOutStart = 0L;
                }
            }
        });
        AddToastCallback.EVENT.register((toastManager, toast) -> {
            SystemToast systemToast;
            if (toast instanceof SystemToast && (systemToast = (SystemToast)toast).getToken() == SystemToast.SystemToastId.UNSECURE_SERVER_WARNING) {
                return EventResult.INTERRUPT;
            }
            return EventResult.PASS;
        });
        ScreenMouseEvents.beforeMouseClick(Screen.class).register((screen, mouseButtonEvent) -> {
            for (GuiEventListener guiEventListener : screen.children()) {
                if (!(guiEventListener instanceof EditBox) || !guiEventListener.mouseClicked(mouseButtonEvent, ScreenHelper.isDoubleClick(mouseButtonEvent))) continue;
                screen.setFocused(guiEventListener);
                if (mouseButtonEvent.button() == 0) {
                    screen.setDragging(true);
                }
                return EventResult.INTERRUPT;
            }
            return EventResult.PASS;
        });
        ScreenMouseEvents.beforeMouseRelease(Screen.class).register((screen, mouseButtonEvent) -> {
            screen.setDragging(false);
            return screen.getChildAt(mouseButtonEvent.x(), mouseButtonEvent.y()).filter(EditBox.class::isInstance).filter(guiEventListener -> guiEventListener.mouseReleased(mouseButtonEvent)).isPresent() ? EventResult.INTERRUPT : EventResult.PASS;
        });
        ScreenMouseEvents.beforeMouseDrag(Screen.class).register((screen, mouseButtonEvent, dragX, dragY) -> screen.getFocused() instanceof EditBox && screen.isDragging() && mouseButtonEvent.button() == 0 && screen.getFocused().mouseDragged(mouseButtonEvent, dragX, dragY) ? EventResult.INTERRUPT : EventResult.PASS);
    }

    @Override
    public void onClientSetup() {
        CreativeModeInventoryScreen.selectedTab = (CreativeModeTab)BuiltInRegistries.CREATIVE_MODE_TAB.getValueOrThrow(CreativeModeTabs.SEARCH);
        PuzzlesLibClientDevelopment.initializeScreenSkipper();
    }

    private static void initializeScreenSkipper() {
        ScreenSkipper.create().setTitleComponent("selectWorld.backupQuestion.experimental").setButtonComponent("selectWorld.backupJoinSkipButton").build();
        ScreenSkipper.create().setTitleComponent("selectWorld.warning.experimental.title").setButtonComponent(CommonComponents.GUI_YES).build();
        ScreenSkipper.create().setTitleComponent("controls.title").setButtonComponent("controls.keybinds").setLastTitleComponent("options.title").build();
    }

    public static void setupGameOptions(Options options) {
        Minecraft minecraft = Minecraft.getInstance();
        Objects.requireNonNull(minecraft, "minecraft is null");
        boolean running = minecraft.running;
        minecraft.running = false;
        PuzzlesLibClientDevelopment.initializeGameOptions(options);
        minecraft.running = running;
    }

    public static void initializeGameOptions(Options options) {
        if (options.getFile().exists()) {
            return;
        }
        options.renderDistance().set((Object)16);
        options.framerateLimit().set((Object)60);
        options.narratorHotkey().set((Object)false);
        options.advancedItemTooltips = true;
        options.tutorialStep = TutorialSteps.NONE;
        options.joinedFirstServer = true;
        options.operatorItemsTab().set((Object)true);
        options.realmsNotifications().set((Object)false);
        options.showSubtitles().set((Object)true);
        options.guiScale().set((Object)8);
        options.onboardAccessibility = false;
        options.skipMultiplayerWarning = true;
        options.damageTiltStrength().set((Object)0.0);
        options.keyLoadHotbarActivator.setKey(InputConstants.UNKNOWN);
        options.keySaveHotbarActivator.setKey(InputConstants.UNKNOWN);
        options.keyCommand.setKey(InputConstants.UNKNOWN);
        options.keySocialInteractions.setKey(InputConstants.UNKNOWN);
        options.keyAdvancements.setKey(InputConstants.UNKNOWN);
        options.keyQuickActions.setKey(InputConstants.UNKNOWN);
        options.keyFullscreen.setKey(InputConstants.UNKNOWN);
        options.getSoundSourceOptionInstance(SoundSource.MUSIC).set((Object)0.0);
        options.lastMpIp = ServerPropertiesHelper.getHostAddress().map(string -> string + ":25565").orElse("");
    }

    @Override
    public void onRegisterGuiLayers(GuiLayersContext context) {
        context.replaceGuiLayer(GuiLayersContext.PLAYER_LIST, layer -> (guiGraphics, deltaTracker) -> {
            Minecraft minecraft = Minecraft.getInstance();
            Scoreboard scoreboard = minecraft.level.getScoreboard();
            Objective objective = scoreboard.getDisplayObjective(DisplaySlot.LIST);
            if (minecraft.options.keyPlayerList.isDown() && minecraft.isLocalServer() && minecraft.player.connection.getListedOnlinePlayers().size() <= 1 && objective == null) {
                minecraft.gui.tabList.setVisible(true);
                minecraft.gui.tabList.render(guiGraphics, guiGraphics.guiWidth(), scoreboard, null);
            } else {
                layer.render(guiGraphics, deltaTracker);
            }
        });
    }
}

