/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.resources.v1;

import fuzs.puzzleslib.api.core.v1.ModLoaderEnvironment;
import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import fuzs.puzzleslib.api.resources.v1.PackResourcesHelper;
import fuzs.puzzleslib.impl.resources.ModPackResourcesSupplier;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.BuiltInMetadata;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackSelectionConfig;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackCompatibility;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraft.world.flag.FeatureFlagSet;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class AbstractModPackResources
implements PackResources {
    protected final String modLogoPath;
    @Nullable
    private PackType packType;
    @Nullable
    private PackLocationInfo info;
    @Nullable
    private BuiltInMetadata metadata;

    public AbstractModPackResources() {
        this("mod_logo.png");
    }

    public AbstractModPackResources(String modLogoPath) {
        Objects.requireNonNull(modLogoPath, "mod logo path is null");
        this.modLogoPath = modLogoPath;
    }

    @Nullable
    public IoSupplier<InputStream> getRootResource(String ... elements) {
        String path = String.join((CharSequence)"/", elements);
        if ("pack.png".equals(path)) {
            return ModLoaderEnvironment.INSTANCE.getModContainer(this.getNamespace()).flatMap(container -> container.findResource(this.modLogoPath)).map(modResource -> () -> Files.newInputStream(modResource, new OpenOption[0])).orElse(null);
        }
        return null;
    }

    @Nullable
    public IoSupplier<InputStream> getResource(PackType packType, ResourceLocation location) {
        return null;
    }

    public void listResources(PackType packType, String namespace, String path, PackResources.ResourceOutput resourceOutput) {
    }

    public Set<String> getNamespaces(PackType type) {
        Objects.requireNonNull(this.packType, "pack type is null");
        return this.packType == type ? Collections.singleton(this.getNamespace()) : Collections.emptySet();
    }

    @Nullable
    public <T> T getMetadataSection(MetadataSectionType<T> type) throws IOException {
        Objects.requireNonNull(this.metadata, "metadata is null");
        return (T)this.metadata.get(type);
    }

    public PackLocationInfo location() {
        Objects.requireNonNull(this.info, "info is null");
        return this.info;
    }

    public void close() {
    }

    public String getNamespace() {
        return ResourceLocationHelper.parse(this.packId()).getNamespace();
    }

    @ApiStatus.OverrideOnly
    protected void setup() {
    }

    public static Pack buildPack(PackType packType, ResourceLocation resourceLocation, Supplier<AbstractModPackResources> factory, Component titleComponent, Component descriptionComponent, boolean required, Pack.Position position, boolean fixedPosition, boolean hidden, FeatureFlagSet featureFlagSet) {
        PackLocationInfo info = new PackLocationInfo(resourceLocation.toString(), titleComponent, PackSource.BUILT_IN, Optional.empty());
        ModPackResourcesSupplier resourcesSupplier = ModPackResourcesSupplier.create(packType, info, AbstractModPackResources.createSupplier(factory), descriptionComponent);
        Pack.Metadata metadata = PackResourcesHelper.createPackInfo(resourceLocation, descriptionComponent, PackCompatibility.COMPATIBLE, featureFlagSet, hidden);
        PackSelectionConfig config = new PackSelectionConfig(required, position, fixedPosition);
        return new Pack(info, (Pack.ResourcesSupplier)resourcesSupplier, metadata, config);
    }

    private static ModPackResourcesSupplier.PackResourcesSupplier<AbstractModPackResources> createSupplier(Supplier<AbstractModPackResources> factory) {
        return (packType, info, metadata) -> {
            AbstractModPackResources packResources = (AbstractModPackResources)factory.get();
            packResources.info = info;
            packResources.metadata = metadata;
            packResources.packType = packType;
            packResources.setup();
            return packResources;
        };
    }
}

