/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.network.v4;

import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.core.Vec3i;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;
import org.jetbrains.annotations.Nullable;

@FunctionalInterface
public interface PlayerSet {
    public void apply(Consumer<ServerPlayer> var1);

    public static PlayerSet ofNone() {
        return serverPlayerConsumer -> {};
    }

    public static PlayerSet ofEntity(Entity entity) {
        PlayerSet playerSet;
        Objects.requireNonNull(entity, "entity is null");
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            playerSet = PlayerSet.ofPlayer(serverPlayer);
        } else {
            playerSet = PlayerSet.ofNone();
        }
        return playerSet;
    }

    public static PlayerSet ofPlayer(ServerPlayer serverPlayer) {
        Objects.requireNonNull(serverPlayer, "server player is null");
        return serverPlayerConsumer -> serverPlayerConsumer.accept(serverPlayer);
    }

    public static PlayerSet ofOthers(ServerPlayer serverPlayer) {
        Objects.requireNonNull(serverPlayer, "server player is null");
        return serverPlayerConsumer -> serverPlayer.level().getServer().getPlayerList().getPlayers().forEach(currentServerPlayer -> {
            if (currentServerPlayer != serverPlayer) {
                PlayerSet.ofPlayer(currentServerPlayer).apply(serverPlayerConsumer);
            }
        });
    }

    public static PlayerSet ofAll(MinecraftServer minecraftServer) {
        return serverPlayerConsumer -> minecraftServer.getPlayerList().getPlayers().forEach(serverPlayer -> PlayerSet.ofPlayer(serverPlayer).apply(serverPlayerConsumer));
    }

    public static PlayerSet inLevel(ServerLevel serverLevel) {
        Objects.requireNonNull(serverLevel, "server level is null");
        return serverPlayerConsumer -> {
            for (ServerPlayer serverPlayer : serverLevel.players()) {
                PlayerSet.ofPlayer(serverPlayer).apply(serverPlayerConsumer);
            }
        };
    }

    public static PlayerSet nearPosition(Vec3i position, ServerLevel serverLevel) {
        Objects.requireNonNull(position, "position is null");
        return PlayerSet.nearPosition(position.getX(), position.getY(), position.getZ(), serverLevel);
    }

    public static PlayerSet nearPosition(double posX, double posY, double posZ, ServerLevel serverLevel) {
        return PlayerSet.nearPosition(null, posX, posY, posZ, 64.0, serverLevel);
    }

    public static PlayerSet nearPosition(@Nullable ServerPlayer excludePlayer, double posX, double posY, double posZ, double distance, ServerLevel serverLevel) {
        Objects.requireNonNull(serverLevel, "server level is null");
        return serverPlayerConsumer -> {
            for (ServerPlayer serverPlayer : serverLevel.getServer().getPlayerList().getPlayers()) {
                double deltaZ;
                double deltaY;
                double deltaX;
                if (serverPlayer == excludePlayer || serverPlayer.level().dimension() != serverLevel.dimension() || !((deltaX = posX - serverPlayer.getX()) * deltaX + (deltaY = posY - serverPlayer.getY()) * deltaY + (deltaZ = posZ - serverPlayer.getZ()) * deltaZ < distance * distance)) continue;
                PlayerSet.ofPlayer(serverPlayer).apply(serverPlayerConsumer);
            }
        };
    }

    public static PlayerSet nearBlockEntity(BlockEntity blockEntity) {
        Objects.requireNonNull(blockEntity, "block entity is null");
        Level level = blockEntity.getLevel();
        Objects.requireNonNull(level, "block entity level is null");
        return level.isClientSide() ? PlayerSet.ofNone() : PlayerSet.nearPosition((Vec3i)blockEntity.getBlockPos(), (ServerLevel)level);
    }

    public static PlayerSet nearChunk(LevelChunk levelChunk) {
        Objects.requireNonNull(levelChunk, "chunk is null");
        return levelChunk.getLevel().isClientSide() ? PlayerSet.ofNone() : PlayerSet.nearChunk((ServerLevel)levelChunk.getLevel(), levelChunk.getPos());
    }

    public static PlayerSet nearChunk(ServerLevel serverLevel, ChunkPos chunkPos) {
        Objects.requireNonNull(serverLevel, "server level is null");
        Objects.requireNonNull(chunkPos, "chunk pos is null");
        return serverPlayerConsumer -> serverLevel.getChunkSource().chunkMap.getPlayers(chunkPos, false).forEach(serverPlayer -> PlayerSet.ofPlayer(serverPlayer).apply(serverPlayerConsumer));
    }

    public static PlayerSet nearEntity(Entity entity) {
        Objects.requireNonNull(entity, "entity is null");
        return entity.level().isClientSide() ? PlayerSet.ofNone() : serverPlayerConsumer -> {
            ChunkMap chunkMap = ((ServerLevel)entity.level()).getChunkSource().chunkMap;
            ChunkMap.TrackedEntity trackedEntity = (ChunkMap.TrackedEntity)chunkMap.entityMap.get(entity.getId());
            if (trackedEntity != null) {
                for (ServerPlayerConnection serverPlayerConnection : trackedEntity.seenBy) {
                    PlayerSet.ofPlayer(serverPlayerConnection.getPlayer()).apply(serverPlayerConsumer);
                }
                if (entity instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)entity;
                    PlayerSet.ofPlayer(serverPlayer).apply(serverPlayerConsumer);
                }
            }
        };
    }

    public static PlayerSet nearPlayer(ServerPlayer serverPlayer) {
        Objects.requireNonNull(serverPlayer, "server player is null");
        return serverPlayerConsumer -> {
            ChunkMap chunkMap = serverPlayer.level().getChunkSource().chunkMap;
            ChunkMap.TrackedEntity trackedEntity = (ChunkMap.TrackedEntity)chunkMap.entityMap.get(serverPlayer.getId());
            if (trackedEntity != null) {
                for (ServerPlayerConnection serverPlayerConnection : trackedEntity.seenBy) {
                    PlayerSet.ofPlayer(serverPlayerConnection.getPlayer()).apply(serverPlayerConsumer);
                }
            }
        };
    }
}

