/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.item.v2;

import fuzs.puzzleslib.api.core.v1.ModLoaderEnvironment;
import fuzs.puzzleslib.impl.core.proxy.ProxyImpl;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public final class ItemHelper {
    private ItemHelper() {
    }

    public static void hurtAndBreak(ItemStack itemStack, int amount, LivingEntity livingEntity, InteractionHand interactionHand) {
        ItemHelper.hurtAndBreak(itemStack, amount, livingEntity, interactionHand.asEquipmentSlot());
    }

    public static void hurtAndBreak(ItemStack itemStack, int amount, LivingEntity livingEntity, EquipmentSlot equipmentSlot) {
        Level level = livingEntity.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ServerPlayer serverPlayer = livingEntity instanceof ServerPlayer ? (ServerPlayer)livingEntity : null;
            ItemHelper.hurtAndBreak(itemStack, amount, serverLevel, serverPlayer, item -> livingEntity.onEquippedItemBroken(item, equipmentSlot));
        }
    }

    public static void hurtAndBreak(ItemStack itemStack, int amount, ServerLevel serverLevel, @Nullable ServerPlayer serverPlayer, Consumer<Item> onBreak) {
        ItemStack originalItemStack = ItemHelper.copyItemStackIfNecessary(itemStack, serverPlayer);
        itemStack.hurtAndBreak(amount, serverLevel, serverPlayer, (T item) -> {
            onBreak.accept((Item)item);
            if (serverPlayer != null) {
                ItemHelper.onPlayerDestroyItem((Player)serverPlayer, originalItemStack, null);
            }
        });
    }

    private static ItemStack copyItemStackIfNecessary(ItemStack itemStack, @Nullable ServerPlayer serverPlayer) {
        if (serverPlayer != null && ModLoaderEnvironment.INSTANCE.getModLoader().isForgeLike()) {
            return itemStack.copy();
        }
        return itemStack;
    }

    public static void onPlayerDestroyItem(Player player, ItemStack originalItemStack, @Nullable InteractionHand interactionHand) {
        Objects.requireNonNull(player, "player is null");
        Objects.requireNonNull(originalItemStack, "original item stack is null");
        ProxyImpl.get().onPlayerDestroyItem(player, originalItemStack, interactionHand);
    }

    public static Style getRarityStyle(Rarity rarity) {
        Objects.requireNonNull(rarity, "rarity is null");
        return ProxyImpl.get().getRarityStyle(rarity);
    }
}

