/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.init.v3.registry;

import fuzs.puzzleslib.api.core.v1.ModLoaderEnvironment;
import fuzs.puzzleslib.api.event.v1.CommonSetupCallback;
import fuzs.puzzleslib.api.init.v3.registry.RegistryManager;
import fuzs.puzzleslib.impl.item.CustomTransmuteRecipe;
import java.util.function.Consumer;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.context.ContextKeySet;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;

public final class ContentRegistrationHelper {
    private ContentRegistrationHelper() {
    }

    public static void registerTransmuteRecipeSerializers(RegistryManager registryManager) {
        CustomTransmuteRecipe.registerSerializers((string, recipeSerializerSupplier) -> registryManager.register(Registries.RECIPE_SERIALIZER, (String)string, recipeSerializerSupplier));
    }

    public static SkullBlock.Type registerSkullBlockType(ResourceLocation resourceLocation) {
        String string = resourceLocation.toString();
        SkullBlock.Type skullBlockType = () -> string;
        CommonSetupCallback.EVENT.register(() -> SkullBlock.Type.TYPES.put(skullBlockType.getSerializedName(), skullBlockType));
        return skullBlockType;
    }

    public static ContextKeySet registerContextKeySet(ResourceLocation resourceLocation, Consumer<ContextKeySet.Builder> builderConsumer) {
        ContextKeySet.Builder builder = new ContextKeySet.Builder();
        builderConsumer.accept(builder);
        ContextKeySet contextKeySet = builder.build();
        if (ModLoaderEnvironment.INSTANCE.isDataGeneration()) {
            ContentRegistrationHelper.registerContextKeySet(resourceLocation, contextKeySet);
        } else {
            CommonSetupCallback.EVENT.register(() -> ContentRegistrationHelper.registerContextKeySet(resourceLocation, contextKeySet));
        }
        return contextKeySet;
    }

    private static void registerContextKeySet(ResourceLocation resourceLocation, ContextKeySet contextKeySet) {
        if (LootContextParamSets.REGISTRY.put((Object)resourceLocation, (Object)contextKeySet) != null) {
            throw new IllegalStateException("Loot context key set " + String.valueOf(resourceLocation) + " is already registered");
        }
    }
}

