/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.client.key.v1;

import com.google.common.collect.MapMaker;
import com.mojang.blaze3d.platform.InputConstants;
import fuzs.puzzleslib.api.client.key.v1.KeyActivationContext;
import fuzs.puzzleslib.impl.client.core.proxy.ClientProxyImpl;
import java.util.Map;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.ApiStatus;

public interface KeyMappingHelper {
    public static final KeyMappingHelper INSTANCE = ClientProxyImpl.get().getKeyMappingActivationHelper();
    @ApiStatus.Internal
    public static final Map<ResourceLocation, KeyMapping.Category> KEY_CATEGORIES = new MapMaker().weakValues().makeMap();

    public KeyActivationContext getKeyActivationContext(KeyMapping var1);

    default public boolean isConflictingWith(KeyMapping keyMapping, KeyMapping otherKeyMapping) {
        return this.getKeyActivationContext(keyMapping).hasConflict(this.getKeyActivationContext(otherKeyMapping));
    }

    public static KeyMapping registerUnboundKeyMapping(ResourceLocation resourceLocation) {
        return KeyMappingHelper.registerKeyMapping(resourceLocation, InputConstants.UNKNOWN.getValue());
    }

    public static KeyMapping registerKeyMapping(ResourceLocation resourceLocation, int keyCode) {
        return new KeyMapping("key." + resourceLocation.toLanguageKey(), keyCode, KEY_CATEGORIES.computeIfAbsent(resourceLocation.withPath("main"), KeyMapping.Category::new));
    }

    public static boolean isKeyActiveAndMatches(KeyMapping keyMapping, KeyEvent keyEvent) {
        return ClientProxyImpl.get().isKeyActiveAndMatches(keyMapping, keyEvent);
    }
}

