/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.client.gui.v2.tooltip;

import fuzs.puzzleslib.api.client.event.v1.gui.ItemTooltipCallback;
import fuzs.puzzleslib.api.client.gui.v2.tooltip.ClientComponentSplitter;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public abstract class ItemTooltipRegistry<T> {
    public static final ItemTooltipRegistry<Block> BLOCK = new ItemTooltipRegistry<Block>(){

        @Override
        @Nullable
        Block getFromItemStack(ItemStack itemStack) {
            Block block;
            Item item = itemStack.getItem();
            if (item instanceof BlockItem) {
                BlockItem blockItem = (BlockItem)item;
                block = blockItem.getBlock();
            } else {
                block = null;
            }
            return block;
        }

        @Override
        Registry<Block> getRegistry() {
            return BuiltInRegistries.BLOCK;
        }
    };
    public static final ItemTooltipRegistry<Item> ITEM = new ItemTooltipRegistry<Item>(){

        @Override
        Item getFromItemStack(ItemStack itemStack) {
            return itemStack.getItem();
        }

        @Override
        Registry<Item> getRegistry() {
            return BuiltInRegistries.ITEM;
        }
    };

    ItemTooltipRegistry() {
    }

    @Nullable
    abstract T getFromItemStack(ItemStack var1);

    abstract Registry<T> getRegistry();

    public <V extends T> void registerItemTooltip(V value, Component component) {
        this.registerItemTooltip(value, new Component[]{component});
    }

    public <V extends T> void registerItemTooltip(Class<V> clazz, Component component) {
        this.registerItemTooltip(clazz, new Component[]{component});
    }

    public void registerItemTooltip(TagKey<T> tagKey, Component component) {
        this.registerItemTooltip(tagKey, new Component[]{component});
    }

    public <V extends T> void registerItemTooltip(V value, Component ... components) {
        this.registerItemTooltipLines(value, (V valueX) -> Arrays.asList(components));
    }

    public <V extends T> void registerItemTooltip(Class<V> clazz, Component ... components) {
        this.registerItemTooltipLines(clazz, (V valueX) -> Arrays.asList(components));
    }

    public void registerItemTooltip(TagKey<T> tagKey, Component ... components) {
        this.registerItemTooltipLines(tagKey, (T valueX) -> Arrays.asList(components));
    }

    public <V extends T> void registerItemTooltip(V value, Function<V, @Nullable Component> componentExtractor) {
        this.registerItemTooltipLines(value, (V valueX) -> Collections.singletonList((Component)componentExtractor.apply(valueX)));
    }

    public <V extends T> void registerItemTooltip(Class<V> clazz, Function<V, @Nullable Component> componentExtractor) {
        this.registerItemTooltipLines(clazz, (V valueX) -> Collections.singletonList((Component)componentExtractor.apply(valueX)));
    }

    public void registerItemTooltip(TagKey<T> tagKey, Function<T, @Nullable Component> componentExtractor) {
        this.registerItemTooltipLines(tagKey, (T valueX) -> Collections.singletonList((Component)componentExtractor.apply(valueX)));
    }

    public <V extends T> void registerItemTooltipLines(V value, Function<V, List<Component>> componentExtractor) {
        this.registerItemTooltip((ItemStack itemStack) -> this.getFromItemStack((ItemStack)itemStack) == value, (ItemStack itemStack, Item.TooltipContext context, TooltipFlag tooltipFlag, Player player, Consumer<Component> tooltipLineConsumer) -> ((List)componentExtractor.apply(value)).forEach(tooltipLineConsumer));
    }

    public <V extends T> void registerItemTooltipLines(Class<V> clazz, Function<V, List<Component>> componentExtractor) {
        this.registerItemTooltip(clazz, (ItemStack itemStack, Item.TooltipContext context, TooltipFlag tooltipFlag, Player player, Consumer<Component> tooltipLineConsumer) -> {
            T value = this.getFromItemStack(itemStack);
            Objects.requireNonNull(value, "value from item stack " + String.valueOf(itemStack) + " is null");
            ((List)componentExtractor.apply(value)).forEach(tooltipLineConsumer);
        });
    }

    public void registerItemTooltipLines(TagKey<T> tagKey, Function<T, List<Component>> componentExtractor) {
        this.registerItemTooltip(tagKey, (ItemStack itemStack, Item.TooltipContext context, TooltipFlag tooltipFlag, Player player, Consumer<Component> tooltipLineConsumer) -> {
            T value = this.getFromItemStack(itemStack);
            Objects.requireNonNull(value, "value from item stack " + String.valueOf(itemStack) + " is null");
            ((List)componentExtractor.apply(value)).forEach(tooltipLineConsumer);
        });
    }

    public <V extends T> void registerItemTooltip(Class<V> clazz, Provider provider) {
        for (Object value : this.getRegistry()) {
            if (!clazz.isInstance(value)) continue;
            this.registerItemTooltip((ItemStack itemStack) -> this.getFromItemStack((ItemStack)itemStack) == value, provider);
        }
    }

    public void registerItemTooltip(TagKey<T> tagKey, Provider provider) {
        this.registerItemTooltip((ItemStack itemStack) -> {
            T value = this.getFromItemStack((ItemStack)itemStack);
            return value != null && this.getRegistry().wrapAsHolder(value).is(tagKey);
        }, provider);
    }

    public void registerItemTooltip(Predicate<ItemStack> itemStackFilter, Provider provider) {
        ItemTooltipCallback.EVENT.register((itemStack, tooltipLines, tooltipContext, player, tooltipFlag) -> {
            if (tooltipContext != Item.TooltipContext.EMPTY && tooltipContext.registries() != null && itemStackFilter.test(itemStack)) {
                int originalSize = tooltipLines.size();
                provider.appendHoverText(itemStack, tooltipContext, tooltipFlag, player, component -> {
                    if (component != null) {
                        tooltipLines.addAll(tooltipLines.isEmpty() ? 0 : 1 + tooltipLines.size() - originalSize, ClientComponentSplitter.splitTooltipComponents(new FormattedText[]{component}));
                    }
                });
            }
        });
    }

    @FunctionalInterface
    public static interface Provider {
        public void appendHoverText(ItemStack var1, Item.TooltipContext var2, TooltipFlag var3, @Nullable Player var4, Consumer<Component> var5);
    }
}

