/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.client.event.v1.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import fuzs.puzzleslib.api.event.v1.core.EventInvoker;
import fuzs.puzzleslib.api.event.v1.core.EventResultHolder;
import java.util.Objects;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.state.BlockOutlineRenderState;
import net.minecraft.client.renderer.state.LevelRenderState;
import net.minecraft.util.ARGB;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.jetbrains.annotations.Nullable;

@FunctionalInterface
public interface SubmitBlockOutlineCallback {
    public static final EventInvoker<SubmitBlockOutlineCallback> EVENT = EventInvoker.lookup(SubmitBlockOutlineCallback.class);

    public EventResultHolder<@Nullable CustomBlockOutlineRenderer> onSubmitBlockOutline(LevelRenderer var1, ClientLevel var2, BlockState var3, BlockHitResult var4, CollisionContext var5, Camera var6);

    @FunctionalInterface
    public static interface CustomBlockOutlineRenderer {
        public boolean render(BlockOutlineRenderState var1, MultiBufferSource.BufferSource var2, PoseStack var3, boolean var4, LevelRenderState var5);

        public static void renderVanillaBlockOutline(BlockOutlineRenderState renderState, MultiBufferSource.BufferSource bufferSource, PoseStack poseStack, boolean isTranslucent, LevelRenderState levelRenderState) {
            Objects.requireNonNull(renderState, "block outline render state is null");
            if (renderState.isTranslucent() == isTranslucent) {
                VertexConsumer vertexConsumer;
                LevelRenderer levelRenderer = Minecraft.getInstance().levelRenderer;
                Vec3 cameraPosition = levelRenderState.cameraRenderState.pos;
                if (renderState.highContrast()) {
                    vertexConsumer = bufferSource.getBuffer(RenderType.secondaryBlockOutline());
                    levelRenderer.renderHitOutline(poseStack, vertexConsumer, cameraPosition.x, cameraPosition.y, cameraPosition.z, renderState, -16777216);
                }
                vertexConsumer = bufferSource.getBuffer(RenderType.lines());
                int color = renderState.highContrast() ? -11010079 : ARGB.color((int)102, (int)-16777216);
                levelRenderer.renderHitOutline(poseStack, vertexConsumer, cameraPosition.x, cameraPosition.y, cameraPosition.z, renderState, color);
                bufferSource.endLastBatch();
            }
        }
    }
}

