/*
 * Decompiled with CFR 0.152.
 */
package com.texelsaurus.minecraft.chameleon.render;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import com.texelsaurus.minecraft.chameleon.render.ChameleonBlockModelPart;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import org.jetbrains.annotations.Nullable;

public abstract class ReplacementBlockPart
implements ChameleonBlockModelPart {
    protected BlockModelPart parent;
    private TextureAtlasSprite sprite;
    private List<BakedQuad> quads = new ArrayList<BakedQuad>();

    public ReplacementBlockPart(BlockModelPart part, TextureAtlasSprite sprite) {
        this.parent = part;
        this.sprite = sprite;
        part.getQuads(null).forEach(quad -> this.quads.add(this.remapQuad((BakedQuad)quad, sprite)));
        for (Direction dir : Direction.values()) {
            part.getQuads(dir).forEach(quad -> this.quads.add(this.remapQuad((BakedQuad)quad, sprite)));
        }
    }

    public ReplacementBlockPart(BlockModelPart parent, BlockModelPart replacement) {
        this(parent, replacement.particleIcon());
    }

    public List<BakedQuad> getQuads(@Nullable Direction direction) {
        return this.quads;
    }

    public boolean useAmbientOcclusion() {
        return this.parent.useAmbientOcclusion();
    }

    public TextureAtlasSprite particleIcon() {
        if (this.sprite == null) {
            return this.parent.particleIcon();
        }
        return this.sprite;
    }

    BakedQuad remapQuad(BakedQuad quad, TextureAtlasSprite sprite) {
        int[] vertices = (int[])quad.vertices().clone();
        for (int i = 0; i < 4; ++i) {
            int blk = DefaultVertexFormat.BLOCK.getVertexSize() / 4 * i;
            int offset = DefaultVertexFormat.BLOCK.getOffset(VertexFormatElement.UV) / 4;
            vertices[blk + offset] = Float.floatToRawIntBits(sprite.getU(this.getUnInterpolatedU(quad.sprite(), Float.intBitsToFloat(vertices[blk + offset]))));
            vertices[blk + offset + 1] = Float.floatToRawIntBits(sprite.getV(this.getUnInterpolatedV(quad.sprite(), Float.intBitsToFloat(vertices[blk + offset + 1]))));
        }
        return new BakedQuad(vertices, quad.tintIndex(), quad.direction(), sprite, quad.shade(), quad.lightEmission());
    }

    private float getUnInterpolatedU(TextureAtlasSprite sprite, float u) {
        float diff = sprite.getU1() - sprite.getU0();
        return (u - sprite.getU0()) / diff;
    }

    private float getUnInterpolatedV(TextureAtlasSprite sprite, float v) {
        float diff = sprite.getV1() - sprite.getV0();
        return (v - sprite.getV0()) / diff;
    }
}

