/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.network;

import com.google.common.collect.Maps;
import com.jaquadro.minecraft.storagedrawers.config.PlayerConfig;
import com.jaquadro.minecraft.storagedrawers.config.PlayerConfigSetting;
import com.texelsaurus.minecraft.chameleon.network.ChameleonPacket;
import java.util.HashMap;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public record PlayerBoolConfigMessage(String uuid, String key, boolean value) implements ChameleonPacket
{
    public static final CustomPacketPayload.Type<PlayerBoolConfigMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"storagedrawers", (String)"player_bool_config"));
    public static final StreamCodec<FriendlyByteBuf, PlayerBoolConfigMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, PlayerBoolConfigMessage::uuid, (StreamCodec)ByteBufCodecs.STRING_UTF8, PlayerBoolConfigMessage::key, (StreamCodec)ByteBufCodecs.BOOL, PlayerBoolConfigMessage::value, PlayerBoolConfigMessage::new);

    public CustomPacketPayload.Type<? extends PlayerBoolConfigMessage> type() {
        return TYPE;
    }

    @Override
    public void handleMessage(Player player, Consumer<Runnable> workQueue) {
        if (player instanceof ServerPlayer) {
            workQueue.accept(() -> {
                UUID playerUniqueId;
                try {
                    playerUniqueId = UUID.fromString(this.uuid);
                }
                catch (IllegalArgumentException e) {
                    return;
                }
                HashMap clientMap = PlayerConfig.serverPlayerConfigSettings.get(playerUniqueId);
                if (clientMap == null) {
                    clientMap = Maps.newHashMap();
                }
                clientMap.put(this.key, new PlayerConfigSetting<Boolean>(this.key, this.value, playerUniqueId));
                PlayerConfig.serverPlayerConfigSettings.put(playerUniqueId, clientMap);
            });
        }
    }
}

