/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.inventory;

import com.google.common.collect.MapMaker;
import com.jaquadro.minecraft.storagedrawers.api.storage.EmptyDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityController;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityControllerIO;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.capabilities.Capabilities;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.item.ItemStackResourceHandler;
import net.neoforged.neoforge.transfer.transaction.RootCommitJournal;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;

public class DrawerGroupResourceHandler
implements ResourceHandler<ItemResource> {
    private static final Map<IDrawerGroup, DrawerGroupResourceHandler> WRAPPERS = new MapMaker().weakValues().makeMap();
    private final IDrawerGroup group;
    int size;
    int[] slotOrder = new int[0];
    boolean suspended = false;
    final List<DrawerWrapper> drawerWrappers = new ArrayList<DrawerWrapper>();
    private final RootCommitJournal setChangedJournal;

    public static ResourceHandler<ItemResource> of(IDrawerGroup group) {
        return DrawerGroupResourceHandler.internalOf(group);
    }

    static DrawerGroupResourceHandler internalOf(IDrawerGroup group) {
        DrawerGroupResourceHandler storage = WRAPPERS.computeIfAbsent(group, DrawerGroupResourceHandler::new);
        storage.resizeSlotList();
        storage.slotOrder = group.getAccessibleDrawerSlots();
        storage.suspended = storage.isSuspended();
        return storage;
    }

    DrawerGroupResourceHandler(IDrawerGroup group) {
        this.group = group;
        this.setChangedJournal = new RootCommitJournal(this::onRootCommit);
    }

    private void resizeSlotList() {
        this.size = this.group.getAccessibleDrawerSlots().length;
        while (this.drawerWrappers.size() < this.size) {
            this.drawerWrappers.add(new DrawerWrapper(this.drawerWrappers.size()));
        }
    }

    DrawerWrapper getDrawerWrapper(int index) {
        Objects.checkIndex(index, this.size());
        return this.drawerWrappers.get(index);
    }

    void onRootCommit() {
    }

    int translateSlot(int i) {
        if (i >= 0 && i < this.slotOrder.length) {
            i = this.slotOrder[i];
        }
        return i;
    }

    protected boolean isSuspended() {
        IDrawerAttributes attrs = this.group.getCapability(Capabilities.DRAWER_ATTRIBUTES);
        if (attrs == null) {
            attrs = EmptyDrawerAttributes.EMPTY;
        }
        return attrs.isSuspended();
    }

    public int size() {
        if (!this.isGroupValid()) {
            return 0;
        }
        return this.size;
    }

    public ItemResource getResource(int i) {
        return this.getDrawerWrapper(this.translateSlot(i)).getResource(0);
    }

    public long getAmountAsLong(int i) {
        return this.getDrawerWrapper(this.translateSlot(i)).getAmountAsLong(0);
    }

    public long getCapacityAsLong(int i, ItemResource itemResource) {
        return this.getDrawerWrapper(this.translateSlot(i)).getCapacityAsLong(0, itemResource);
    }

    public boolean isValid(int i, ItemResource itemResource) {
        return this.getDrawerWrapper(this.translateSlot(i)).isValid(0, itemResource);
    }

    public int insert(int i, ItemResource itemResource, int amount, TransactionContext transactionContext) {
        return this.getDrawerWrapper(this.translateSlot(i)).insert(0, itemResource, amount, transactionContext);
    }

    public int extract(int i, ItemResource itemResource, int amount, TransactionContext transactionContext) {
        return this.getDrawerWrapper(this.translateSlot(i)).extract(0, itemResource, amount, transactionContext);
    }

    protected boolean isGroupValid() {
        return !this.suspended && this.group.isGroupValid();
    }

    public class DrawerWrapper
    extends ItemStackResourceHandler {
        int slot;

        public DrawerWrapper(int slot) {
            this.slot = slot;
        }

        public ItemResource getResource(int index) {
            if (DrawerGroupResourceHandler.this.isGroupValid()) {
                return ItemResource.EMPTY;
            }
            return super.getResource(index);
        }

        protected ItemStack getStack() {
            if (!DrawerGroupResourceHandler.this.isGroupValid()) {
                return ItemStack.EMPTY;
            }
            IDrawer drawer = DrawerGroupResourceHandler.this.group.getDrawer(this.slot);
            return drawer.getStoredItemPrototype().copyWithCount(drawer.getStoredItemCount());
        }

        void updateSlot(int slot) {
            this.slot = slot;
        }

        protected void setStack(ItemStack itemStack) {
            if (!DrawerGroupResourceHandler.this.isGroupValid()) {
                return;
            }
            if (itemStack.getCount() > 0) {
                DrawerGroupResourceHandler.this.group.getDrawer(this.slot).setStoredItem(itemStack, itemStack.getCount());
            } else {
                DrawerGroupResourceHandler.this.group.getDrawer(this.slot).setStoredItemCount(0);
            }
        }

        protected boolean isValid(ItemResource resource) {
            return DrawerGroupResourceHandler.this.isGroupValid() && DrawerGroupResourceHandler.this.group.getDrawer(this.slot).canItemBeStored(resource.toStack());
        }

        public long getAmountAsLong(int index) {
            if (!DrawerGroupResourceHandler.this.isGroupValid()) {
                return 0L;
            }
            return DrawerGroupResourceHandler.this.group.getDrawer(this.slot).getStoredItemCount();
        }

        protected int getCapacity(ItemResource resource) {
            if (!DrawerGroupResourceHandler.this.isGroupValid()) {
                return 0;
            }
            return DrawerGroupResourceHandler.this.group.getDrawer(this.slot).getMaxCapacity(resource.toStack());
        }

        private IDrawerAttributes getDrawerAttributes(IDrawerGroup group) {
            if (group == null) {
                return null;
            }
            IDrawerAttributes attr = group.getCapability(Capabilities.DRAWER_ATTRIBUTES);
            if (attr == null && group instanceof BlockEntityDrawers) {
                attr = ((BlockEntityDrawers)group).getDrawerAttributes();
            }
            return attr;
        }

        private boolean checkControllerVoid(BlockEntityController controller) {
            if (controller == null) {
                return false;
            }
            IDrawer drawer = DrawerGroupResourceHandler.this.group.getDrawer(this.slot);
            if (drawer == null || !drawer.isEnabled()) {
                return false;
            }
            IDrawerGroup controllerGroup = controller.getGroupForDrawerSlot(this.slot);
            if (controllerGroup == null) {
                return false;
            }
            IDrawerAttributes attrs = this.getDrawerAttributes(controllerGroup);
            return attrs != null && attrs.isVoid();
        }

        public int insert(int index, ItemResource resource, int amount, TransactionContext transaction) {
            if (!DrawerGroupResourceHandler.this.isGroupValid()) {
                return 0;
            }
            if (!DrawerGroupResourceHandler.this.group.getDrawer(this.slot).canItemBeStored(resource.toStack())) {
                return 0;
            }
            int inserted = super.insert(index, resource, amount, transaction);
            if (inserted < amount) {
                boolean isVoid;
                IDrawerGroup iDrawerGroup = DrawerGroupResourceHandler.this.group;
                if (iDrawerGroup instanceof BlockEntityController) {
                    BlockEntityController controller = (BlockEntityController)iDrawerGroup;
                    isVoid = this.checkControllerVoid(controller);
                } else {
                    iDrawerGroup = DrawerGroupResourceHandler.this.group;
                    if (iDrawerGroup instanceof BlockEntityControllerIO) {
                        BlockEntityControllerIO controllerIO = (BlockEntityControllerIO)iDrawerGroup;
                        BlockEntityController controller = controllerIO.getController();
                        isVoid = this.checkControllerVoid(controller);
                    } else {
                        IDrawerAttributes attr = this.getDrawerAttributes(DrawerGroupResourceHandler.this.group);
                        boolean bl = isVoid = attr != null && attr.isVoid();
                    }
                }
                if (isVoid) {
                    inserted = amount;
                }
            }
            return inserted;
        }

        public int extract(int index, ItemResource resource, int amount, TransactionContext transaction) {
            if (!DrawerGroupResourceHandler.this.isGroupValid()) {
                return 0;
            }
            if (!DrawerGroupResourceHandler.this.group.getDrawer(this.slot).canItemBeExtracted(resource.toStack())) {
                return 0;
            }
            return super.extract(index, resource, amount, transaction);
        }
    }
}

