/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.client.renderer;

import com.jaquadro.minecraft.storagedrawers.api.framing.IFramedSourceBlock;
import com.jaquadro.minecraft.storagedrawers.block.BlockFramingTable;
import com.jaquadro.minecraft.storagedrawers.block.EnumFramingTablePart;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityFramingTable;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.MaterialData;
import com.jaquadro.minecraft.storagedrawers.client.renderer.state.FramingRenderState;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class BlockEntityFramingRenderer
implements BlockEntityRenderer<BlockEntityFramingTable, FramingRenderState> {
    private final BlockEntityRendererProvider.Context context;

    public BlockEntityFramingRenderer(BlockEntityRendererProvider.Context context) {
        this.context = context;
    }

    public FramingRenderState createRenderState() {
        return new FramingRenderState();
    }

    public void extractRenderState(BlockEntityFramingTable blockEntity, FramingRenderState renderState, float partialTick, Vec3 cameraPos, @Nullable ModelFeatureRenderer.CrumblingOverlay crumbleOverlay) {
        super.extractRenderState((BlockEntity)blockEntity, (BlockEntityRenderState)renderState, partialTick, cameraPos, crumbleOverlay);
        int longPos = (int)blockEntity.getBlockPos().asLong();
        MaterialData matData = blockEntity.material();
        if (matData != null) {
            BlockItem blockItem;
            Block targetBlock;
            Item item;
            renderState.sideSlotItem = this.getRenderState(matData.getSide(), blockEntity.getLevel(), longPos + 1);
            renderState.trimSlotItem = this.getRenderState(matData.getTrim(), blockEntity.getLevel(), longPos + 2);
            renderState.frontSlotItem = this.getRenderState(matData.getFront(), blockEntity.getLevel(), longPos + 3);
            ItemStack target = blockEntity.inventory().getItem(0);
            if (target != null && (item = target.getItem()) instanceof BlockItem && (targetBlock = (blockItem = (BlockItem)item).getBlock()) instanceof IFramedSourceBlock) {
                IFramedSourceBlock fsb = (IFramedSourceBlock)targetBlock;
                ItemStack result = fsb.makeFramedItem(target, matData.getEffectiveSide(), matData.getEffectiveTrim(), matData.getEffectiveFront());
                renderState.mainSlotItem = this.getRenderState(result, blockEntity.getLevel(), longPos);
            }
        }
    }

    private ItemStackRenderState getRenderState(ItemStack itemStack, Level level, int id) {
        ItemStackRenderState itemState = new ItemStackRenderState();
        this.context.itemModelResolver().updateForTopItem(itemState, itemStack, ItemDisplayContext.GROUND, level, null, id);
        return itemState;
    }

    public void submit(FramingRenderState renderState, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, CameraRenderState cameraRenderState) {
        if (!(renderState.blockState.getBlock() instanceof BlockFramingTable)) {
            return;
        }
        if (renderState.blockState.getValue(BlockFramingTable.PART) != EnumFramingTablePart.RIGHT) {
            return;
        }
        this.renderSlot(renderState, renderState.mainSlotItem, poseStack, submitNodeCollector, cameraRenderState, 1.6f, 0.5f, 0.1f, -0.5f);
        this.renderSlot(renderState, renderState.sideSlotItem, poseStack, submitNodeCollector, cameraRenderState, 1.0f, 1.15f, 0.15f, -0.275f);
        this.renderSlot(renderState, renderState.trimSlotItem, poseStack, submitNodeCollector, cameraRenderState, 1.0f, -0.14999998f, 0.15f, -0.275f);
        this.renderSlot(renderState, renderState.frontSlotItem, poseStack, submitNodeCollector, cameraRenderState, 1.0f, 1.15f, 0.15f, -0.725f);
    }

    private void renderSlot(FramingRenderState renderState, ItemStackRenderState itemState, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, CameraRenderState cameraRenderState, float scale, float tx, float ty, float tz) {
        if (itemState == null || itemState.isEmpty()) {
            return;
        }
        Direction facing = (Direction)renderState.blockState.getValue((Property)BlockFramingTable.FACING);
        poseStack.pushPose();
        switch (facing) {
            case NORTH: {
                poseStack.mulPose((Matrix4fc)new Matrix4f().rotateY((float)Math.toRadians(180.0)));
                break;
            }
            case EAST: {
                poseStack.mulPose((Matrix4fc)new Matrix4f().rotateY((float)Math.toRadians(90.0)));
                break;
            }
            case WEST: {
                poseStack.mulPose((Matrix4fc)new Matrix4f().rotateY((float)Math.toRadians(270.0)));
                break;
            }
            case SOUTH: {
                poseStack.mulPose((Matrix4fc)new Matrix4f().rotateY((float)Math.toRadians(0.0)));
            }
        }
        switch (facing) {
            case NORTH: {
                poseStack.translate(-0.5f, 0.8f, 0.0f);
                break;
            }
            case EAST: {
                poseStack.translate(-0.5f, 0.8f, 1.0f);
                break;
            }
            case WEST: {
                poseStack.translate(0.5f, 0.8f, 0.0f);
                break;
            }
            case SOUTH: {
                poseStack.translate(0.5f, 0.8f, 1.0f);
            }
        }
        poseStack.translate(tx, ty, tz);
        poseStack.mulPose((Matrix4fc)new Matrix4f().scale(scale, scale, scale));
        try {
            itemState.submit(poseStack, submitNodeCollector, renderState.lightCoords, OverlayTexture.NO_OVERLAY, 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        poseStack.popPose();
    }

    public AABB getRenderBoundingBox(BlockEntityFramingTable blockEntity) {
        BlockPos pos = blockEntity.getBlockPos();
        return AABB.encapsulatingFullBlocks((BlockPos)pos.offset(-1, 0, -1), (BlockPos)pos.offset(1, 1, 1));
    }
}

