/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block.tile;

import com.jaquadro.minecraft.storagedrawers.ModServices;
import com.jaquadro.minecraft.storagedrawers.api.security.ISecurityProvider;
import com.jaquadro.minecraft.storagedrawers.api.storage.IControlGroup;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.api.storage.IFractionalDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.INetworked;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.IProtectable;
import com.jaquadro.minecraft.storagedrawers.block.BlockCompDrawers;
import com.jaquadro.minecraft.storagedrawers.block.EnumCompDrawer;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.FractionalDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.config.ModCommonConfig;
import com.jaquadro.minecraft.storagedrawers.core.ModBlockEntities;
import com.jaquadro.minecraft.storagedrawers.network.CountUpdateMessage;
import com.texelsaurus.minecraft.chameleon.ChameleonServices;
import com.texelsaurus.minecraft.chameleon.capabilities.ChameleonCapability;
import java.util.Set;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public abstract class BlockEntityDrawersComp
extends BlockEntityDrawers {
    public BlockEntityDrawersComp(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state) {
        super(blockEntityType, pos, state);
    }

    @Override
    protected boolean emptySlotCanBeCleared(int slot) {
        if (slot != 0) {
            return false;
        }
        IDrawerGroup iDrawerGroup = this.getGroup();
        if (iDrawerGroup instanceof FractionalDrawerGroup) {
            FractionalDrawerGroup fracGroup = (FractionalDrawerGroup)iDrawerGroup;
            return !this.getGroup().getDrawer(0).isEmpty() && fracGroup.getPooledCount() == 0;
        }
        return false;
    }

    @Override
    public boolean dataPacketRequiresRenderUpdate() {
        return true;
    }

    @Override
    public void clientUpdateCount(int slot, int count) {
        if (this.getLevel() == null || !this.getLevel().isClientSide()) {
            return;
        }
        Minecraft.getInstance().schedule(() -> this.clientUpdateCountAsync(count));
    }

    private void clientUpdateCountAsync(int count) {
        if (this.getGroup() instanceof FractionalDrawerGroup) {
            ((FractionalDrawerGroup)this.getGroup()).setPooledCount(count);
        }
    }

    protected class GroupData
    extends FractionalDrawerGroup
    implements IProtectable,
    INetworked {
        public GroupData(int slotCount) {
            super(slotCount);
        }

        @Override
        protected Level getWorld() {
            return BlockEntityDrawersComp.this.getLevel();
        }

        @Override
        public boolean isGroupValid() {
            return BlockEntityDrawersComp.this.isGroupValid();
        }

        @Override
        protected void log(String message) {
            if (!this.getWorld().isClientSide() && ((Boolean)ModCommonConfig.INSTANCE.GENERAL.debugTrace.get()).booleanValue()) {
                ModServices.log.info(message);
            }
        }

        @Override
        protected int getStackCapacity() {
            return BlockEntityDrawersComp.this.upgrades().getStorageMultiplier() * BlockEntityDrawersComp.this.getEffectiveDrawerCapacity();
        }

        @Override
        protected void onItemChanged() {
            if (this.getWorld() != null && !this.getWorld().isClientSide()) {
                int usedSlots = 0;
                for (int slot : this.getAccessibleDrawerSlots()) {
                    IFractionalDrawer drawer = this.getDrawer(slot);
                    if (drawer.isEmpty()) continue;
                    ++usedSlots;
                }
                usedSlots = Math.max(usedSlots, 1);
                EnumCompDrawer open = (EnumCompDrawer)((Object)BlockEntityDrawersComp.this.getBlockState().getValue(BlockCompDrawers.SLOTS));
                if (open.getOpenSlots() != usedSlots) {
                    this.getWorld().setBlock(BlockEntityDrawersComp.this.worldPosition, (BlockState)BlockEntityDrawersComp.this.getBlockState().setValue(BlockCompDrawers.SLOTS, (Comparable)((Object)EnumCompDrawer.byOpenSlots(usedSlots))), 3);
                }
                BlockEntityDrawersComp.this.setChanged();
                BlockEntityDrawersComp.this.markBlockForUpdate();
            }
        }

        @Override
        protected void onAmountChanged() {
            if (this.getWorld() != null && !this.getWorld().isClientSide()) {
                ChameleonServices.NETWORK.sendToPlayersNear(new CountUpdateMessage(BlockEntityDrawersComp.this.getBlockPos(), 0, this.getPooledCount()), (ServerLevel)BlockEntityDrawersComp.this.getLevel(), BlockEntityDrawersComp.this.getBlockPos().getX(), BlockEntityDrawersComp.this.getBlockPos().getY(), BlockEntityDrawersComp.this.getBlockPos().getZ(), 500.0);
                BlockEntityDrawersComp.this.setChanged();
            }
        }

        @Override
        public <T> T getCapability(ChameleonCapability<T> capability) {
            if (capability == null || BlockEntityDrawersComp.this.level == null) {
                return null;
            }
            return capability.getCapability(BlockEntityDrawersComp.this.level, BlockEntityDrawersComp.this.getBlockPos());
        }

        @Override
        public UUID getOwner() {
            return BlockEntityDrawersComp.this.getOwner();
        }

        @Override
        public boolean setOwner(UUID owner) {
            return BlockEntityDrawersComp.this.setOwner(owner);
        }

        @Override
        public ISecurityProvider getSecurityProvider() {
            return BlockEntityDrawersComp.this.getSecurityProvider();
        }

        @Override
        public boolean setSecurityProvider(ISecurityProvider provder) {
            return BlockEntityDrawersComp.this.setSecurityProvider(provder);
        }

        @Override
        public IControlGroup getBoundControlGroup() {
            return BlockEntityDrawersComp.this.getBoundControlGroup();
        }

        @Override
        public Set<IControlGroup> getSoftBoundControlGroups() {
            return BlockEntityDrawersComp.super.getSoftBoundControlGroups();
        }
    }

    public static class Slot3
    extends BlockEntityDrawersComp {
        private final GroupData groupData = new GroupData(3);

        public Slot3(BlockPos pos, BlockState state) {
            super((BlockEntityType)ModBlockEntities.FRACTIONAL_DRAWERS_3.get(), pos, state);
            this.injectPortableData(this.groupData);
        }

        @Override
        @NotNull
        public IDrawerGroup getGroup() {
            return this.groupData;
        }

        @Override
        protected void onAttributeChanged() {
            super.onAttributeChanged();
            this.groupData.syncAttributes();
        }
    }

    public static class Slot2
    extends BlockEntityDrawersComp {
        private final GroupData groupData = new GroupData(2);

        public Slot2(BlockPos pos, BlockState state) {
            super((BlockEntityType)ModBlockEntities.FRACTIONAL_DRAWERS_2.get(), pos, state);
            this.injectPortableData(this.groupData);
        }

        @Override
        @NotNull
        public IDrawerGroup getGroup() {
            return this.groupData;
        }

        @Override
        protected void onAttributeChanged() {
            super.onAttributeChanged();
            this.groupData.syncAttributes();
        }
    }
}

