/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.naturescompass.worker;

import com.chaosthedude.naturescompass.NaturesCompass;
import com.chaosthedude.naturescompass.config.ConfigHandler;
import com.chaosthedude.naturescompass.items.NaturesCompassItem;
import com.chaosthedude.naturescompass.util.BiomeUtils;
import com.chaosthedude.naturescompass.worker.WorldWorkerManager;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.QuartPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;

public class BiomeSearchWorker
implements WorldWorkerManager.IWorker {
    private final int sampleSpace;
    private final int maxSamples;
    private final int maxRadius;
    private ServerLevel level;
    private ResourceLocation biomeKey;
    private BlockPos startPos;
    private int samples;
    private int nextLength;
    private Direction direction;
    private ItemStack stack;
    private Player player;
    private int x;
    private int z;
    private int[] yValues;
    private int length;
    private boolean finished;
    private int lastRadiusThreshold;

    public BiomeSearchWorker(ServerLevel level, Player player, ItemStack stack, Biome biome, BlockPos startPos) {
        this.level = level;
        this.player = player;
        this.stack = stack;
        this.startPos = startPos;
        this.x = startPos.getX();
        this.z = startPos.getZ();
        this.yValues = Mth.outFromOrigin((int)startPos.getY(), (int)(level.getMinY() + 1), (int)level.getMaxY(), (int)64).toArray();
        this.sampleSpace = (Integer)ConfigHandler.GENERAL.sampleSpaceModifier.get() * BiomeUtils.getBiomeSize((Level)level);
        this.maxSamples = (Integer)ConfigHandler.GENERAL.maxSamples.get();
        this.maxRadius = (Integer)ConfigHandler.GENERAL.radiusModifier.get() * BiomeUtils.getBiomeSize((Level)level);
        this.nextLength = this.sampleSpace;
        this.length = 0;
        this.samples = 0;
        this.direction = Direction.UP;
        this.finished = false;
        this.biomeKey = BiomeUtils.getKeyForBiome((Level)level, biome).isPresent() ? BiomeUtils.getKeyForBiome((Level)level, biome).get() : null;
        this.lastRadiusThreshold = 0;
    }

    public void start() {
        if (!this.stack.isEmpty() && this.stack.getItem() == NaturesCompass.naturesCompass) {
            if (this.maxRadius > 0 && this.sampleSpace > 0) {
                NaturesCompass.LOGGER.info("Starting search: " + this.sampleSpace + " sample space, " + this.maxSamples + " max samples, " + this.maxRadius + " max radius");
                WorldWorkerManager.addWorker(this);
            } else {
                this.fail();
            }
        }
    }

    @Override
    public boolean hasWork() {
        return this.biomeKey != null && !this.finished && this.getRadius() <= this.maxRadius && this.samples <= this.maxSamples;
    }

    @Override
    public boolean doWork() {
        if (this.hasWork()) {
            int radius;
            if (this.direction == Direction.NORTH) {
                this.z -= this.sampleSpace;
            } else if (this.direction == Direction.EAST) {
                this.x += this.sampleSpace;
            } else if (this.direction == Direction.SOUTH) {
                this.z += this.sampleSpace;
            } else if (this.direction == Direction.WEST) {
                this.x -= this.sampleSpace;
            }
            int sampleX = QuartPos.fromBlock((int)this.x);
            int sampleZ = QuartPos.fromBlock((int)this.z);
            for (int y : this.yValues) {
                int sampleY = QuartPos.fromBlock((int)y);
                Biome biomeAtPos = (Biome)this.level.getChunkSource().getGenerator().getBiomeSource().getNoiseBiome(sampleX, sampleY, sampleZ, this.level.getChunkSource().randomState().sampler()).value();
                Optional<ResourceLocation> optionalBiomeAtPosKey = BiomeUtils.getKeyForBiome((Level)this.level, biomeAtPos);
                if (!optionalBiomeAtPosKey.isPresent() || !optionalBiomeAtPosKey.get().equals((Object)this.biomeKey)) continue;
                this.succeed();
                return false;
            }
            ++this.samples;
            this.length += this.sampleSpace;
            if (this.length >= this.nextLength) {
                if (this.direction != Direction.UP) {
                    this.nextLength += this.sampleSpace;
                    this.direction = this.direction.getClockWise();
                } else {
                    this.direction = Direction.NORTH;
                }
                this.length = 0;
            }
            if ((radius = this.getRadius()) > 500 && radius / 500 > this.lastRadiusThreshold) {
                if (!this.stack.isEmpty() && this.stack.getItem() == NaturesCompass.naturesCompass) {
                    ((NaturesCompassItem)this.stack.getItem()).setSearchRadius(this.stack, this.roundRadius(radius, 500), this.player);
                }
                this.lastRadiusThreshold = radius / 500;
            }
        }
        if (this.hasWork()) {
            return true;
        }
        if (!this.finished) {
            this.fail();
        }
        return false;
    }

    private void succeed() {
        NaturesCompass.LOGGER.info("Search succeeded: " + this.getRadius() + " radius, " + this.samples + " samples");
        if (!this.stack.isEmpty() && this.stack.getItem() == NaturesCompass.naturesCompass) {
            ((NaturesCompassItem)this.stack.getItem()).succeed(this.stack, this.player, this.x, this.z, this.samples, (Boolean)ConfigHandler.GENERAL.displayCoordinates.get());
        } else {
            NaturesCompass.LOGGER.error("Invalid compass after search");
        }
        this.finished = true;
    }

    private void fail() {
        NaturesCompass.LOGGER.info("Search failed: " + this.getRadius() + " radius, " + this.samples + " samples");
        if (!this.stack.isEmpty() && this.stack.getItem() == NaturesCompass.naturesCompass) {
            ((NaturesCompassItem)this.stack.getItem()).fail(this.stack, this.player, this.roundRadius(this.getRadius(), 500), this.samples);
        } else {
            NaturesCompass.LOGGER.error("Invalid compass after search");
        }
        this.finished = true;
    }

    public void stop() {
        NaturesCompass.LOGGER.info("Search stopped: " + this.getRadius() + " radius, " + this.samples + " samples");
        this.finished = true;
    }

    private int getRadius() {
        return BiomeUtils.getDistanceToBiome(this.startPos, this.x, this.z);
    }

    private int roundRadius(int radius, int roundTo) {
        return radius / roundTo * roundTo;
    }
}

