/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.naturescompass;

import com.chaosthedude.naturescompass.config.ConfigHandler;
import com.chaosthedude.naturescompass.items.NaturesCompassItem;
import com.chaosthedude.naturescompass.network.SearchPacket;
import com.chaosthedude.naturescompass.network.SyncPacket;
import com.chaosthedude.naturescompass.network.TeleportPacket;
import com.chaosthedude.naturescompass.worker.WorldWorkerManager;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.neoforged.neoforge.server.permission.events.PermissionGatherEvent;
import net.neoforged.neoforge.server.permission.nodes.PermissionDynamicContextKey;
import net.neoforged.neoforge.server.permission.nodes.PermissionNode;
import net.neoforged.neoforge.server.permission.nodes.PermissionTypes;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="naturescompass")
public class NaturesCompass {
    public static final String MODID = "naturescompass";
    public static final PermissionNode<Boolean> TELEPORT_PERMISSION = new PermissionNode("naturescompass", "naturescompass.teleport", PermissionTypes.BOOLEAN, (player, playerUUID, context) -> false, new PermissionDynamicContextKey[0]);
    public static final Logger LOGGER = LogManager.getLogger((String)"naturescompass");
    public static NaturesCompassItem naturesCompass;
    public static final DataComponentType<String> BIOME_ID;
    public static final DataComponentType<Integer> COMPASS_STATE;
    public static final DataComponentType<Integer> FOUND_X;
    public static final DataComponentType<Integer> FOUND_Z;
    public static final DataComponentType<Integer> SEARCH_RADIUS;
    public static final DataComponentType<Integer> SAMPLES;
    public static final DataComponentType<Boolean> DISPLAY_COORDS;
    public static boolean canTeleport;
    public static List<ResourceLocation> allowedBiomes;
    public static ListMultimap<ResourceLocation, ResourceLocation> dimensionKeysForAllowedBiomeKeys;
    public static NaturesCompass instance;

    public NaturesCompass(ModContainer modContainer) {
        instance = this;
        modContainer.getEventBus().addListener(this::preInit);
        modContainer.getEventBus().addListener(this::buildCreativeTabContents);
        modContainer.getEventBus().addListener(this::registerPayloads);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ConfigHandler.GENERAL_SPEC);
        modContainer.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ConfigHandler.CLIENT_SPEC);
        NeoForge.EVENT_BUS.register((Object)this);
    }

    private void preInit(FMLCommonSetupEvent event) {
        allowedBiomes = new ArrayList<ResourceLocation>();
        dimensionKeysForAllowedBiomeKeys = ArrayListMultimap.create();
    }

    private void buildCreativeTabContents(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.TOOLS_AND_UTILITIES) {
            event.accept(new ItemStack((ItemLike)naturesCompass));
        }
    }

    private void registerPayloads(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar(MODID);
        registrar.playToServer(SearchPacket.TYPE, SearchPacket.CODEC, SearchPacket::handle);
        registrar.playToServer(TeleportPacket.TYPE, TeleportPacket.CODEC, TeleportPacket::handle);
        registrar.playToClient(SyncPacket.TYPE, SyncPacket.CODEC, SyncPacket::handle);
    }

    @SubscribeEvent
    public void registerNodes(PermissionGatherEvent.Nodes event) {
        event.addNodes(new PermissionNode[]{TELEPORT_PERMISSION});
    }

    @SubscribeEvent
    public void preServerTick(ServerTickEvent.Pre event) {
        WorldWorkerManager.tick(true);
    }

    @SubscribeEvent
    public void postServerTick(ServerTickEvent.Post event) {
        WorldWorkerManager.tick(false);
    }

    @SubscribeEvent
    public void serverStopping(ServerStoppingEvent evt) {
        WorldWorkerManager.clear();
    }

    static {
        BIOME_ID = DataComponentType.builder().persistent((Codec)Codec.STRING).networkSynchronized(ByteBufCodecs.STRING_UTF8).build();
        COMPASS_STATE = DataComponentType.builder().persistent((Codec)Codec.INT).networkSynchronized(ByteBufCodecs.VAR_INT).build();
        FOUND_X = DataComponentType.builder().persistent((Codec)Codec.INT).networkSynchronized(ByteBufCodecs.VAR_INT).build();
        FOUND_Z = DataComponentType.builder().persistent((Codec)Codec.INT).networkSynchronized(ByteBufCodecs.VAR_INT).build();
        SEARCH_RADIUS = DataComponentType.builder().persistent((Codec)Codec.INT).networkSynchronized(ByteBufCodecs.VAR_INT).build();
        SAMPLES = DataComponentType.builder().persistent((Codec)Codec.INT).networkSynchronized(ByteBufCodecs.VAR_INT).build();
        DISPLAY_COORDS = DataComponentType.builder().persistent((Codec)Codec.BOOL).networkSynchronized(ByteBufCodecs.BOOL).build();
    }
}

