/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.corpse.entities;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import de.maxhenkel.corpse.CorpseMod;
import de.maxhenkel.corpse.corelib.CachedMap;
import de.maxhenkel.corpse.entities.CorpseEntity;
import de.maxhenkel.corpse.entities.CorpseRenderState;
import de.maxhenkel.corpse.entities.DummyPlayer;
import de.maxhenkel.corpse.entities.DummySkeleton;
import java.util.UUID;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.SkeletonRenderer;
import net.minecraft.client.renderer.entity.player.AvatarRenderer;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.world.entity.Avatar;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import org.joml.Quaternionfc;

public class CorpseRenderer
extends EntityRenderer<CorpseEntity, CorpseRenderState> {
    private final CachedMap<UUID, DummyPlayer> players = new CachedMap(10000L);
    private final CachedMap<UUID, DummySkeleton> skeletons = new CachedMap(10000L);

    public CorpseRenderer(EntityRendererProvider.Context renderer) {
        super(renderer);
    }

    public CorpseRenderState createRenderState() {
        return new CorpseRenderState();
    }

    public void submit(CorpseRenderState state, PoseStack stack, SubmitNodeCollector collector, CameraRenderState cameraRenderState) {
        super.submit((EntityRenderState)state, stack, collector, cameraRenderState);
        stack.pushPose();
        stack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-state.yRot));
        if (((Boolean)CorpseMod.SERVER_CONFIG.spawnCorpseOnFace.get()).booleanValue()) {
            stack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(90.0f));
            stack.translate(0.0, -1.0, -0.125625);
        } else {
            stack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(-90.0f));
            stack.translate(0.0, -1.0, 0.125625);
        }
        if (state.skeleton) {
            this.entityRenderDispatcher.getRenderer((EntityRenderState)state.skeletonRenderState).submit((EntityRenderState)state.skeletonRenderState, stack, collector, cameraRenderState);
        } else {
            this.entityRenderDispatcher.getRenderer((EntityRenderState)state.playerRenderState).submit((EntityRenderState)state.playerRenderState, stack, collector, cameraRenderState);
        }
        stack.popPose();
    }

    public void extractRenderState(CorpseEntity corpse, CorpseRenderState state, float partialTicks) {
        super.extractRenderState((Entity)corpse, (EntityRenderState)state, partialTicks);
        state.yRot = corpse.getYRot();
        state.skeleton = corpse.isSkeleton();
        if (corpse.isSkeleton()) {
            DummySkeleton skeleton = this.skeletons.get(corpse.getUUID(), () -> new DummySkeleton(corpse.level(), corpse.getEquipment()));
            ((SkeletonRenderer)this.entityRenderDispatcher.getRenderer((EntityRenderState)state.skeletonRenderState)).extractRenderState((AbstractSkeleton)skeleton, state.skeletonRenderState, 0.0f);
            state.skeletonRenderState.lightCoords = state.lightCoords;
        } else {
            DummyPlayer dummyPlayer = this.players.get(corpse.getUUID(), () -> new DummyPlayer((ClientLevel)corpse.level(), new GameProfile(corpse.getPlayerUuid(), corpse.getCorpseName()), corpse.getEquipment(), corpse.getCorpseModel()));
            ((AvatarRenderer)this.entityRenderDispatcher.getRenderer((EntityRenderState)state.playerRenderState)).extractRenderState((Avatar)dummyPlayer, state.playerRenderState, 0.0f);
            state.playerRenderState.lightCoords = state.lightCoords;
        }
    }
}

