/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.server.gui.registry;

import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.manager.GuiManager;
import team.creative.creativecore.server.gui.GuiServerControl;
import team.creative.creativecore.server.gui.manager.GuiServerManager;

public class GuiServerRegistry {
    private static final Object2ObjectMap<Class<? extends GuiControl>, Function<GuiControl, GuiServerControl>> CONTROL_FACTORY = new Object2ObjectArrayMap();
    private static final List<Function<GuiControl, GuiServerControl>> CONTROL_SPECIAL_FACTORY = new ArrayList<Function<GuiControl, GuiServerControl>>();
    private static final Object2ObjectMap<Class<? extends GuiManager>, Function<GuiManager, GuiServerManager>> MANAGER_FACTORY = new Object2ObjectArrayMap();

    public static GuiServerControl create(GuiControl control) {
        Function function = (Function)CONTROL_FACTORY.get(control.getClass());
        if (function != null) {
            return (GuiServerControl)function.apply(control);
        }
        for (int i = 0; i < CONTROL_SPECIAL_FACTORY.size(); ++i) {
            GuiServerControl result = CONTROL_SPECIAL_FACTORY.get(i).apply(control);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static GuiServerManager create(GuiManager manager) {
        Function function = (Function)MANAGER_FACTORY.get(manager.getClass());
        if (function != null) {
            return (GuiServerManager)function.apply(manager);
        }
        return null;
    }

    public static <T extends GuiControl> void register(Class<T> clazz, Function<T, GuiServerControl> factory) {
        CONTROL_FACTORY.put(clazz, factory);
    }

    public static <T extends GuiManager> void registerManager(Class<T> clazz, Function<T, GuiServerManager> factory) {
        MANAGER_FACTORY.put(clazz, factory);
    }

    public static void registerSpecial(Function<GuiControl, GuiServerControl> factory) {
        CONTROL_SPECIAL_FACTORY.add(factory);
    }
}

