/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.cursee.disenchanting_table;

import fabric.com.cursee.disenchanting_table.Constants;
import fabric.com.cursee.disenchanting_table.DisEnchantingTable;
import fabric.com.cursee.disenchanting_table.impl.common.config.SimpleConfig;
import fabric.com.cursee.disenchanting_table.platform.Services;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class DisEnchantingTableClient {
    public static boolean render_block_particles = true;
    public static boolean render_experience_cost = true;
    public static boolean render_table_item = true;

    public static void createOrLoadConfiguration() {
        String configDirectoryPathString = Services.PLATFORM.getGameDirectory() + File.separator + "config";
        File configDirectory = new File(configDirectoryPathString);
        if (!configDirectory.isDirectory() && !configDirectory.mkdirs()) {
            DisEnchantingTable.mkdirsFailed(configDirectoryPathString);
            return;
        }
        String configFileNameString = "disenchanting_table-client.toml";
        String configFilePathString = configDirectoryPathString + File.separator + configFileNameString;
        File configFile = new File(configFilePathString);
        if (!configFile.exists()) {
            try (InputStream inputStream = DisEnchantingTable.class.getClassLoader().getResourceAsStream("assets/" + configFileNameString);){
                if (inputStream == null) {
                    Constants.LOG.info("Failed to initialize InputStream instance for assets/{}", (Object)configFileNameString);
                    return;
                }
                try (BufferedInputStream bis = new BufferedInputStream(inputStream);
                     BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(configFile));){
                    int bytesRead;
                    byte[] buffer = new byte[8192];
                    while ((bytesRead = bis.read(buffer)) != -1) {
                        bos.write(buffer, 0, bytesRead);
                    }
                }
            }
            catch (IOException e) {
                Constants.LOG.info("Failed to read internal resource: assets/{}", (Object)configFileNameString);
                Constants.LOG.info(e.getMessage());
            }
        } else {
            try {
                SimpleConfig config = new SimpleConfig(configFilePathString);
                render_block_particles = config.getBoolean("render_block_particles", render_block_particles);
                render_experience_cost = config.getBoolean("render_experience_cost", render_experience_cost);
                render_table_item = config.getBoolean("render_table_item", render_table_item);
            }
            catch (IOException ignored) {
                Constants.LOG.info("Failed to read {}, retaining default config values", (Object)configFilePathString);
            }
        }
    }
}

