/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.network.model;

import java.util.UUID;
import journeymap.common.Journeymap;
import journeymap.common.network.model.PlayerLocation;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;

public class PlayerLoc
implements PlayerLocation {
    private int entityId;
    private UUID uniqueId;
    private double x;
    private double y;
    private double z;
    private byte yaw;
    private byte pitch;
    private boolean visible;

    public PlayerLoc() {
    }

    public PlayerLoc(Player player, boolean visible) {
        this.uniqueId = player.getGameProfile().id();
        this.visible = visible;
        if (visible) {
            this.entityId = player.getId();
            this.x = player.getX();
            this.y = player.getY();
            this.z = player.getZ();
            this.yaw = (byte)(player.getYRot() * 256.0f / 360.0f);
            this.pitch = (byte)(player.getXRot() * 256.0f / 360.0f);
        }
    }

    @Override
    public int getEntityId() {
        return this.entityId;
    }

    @Override
    public UUID getUniqueId() {
        return this.uniqueId;
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public double getY() {
        return this.y;
    }

    @Override
    public double getZ() {
        return this.z;
    }

    @Override
    public byte getYaw() {
        return this.yaw;
    }

    @Override
    public byte getPitch() {
        return this.pitch;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeBoolean(this.visible);
        buf.writeUUID(this.uniqueId);
        if (this.visible) {
            buf.writeVarInt(this.entityId);
            buf.writeDouble(this.x);
            buf.writeDouble(this.y);
            buf.writeDouble(this.z);
            buf.writeByte(this.yaw);
            buf.writeByte(this.pitch);
        }
    }

    public static PlayerLoc decode(FriendlyByteBuf buf) {
        PlayerLoc loc = new PlayerLoc();
        loc.visible = false;
        loc.uniqueId = UUID.randomUUID();
        try {
            if (buf.readableBytes() > 1) {
                loc.visible = buf.readBoolean();
                loc.uniqueId = buf.readUUID();
                if (loc.visible) {
                    loc.entityId = buf.readVarInt();
                    loc.x = buf.readDouble();
                    loc.y = buf.readDouble();
                    loc.z = buf.readDouble();
                    loc.yaw = buf.readByte();
                    loc.pitch = buf.readByte();
                }
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("[toBytes]Failed to write message for player location request:" + String.valueOf(t));
        }
        return loc;
    }
}

