/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component.screens;

import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import java.util.Stack;
import java.util.stream.Collectors;
import journeymap.client.Constants;
import journeymap.client.render.RenderWrapper;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.component.buttons.Button;
import journeymap.client.ui.component.screens.JmUI;
import journeymap.client.ui.component.widgets.LogoWidget;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.renderer.CachedOrthoProjectionMatrixBuffer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import org.apache.logging.log4j.Logger;

public abstract class JmUILegacy
extends Screen {
    protected final String title;
    protected final int headerHeight = 36;
    protected final int footerHeight = 30;
    protected final Logger logger = Journeymap.getLogger();
    protected double scaleFactor = 1.0;
    protected static Stack<Screen> returnDisplayStack = JmUI.returnDisplayStack;
    protected boolean renderBottomBar = false;
    private final CachedOrthoProjectionMatrixBuffer guiProjectionMatrixBuffer = new CachedOrthoProjectionMatrixBuffer("jmui", 1000.0f, 11000.0f, true);
    protected LogoWidget logoWidget;

    public JmUILegacy(String title) {
        this(title, null);
    }

    public JmUILegacy(String title, Screen returnDisplay) {
        super((Component)Constants.getStringTextComponent(title));
        this.title = title;
        returnDisplayStack.push(returnDisplay);
    }

    public Minecraft getMinecraft() {
        this.minecraft = Minecraft.getInstance();
        return this.minecraft;
    }

    public void init(Minecraft minecraft, int width, int height) {
        super.init(minecraft, width, height);
        this.scaleFactor = JmUI.calculateScaleFactor();
    }

    public boolean isPauseScreen() {
        return true;
    }

    public Font getFontRenderer() {
        return this.font;
    }

    protected boolean isMouseOverButton(double mouseX, double mouseY) {
        for (int k = 0; k < this.getRenderables().size(); ++k) {
            Button button;
            net.minecraft.client.gui.components.Button guibutton = (net.minecraft.client.gui.components.Button)this.getRenderables().get(k);
            if (!(guibutton instanceof Button) || !(button = (Button)guibutton).mouseOver(mouseX, mouseY)) continue;
            return true;
        }
        return false;
    }

    protected void drawLogo(GuiGraphics graphics, PoseStack poseStack) {
        if (this.logoWidget == null) {
            this.logoWidget = new LogoWidget(JmUI::calculateScaleFactor);
        }
        this.logoWidget.renderWidget(graphics, 0, 0, 0.0f);
    }

    protected void renderBottomBar(GuiGraphics graphics, PoseStack poseStack) {
        if (this.renderBottomBar) {
            DrawUtil.drawRectangle(graphics, 0.0, this.height - 30, this.width, this.height, 0, 0.6f);
        }
    }

    protected void drawTitle(GuiGraphics graphics, PoseStack poseStack) {
        DrawUtil.drawRectangle(graphics, 0.0, 0.0, this.width, 36.0, 0, 0.9f);
        DrawUtil.drawLabel(graphics, (Component)Component.literal((String)this.title), this.width / 2, 18.0, DrawUtil.HAlign.Center, DrawUtil.VAlign.Middle, 0, 0.0f, Color.CYAN.getRGB(), 1.0f, 1.0, true, 0.0);
        String apiVersion = "API v2.0.0-SNAPSHOT";
        DrawUtil.drawLabel(graphics, (Component)Component.literal((String)apiVersion), this.width - 10, 18.0, DrawUtil.HAlign.Left, DrawUtil.VAlign.Middle, 0, 0.0f, 0xCCCCCC, 1.0f, 0.5, true, 0.0);
    }

    public void init() {
        this.getRenderables().clear();
    }

    public void renderBackground(GuiGraphics graphics, int i, int j, float f) {
        if (Minecraft.getInstance().level == null) {
            this.drawGradientRect(graphics, 0, 0, this.width, this.height, -1072689136, -804253680, 0);
        } else {
            super.renderBackground(graphics, i, j, f);
        }
    }

    protected abstract void layoutButtons(GuiGraphics var1, PoseStack var2);

    public <T extends GuiEventListener & Renderable> T addRenderableWidget(T widget) {
        this.renderables.add((Renderable)widget);
        return (T)this.addWidget(widget);
    }

    public <T extends Renderable> T addRenderableOnly(T renderable) {
        this.renderables.add(renderable);
        return renderable;
    }

    public void render(GuiGraphics graphics, int x, int y, float partialTicks) {
        try {
            PoseStack pose = new PoseStack();
            this.renderBottomBar(graphics, pose);
            this.layoutButtons(graphics, pose);
            this.drawTitle(graphics, pose);
            this.drawLogo(graphics, pose);
            List<FormattedCharSequence> tooltip = null;
            for (int k = 0; k < this.getRenderables().size(); ++k) {
                Button button;
                Renderable guibutton = this.getRenderables().get(k);
                guibutton.render(graphics, x, y, 0.0f);
                if (tooltip != null || !(guibutton instanceof Button) || !(button = (Button)guibutton).mouseOver(x, y)) continue;
                tooltip = button.getWrappedTooltip();
            }
            if (tooltip != null && !tooltip.isEmpty()) {
                this.renderWrappedToolTip(graphics, pose, tooltip, x, y, this.getFontRenderer());
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("Error in UI: " + LogFormatter.toString(t));
            this.closeAndReturn();
        }
    }

    public void drawGradientRect(GuiGraphics graphics, int pX1, int pY1, int pX2, int pY2, int pColorFrom, int pColorTo, int pBlitOffset) {
        graphics.fillGradient(pX1, pY1, pX2, pY2, pColorFrom, pColorTo);
    }

    protected void closeAndReturn() {
        if (returnDisplayStack == null || returnDisplayStack.peek() == null) {
            UIManager.INSTANCE.closeAll();
        } else {
            UIManager.INSTANCE.open(returnDisplayStack.pop());
        }
        this.guiProjectionMatrixBuffer.close();
    }

    public void closeWithKeyBind() {
        this.closeAndReturn();
    }

    public void setRenderBottomBar(boolean renderBottomBar) {
        this.renderBottomBar = renderBottomBar;
    }

    public boolean keyPressed(KeyEvent event) {
        switch (event.key()) {
            case 256: {
                this.closeAndReturn();
                return true;
            }
        }
        return super.keyPressed(event);
    }

    public void renderTooltip(GuiGraphics graphics, PoseStack pose, String[] tooltip, int mouseX, int mouseY) {
        List tooltips = Arrays.stream(tooltip).map(e -> FormattedCharSequence.forward((String)e, (Style)Style.EMPTY)).collect(Collectors.toList());
        this.renderWrappedToolTip(graphics, pose, tooltips, mouseX, mouseY, this.getFontRenderer());
    }

    public Screen getReturnDisplay() {
        return returnDisplayStack.peek();
    }

    public void renderWrappedToolTip(GuiGraphics graphics, PoseStack pose, List tooltip, int mouseX, int mouseY, Font fontRenderer) {
        if (!tooltip.isEmpty() && tooltip.get(0) instanceof FormattedCharSequence && Minecraft.getInstance().screen == this) {
            RenderWrapper.disableDepthTest();
            int maxLineWidth = 0;
            for (FormattedCharSequence line : tooltip) {
                int lineWidth = fontRenderer.width(line);
                if (fontRenderer.isBidirectional()) {
                    lineWidth = (int)Math.ceil((double)lineWidth * 1.25);
                }
                if (lineWidth <= maxLineWidth) continue;
                maxLineWidth = lineWidth;
            }
            int drawX = mouseX + 12;
            int drawY = mouseY - 12;
            int boxHeight = 8;
            if (tooltip.size() > 1) {
                boxHeight += 2 + (tooltip.size() - 1) * 10;
            }
            if (drawX + maxLineWidth > this.width) {
                drawX -= 28 + maxLineWidth;
            }
            if (drawY + boxHeight + 6 > this.height) {
                drawY = this.height - boxHeight - 6;
            }
            if (drawY - 4 < 0) {
                drawY = 4;
            }
            int j1 = -267386864;
            this.drawGradientRect(graphics, drawX - 3, drawY - 4, drawX + maxLineWidth + 3, drawY - 3, j1, j1, 300);
            this.drawGradientRect(graphics, drawX - 3, drawY + boxHeight + 3, drawX + maxLineWidth + 3, drawY + boxHeight + 4, j1, j1, 300);
            this.drawGradientRect(graphics, drawX - 3, drawY - 3, drawX + maxLineWidth + 3, drawY + boxHeight + 3, j1, j1, 300);
            this.drawGradientRect(graphics, drawX - 4, drawY - 3, drawX - 3, drawY + boxHeight + 3, j1, j1, 300);
            this.drawGradientRect(graphics, drawX + maxLineWidth + 3, drawY - 3, drawX + maxLineWidth + 4, drawY + boxHeight + 3, j1, j1, 300);
            int k1 = 0x505000FF;
            int l1 = (k1 & 0xFEFEFE) >> 1 | k1 & 0xFF000000;
            this.drawGradientRect(graphics, drawX - 3, drawY - 3 + 1, drawX - 3 + 1, drawY + boxHeight + 3 - 1, k1, l1, 300);
            this.drawGradientRect(graphics, drawX + maxLineWidth + 2, drawY - 3 + 1, drawX + maxLineWidth + 3, drawY + boxHeight + 3 - 1, k1, l1, 300);
            this.drawGradientRect(graphics, drawX - 3, drawY - 3, drawX + maxLineWidth + 3, drawY - 3 + 1, k1, k1, 300);
            this.drawGradientRect(graphics, drawX - 3, drawY + boxHeight + 2, drawX + maxLineWidth + 3, drawY + boxHeight + 3, l1, l1, 300);
            for (int i2 = 0; i2 < tooltip.size(); ++i2) {
                FormattedCharSequence line = (FormattedCharSequence)tooltip.get(i2);
                if (fontRenderer.isBidirectional()) {
                    int lineWidth = (int)Math.ceil((double)fontRenderer.width(line) * 1.1);
                    graphics.drawString(this.font, line, drawX + maxLineWidth - lineWidth, drawY, -1, true);
                } else {
                    graphics.drawString(this.font, line, drawX, drawY, -1, true);
                }
                if (i2 == 0) {
                    drawY += 2;
                }
                drawY += 10;
            }
            RenderWrapper.enableDepthTest();
        }
    }

    public List<Renderable> getRenderables() {
        return this.renderables;
    }
}

