/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.texture.gl;

import com.mojang.blaze3d.GpuOutOfMemoryException;
import com.mojang.blaze3d.opengl.GlConst;
import com.mojang.blaze3d.opengl.GlStateManager;
import com.mojang.blaze3d.opengl.GlTexture;
import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.blaze3d.textures.TextureFormat;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import journeymap.api.client.impl.ClientAPI;
import journeymap.api.v2.client.display.Context;
import journeymap.client.JourneymapClient;
import journeymap.client.render.RenderWrapper;
import org.lwjgl.opengl.GL11;

public class GlRegionTexture
extends GlTexture {
    public GlRegionTexture(int usage, String label, TextureFormat format, int width, int height, int depthOrLayers, int mipLevels, int id) {
        super(usage, label, format, width, height, depthOrLayers, mipLevels, id);
    }

    public void flushModeChanges(int p_423621_) {
        boolean blur = false;
        if (ClientAPI.INSTANCE.getLastUIState().ui == Context.UI.Fullscreen) {
            blur = JourneymapClient.getInstance().getFullMapProperties().zoomLevel.get() < 512;
        } else if (ClientAPI.INSTANCE.getLastUIState().ui == Context.UI.Minimap) {
            blur = JourneymapClient.getInstance().getActiveMiniMapProperties().zoomLevel.get() < 512;
        }
        int mipmapLevels = JourneymapClient.getInstance().getCoreProperties().mipmapLevels.get();
        int mag = mipmapLevels == 0 && blur ? 9729 : 9984;
        int min = mipmapLevels == 0 && blur ? 9729 : 9728;
        RenderWrapper.texParameter(3553, 10241, mag);
        RenderWrapper.texParameter(3553, 10240, min);
        RenderWrapper.texParameter(3553, 10242, 33071);
        RenderWrapper.texParameter(3553, 10243, 33071);
        RenderWrapper.texParameter(3553, 33085, mipmapLevels);
        RenderWrapper.texParameter(3553, 33082, 0);
        RenderWrapper.texParameter(3553, 33083, mipmapLevels);
        RenderWrapper.texParameter(3553, 34049, 0);
        this.modesDirty = false;
    }

    public static GpuTexture createTexture(@Nullable String label, int usage, TextureFormat format, int width, int height, int depthOrLayers, int mipLevels) {
        int j1;
        int j;
        boolean flag = (usage & 0x10) != 0;
        GlStateManager.clearGlErrors();
        int id = GlStateManager._genTexture();
        if (label == null) {
            label = String.valueOf(id);
        }
        if (flag) {
            GL11.glBindTexture((int)34067, (int)id);
            j = 34067;
        } else {
            GlStateManager._bindTexture((int)id);
            j = 3553;
        }
        GlStateManager._texParameter((int)j, (int)33085, (int)(mipLevels - 1));
        GlStateManager._texParameter((int)j, (int)33082, (int)0);
        GlStateManager._texParameter((int)j, (int)33083, (int)(mipLevels - 1));
        if (format.hasDepthAspect()) {
            GlStateManager._texParameter((int)j, (int)34892, (int)0);
        }
        if (flag) {
            for (int k : GlConst.CUBEMAP_TARGETS) {
                for (int l = 0; l < mipLevels; ++l) {
                    GlStateManager._texImage2D((int)k, (int)l, (int)GlConst.toGlInternalId((TextureFormat)format), (int)(width >> l), (int)(height >> l), (int)0, (int)GlConst.toGlExternalId((TextureFormat)format), (int)GlConst.toGlType((TextureFormat)format), (ByteBuffer)null);
                }
            }
        } else {
            for (j1 = 0; j1 < mipLevels; ++j1) {
                GlStateManager._texImage2D((int)j, (int)j1, (int)GlConst.toGlInternalId((TextureFormat)format), (int)(width >> j1), (int)(height >> j1), (int)0, (int)GlConst.toGlExternalId((TextureFormat)format), (int)GlConst.toGlType((TextureFormat)format), (ByteBuffer)null);
            }
        }
        if ((j1 = GlStateManager._getError()) == 1285) {
            throw new GpuOutOfMemoryException("Could not allocate texture of " + width + "x" + height + " for " + label);
        }
        if (j1 != 0) {
            throw new IllegalStateException("OpenGL error " + j1);
        }
        return new GlRegionTexture(usage, label, format, width, height, depthOrLayers, mipLevels, id);
    }
}

