/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.render.draw;

import com.google.common.cache.CacheLoader;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.Window;
import java.awt.geom.Point2D;
import java.lang.ref.WeakReference;
import journeymap.client.JourneymapClient;
import journeymap.client.data.DataCache;
import journeymap.client.event.handlers.EntityRadarUpdateEventHandler;
import journeymap.client.model.entity.EntityDTO;
import journeymap.client.render.draw.DrawStep;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.render.map.Renderer;
import journeymap.client.texture.TextureCache;
import journeymap.client.ui.fullscreen.Fullscreen;
import journeymap.client.ui.minimap.EntityDisplay;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Team;

public class DrawEntityStep
implements DrawStep {
    static final Integer labelBg = 0;
    static final float labelBgAlpha = 0.7f;
    static final Integer labelFg = 0xFFFFFF;
    static final float labelFgAlpha = 0.88f;
    static ResourceLocation playerOutlineTexture;
    boolean useDots;
    int elevationOffset;
    int color;
    int labelColor;
    boolean hideSneaks;
    boolean hideSpectators;
    boolean showHeading = true;
    boolean showOutline = false;
    Minecraft minecraft = Minecraft.getInstance();
    ResourceLocation entityTexture;
    ResourceLocation locatorTexture;
    ResourceLocation locatorBGTexture;
    WeakReference<LivingEntity> entityRef;
    Component customName;
    Component playerTeamName;
    Point2D screenPosition;
    EntityDTO entityDTO;
    float drawScale = 1.0f;
    private boolean showTeamName;
    private boolean showPlayerName;

    private DrawEntityStep(LivingEntity entityLiving) {
        this.entityRef = new WeakReference<LivingEntity>(entityLiving);
        this.hideSneaks = JourneymapClient.getInstance().getCoreProperties().hideSneakingEntities.get();
        this.hideSpectators = JourneymapClient.getInstance().getCoreProperties().hideSpectators.get();
        if (playerOutlineTexture == null) {
            playerOutlineTexture = TextureCache.PlayerOutline;
        }
    }

    public void update(EntityDisplay entityDisplay, ResourceLocation locatorTexture, ResourceLocation locatorBGTexture, ResourceLocation entityTexture, int color, int labelColor, boolean showHeading, boolean showTeamName, boolean showPlayerName, boolean showOutline, float entityDrawScale) {
        LivingEntity entityLiving = (LivingEntity)this.entityRef.get();
        this.entityDTO = DataCache.INSTANCE.getEntityDTO(entityLiving);
        if (entityLiving != null) {
            this.customName = this.entityDTO.getCustomName();
        }
        this.useDots = entityDisplay.isDots();
        this.color = color;
        this.labelColor = labelColor;
        this.locatorTexture = locatorTexture;
        this.locatorBGTexture = locatorBGTexture;
        this.entityTexture = entityTexture;
        this.drawScale = entityDrawScale;
        this.showHeading = showHeading;
        this.showTeamName = showTeamName;
        this.showPlayerName = showPlayerName;
        this.showOutline = showOutline;
        if (entityLiving instanceof Player) {
            PlayerTeam team = entityLiving.getTeam();
            this.playerTeamName = team != null && showTeamName ? PlayerTeam.formatNameForTeam((Team)entityLiving.getTeam(), (Component)entityLiving.getName()) : null;
        }
    }

    @Override
    public void draw(GuiGraphics graphics, double xOffset, double yOffset, Renderer renderer, double fontScale, double rotation) {
        LivingEntity entityLiving = (LivingEntity)this.entityRef.get();
        if (entityLiving == null || !entityLiving.isAlive() || entityLiving.isInvisibleTo((Player)this.minecraft.player) || this.hideSneaks && entityLiving.isShiftKeyDown() || this.hideSpectators && entityLiving.isSpectator()) {
            this.screenPosition = null;
            return;
        }
        this.screenPosition = renderer.getPixel(entityLiving.getX(), entityLiving.getZ());
        if (this.screenPosition != null) {
            double heading = entityLiving.getYRot();
            double drawX = this.screenPosition.getX() + xOffset;
            double drawY = this.screenPosition.getY() + yOffset;
            float alpha = 1.0f;
            if (entityLiving.getY() > this.minecraft.player.getY()) {
                alpha = 1.0f - Math.max(0.1f, (float)((entityLiving.getY() - this.minecraft.player.getY()) / 32.0));
            } else if (entityLiving.getY() < this.minecraft.player.getY()) {
                alpha = 1.0f - Math.max(0.1f, (float)((this.minecraft.player.getY() - entityLiving.getY()) / 32.0));
            }
            if (entityLiving instanceof Player) {
                alpha = JourneymapClient.getInstance().getCoreProperties().playerIconFade.get() != false ? alpha : 1.0f;
                this.drawPlayer(graphics, drawX, drawY, renderer, alpha, heading, fontScale, rotation);
            } else {
                alpha = JourneymapClient.getInstance().getCoreProperties().mobIconFade.get() != false ? alpha : 1.0f;
                this.drawCreature(graphics, drawX, drawY, renderer, alpha, heading, fontScale, rotation);
            }
        }
    }

    private void drawEntityTooltip(GuiGraphics graphics, Renderer renderer, double drawX, double drawY, int imageWidth, int imageHeight) {
        boolean specialDebug;
        if (renderer.getFullscreen() != null && this.entityDTO != null && this.entityDTO.getEntityToolTips() != null && this.isMouseOverEntity(renderer, drawX, drawY, imageWidth, imageHeight)) {
            renderer.getFullscreen().queueToolTip(this.entityDTO.getEntityToolTips());
        }
        if (specialDebug = false) {
            double thick = 2.0;
            double x = drawX - (double)(imageWidth / 2);
            double y = drawY - (double)(imageHeight / 2);
            DrawUtil.drawRectangle(graphics, x - thick * thick, y - thick * thick, (double)imageWidth + thick * 4.0, thick, 0, 0.6f);
            DrawUtil.drawRectangle(graphics, x - thick, y - thick, (double)imageWidth + thick * thick, thick, 0xFFFFFF, 0.6f);
            DrawUtil.drawRectangle(graphics, x - thick * thick, y - thick, thick, (double)imageHeight + thick * thick, 0, 0.6f);
            DrawUtil.drawRectangle(graphics, x - thick, y, thick, imageHeight, 0xFFFFFF, 0.6f);
            DrawUtil.drawRectangle(graphics, x + (double)imageWidth, y, thick, imageHeight, 0xFFFFFF, 0.6f);
            DrawUtil.drawRectangle(graphics, x + (double)imageWidth + thick, y - thick, thick, (double)imageHeight + thick * thick, 0, 0.6f);
            DrawUtil.drawRectangle(graphics, x - thick, y + (double)imageHeight, (double)imageWidth + thick * thick, thick, 0xFFFFFF, 0.6f);
            DrawUtil.drawRectangle(graphics, x - thick * thick, y + (double)imageHeight + thick, (double)imageWidth + thick * 4.0, thick, 0, 0.6f);
        }
    }

    private boolean isMouseOverEntity(Renderer renderer, double drawX, double drawY, int imageWidth, int imageHeight) {
        double mouseX = (double)renderer.getMouseX() * renderer.getFullscreen().getScreenScaleFactor();
        double mouseY = (double)renderer.getMouseY() * renderer.getFullscreen().getScreenScaleFactor();
        double x = drawX - (double)(imageWidth / 2);
        double y = drawY - (double)(imageHeight / 2);
        return mouseX >= x && mouseX <= x + (double)imageWidth && mouseY >= y && mouseY <= y + (double)imageHeight;
    }

    private void drawPlayer(GuiGraphics graphics, double drawX, double drawY, Renderer renderer, float alpha, double heading, double fontScale, double rotation) {
        boolean drawingIcon;
        LivingEntity entityLiving = (LivingEntity)this.entityRef.get();
        if (entityLiving == null) {
            return;
        }
        boolean bl = drawingIcon = this.entityTexture != null && !this.useDots;
        if (this.locatorTexture != null && !drawingIcon) {
            DrawUtil.drawOnMapImageScaleCorrected(graphics, this.locatorTexture, this.color, alpha, drawX, drawY, 160.0, 160.0, this.drawScale / 5.0f, this.showHeading ? -heading : -rotation);
            this.drawEntityTooltip(graphics, renderer, drawX, drawY, 3, 3);
        }
        if (this.entityTexture != null) {
            if (this.useDots) {
                this.elevationOffset = (int)(DataCache.getPlayer().posY - entityLiving.getY());
                if (this.elevationOffset < -1 || this.elevationOffset > 1) {
                    boolean flip = this.elevationOffset < -1;
                    DrawUtil.drawOnMapImageScaleCorrected(graphics, this.entityTexture, this.color, alpha, drawX, drawY, 160.0, 160.0, this.drawScale / 5.0f, flip ? -rotation + 180.0 : -rotation);
                    this.drawEntityTooltip(graphics, renderer, drawX, drawY, 3, 3);
                }
            } else {
                float locatorScale = this.drawScale * 1.5f;
                DrawUtil.drawOnMapImageScaleCorrected(graphics, this.locatorBGTexture, this.color, alpha, drawX, drawY, 160.0, 160.0, this.drawScale / 5.0f, this.showHeading ? -heading : -rotation);
                DrawUtil.drawOnMapImageScaleCorrected(graphics, this.entityTexture, 0xFFFFFF, alpha, drawX, drawY, 24.0, 24.0, this.drawScale, rotation);
                if (this.showOutline) {
                    DrawUtil.drawOnMapImageScaleCorrected(graphics, playerOutlineTexture, this.color, alpha, drawX, drawY, 26.0, 25.0, this.drawScale, rotation);
                }
                if (this.locatorTexture != null) {
                    int locatorColor = this.entityDTO.getAggro() != false ? 0xFF0000 : 0;
                    DrawUtil.drawOnMapImageScaleCorrected(graphics, this.locatorTexture, locatorColor, alpha, drawX, drawY, 160.0, 160.0, locatorScale / 5.0f, this.showHeading ? -heading : rotation);
                }
                this.drawEntityTooltip(graphics, renderer, drawX, drawY, 16, 16);
            }
        }
        if (JourneymapClient.getInstance().getStateHandler().isPlayerRadarNamesEnabled()) {
            double labelOffset = this.entityTexture == null ? 0.0 : 13.0;
            labelOffset = labelOffset * (double)this.drawScale * (drawingIcon ? 1.0 : 0.6);
            Point2D labelPoint = renderer.shiftWindowPosition(drawX, drawY, 0, (int)(labelOffset += fontScale * 5.0));
            if (this.playerTeamName != null && this.showTeamName) {
                DrawUtil.drawLabel(graphics, this.playerTeamName, labelPoint.getX(), labelPoint.getY(), DrawUtil.HAlign.Center, DrawUtil.VAlign.Below, 0, 0.8f, this.labelColor, 1.0f, fontScale, false, rotation);
            } else if (this.showPlayerName) {
                Component playerName = this.customName != null ? this.customName : entityLiving.getName();
                DrawUtil.drawLabel(graphics, playerName, labelPoint.getX(), labelPoint.getY(), DrawUtil.HAlign.Center, DrawUtil.VAlign.Below, 0, 0.8f, this.labelColor, 1.0f, fontScale, false, rotation);
            }
        }
    }

    private void drawCreature(GuiGraphics graphics, double drawX, double drawY, Renderer renderer, float alpha, double heading, double fontScale, double rotation) {
        Component name;
        boolean drawingIcon;
        boolean tabDown = InputConstants.isKeyDown((Window)Minecraft.getInstance().getWindow(), (int)258) && (Minecraft.getInstance().screen == null || Minecraft.getInstance().screen instanceof Fullscreen);
        LivingEntity entityLiving = (LivingEntity)this.entityRef.get();
        if (entityLiving == null) {
            return;
        }
        boolean bl = drawingIcon = this.entityTexture != null && (!this.useDots || tabDown && EntityDisplay.hasEntityIcon(EntityDisplay.DotsAndOutlinedIcons, this.entityDTO));
        if (this.locatorTexture != null && !drawingIcon) {
            DrawUtil.drawOnMapImageScaleCorrected(graphics, this.locatorTexture, this.color, alpha, drawX, drawY, 160.0, 160.0, this.drawScale / 5.0f, this.showHeading ? -heading : -rotation);
            this.drawEntityTooltip(graphics, renderer, drawX, drawY, (int)(3.0f * (this.drawScale / 2.0f)), (int)(3.0f * (this.drawScale / 2.0f)));
        }
        if (this.entityTexture != null) {
            if (!drawingIcon) {
                this.elevationOffset = (int)(DataCache.getPlayer().posY - entityLiving.getY());
                if (this.elevationOffset < -1 || this.elevationOffset > 1) {
                    boolean flip = this.elevationOffset < -1;
                    DrawUtil.drawOnMapImageScaleCorrected(graphics, this.entityTexture, this.color, alpha, drawX, drawY, 160.0, 160.0, this.drawScale / 5.0f, flip ? rotation + 180.0 : rotation);
                    this.drawEntityTooltip(graphics, renderer, drawX, drawY, 3, 3);
                }
            } else {
                ResourceLocation locBGTexTemp = this.locatorBGTexture;
                ResourceLocation entityTexTemp = this.entityTexture;
                ResourceLocation locTexTemp = this.locatorTexture;
                if (this.useDots) {
                    ResourceLocation quickTexture = EntityDisplay.getLocatorBGTexture(EntityDisplay.DotsAndOutlinedIcons, this.showHeading);
                    this.locatorBGTexture = quickTexture != null ? quickTexture : this.locatorBGTexture;
                    quickTexture = EntityDisplay.getEntityTexture(EntityDisplay.DotsAndOutlinedIcons, this.entityDTO);
                    this.entityTexture = quickTexture != null ? quickTexture : this.entityTexture;
                    quickTexture = EntityDisplay.getLocatorTexture(EntityDisplay.DotsAndOutlinedIcons, this.showHeading);
                    ResourceLocation resourceLocation = this.locatorTexture = quickTexture != null ? quickTexture : this.locatorTexture;
                }
                if (this.locatorBGTexture != null) {
                    DrawUtil.drawOnMapImageScaleCorrected(graphics, this.locatorBGTexture, this.color, alpha, drawX, drawY, 160.0, 160.0, this.drawScale / 5.0f, this.showHeading ? -heading : -rotation);
                }
                if (this.entityTexture != null) {
                    AbstractTexture texture = TextureCache.getTexture(this.entityTexture);
                    int width = texture.getTexture().getWidth(0);
                    int height = texture.getTexture().getHeight(0);
                    DrawUtil.drawOnMapImageScaleCorrected(graphics, this.entityTexture, 0xFFFFFF, alpha, drawX, drawY, width, height, this.drawScale, rotation);
                }
                if (this.locatorTexture != null && (!this.entityDTO.hasCustomIcon || this.entityDTO.drawOutline)) {
                    int locatorColor = this.entityDTO.getAggro() != false ? 0xFF0000 : 0;
                    DrawUtil.drawOnMapImageScaleCorrected(graphics, this.locatorTexture, locatorColor, alpha, drawX, drawY, 160.0, 160.0, this.drawScale / 5.0f, this.showHeading ? -heading : -rotation, true);
                }
                this.drawEntityTooltip(graphics, renderer, drawX, drawY, 16, 16);
                if (this.useDots) {
                    this.locatorBGTexture = locBGTexTemp;
                    this.entityTexture = entityTexTemp;
                    this.locatorTexture = locTexTemp;
                }
            }
        }
        if ((name = this.customName) == null && tabDown) {
            name = EntityRadarUpdateEventHandler.getEntityName(this.entityDTO, renderer.getUIState(), true);
            EntityRadarUpdateEventHandler.addEntityToolTips(this.entityDTO, renderer.getUIState(), name, true);
        }
        if (name != null) {
            double labelOffset = (double)(13.0f * this.drawScale) * (drawingIcon ? 1.0 : 0.6);
            Point2D labelPoint = renderer.shiftWindowPosition(drawX, drawY, 0, (int)(labelOffset += fontScale * 10.0));
            int color = name.getStyle().getColor() != null ? name.getStyle().getColor().getValue() : 0xFFFFFF;
            DrawUtil.drawLabel(graphics, name, labelPoint.getX(), labelPoint.getY(), DrawUtil.HAlign.Center, DrawUtil.VAlign.Middle, labelBg, alpha, color, alpha, fontScale, false, rotation);
        }
    }

    public Point2D.Double getPosition(double xOffset, double yOffset, Renderer renderer, boolean forceUpdate) {
        double x = this.entityDTO.posX;
        double z = this.entityDTO.posZ;
        double halfBlock = renderer.getUIState().blockSize / 2.0;
        Point2D.Double pixel = renderer.getBlockPixelInGrid(x, z);
        pixel.setLocation(pixel.getX() + halfBlock + xOffset, pixel.getY() + halfBlock + yOffset);
        return pixel;
    }

    public void drawOffscreen(GuiGraphics graphics, Point2D pixel, Renderer renderer, double rotation) {
        this.drawOffscreen(graphics, pixel, renderer, rotation, false);
    }

    public void drawOffscreen(GuiGraphics graphics, Point2D pixel, Renderer renderer, double rotation, boolean zeroOffset) {
        Object t = this.entityRef.get();
        if (t instanceof Player) {
            Player entityLiving = (Player)t;
            if (JourneymapClient.getInstance().getActiveMiniMapProperties().showOffScreenPlayers.get().booleanValue()) {
                double heading = entityLiving.getYRot();
                float alpha = 1.0f;
                if (entityLiving.getY() > this.minecraft.player.getY()) {
                    alpha = 1.0f - Math.max(0.1f, (float)((entityLiving.getY() - this.minecraft.player.getY()) / 32.0));
                } else if (entityLiving.getY() < this.minecraft.player.getY()) {
                    alpha = 1.0f - Math.max(0.1f, (float)((this.minecraft.player.getY() - entityLiving.getY()) / 32.0));
                }
                float texOffsetX = 8.0f * (this.drawScale * 0.5f);
                float texOffsetY = 8.0f * (this.drawScale * 0.5f);
                if (this.useDots) {
                    texOffsetX *= 0.25f;
                    texOffsetY *= 0.25f;
                }
                if (zeroOffset) {
                    if (pixel.getX() <= 0.0) {
                        texOffsetX = -(texOffsetX * (this.useDots ? 0.25f : 0.5f));
                    }
                    if (pixel.getY() <= 0.0) {
                        texOffsetY = -(texOffsetY * (this.useDots ? 0.25f : 0.5f));
                    }
                }
                if (entityLiving instanceof Player) {
                    alpha = JourneymapClient.getInstance().getCoreProperties().playerIconFade.get() != false ? alpha : 1.0f;
                    this.drawPlayer(graphics, pixel.getX() - (double)texOffsetX, pixel.getY() - (double)texOffsetY, renderer, alpha, heading, 1.0, rotation);
                }
            }
        }
    }

    @Override
    public int getDisplayOrder() {
        return this.customName != null ? 1 : 0;
    }

    @Override
    public String getModId() {
        return "journeymap";
    }

    public static class SimpleCacheLoader
    extends CacheLoader<LivingEntity, DrawEntityStep> {
        public DrawEntityStep load(LivingEntity entityLiving) throws Exception {
            return new DrawEntityStep(entityLiving);
        }
    }
}

