/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.event.handlers;

import java.util.ArrayList;
import java.util.List;
import journeymap.api.v2.client.ui.component.LayeredScreen;
import journeymap.client.JourneymapClient;
import journeymap.client.log.JMLogger;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.fullscreen.Fullscreen;
import journeymap.client.ui.minimap.MiniMap;
import journeymap.client.ui.option.ClientOptionsManager;
import journeymap.client.ui.option.MinimapOptions;
import journeymap.client.ui.option.OptionScreen;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.input.MouseButtonInfo;

public class ScreenEventHandler {
    static final List<String> BLACK_LISTED_SCREENS = new ArrayList<String>();
    boolean clicked = false;
    boolean didDrag = false;
    static ScreenEventHandler instance;

    private ScreenEventHandler() {
    }

    public static ScreenEventHandler getInstance() {
        if (instance == null) {
            instance = new ScreenEventHandler();
        }
        return instance;
    }

    public void onScreenPreRender(Screen screen, GuiGraphics graphics, int mouseX, int mouseY) {
        if (JourneymapClient.getInstance() != null && JourneymapClient.getInstance().getCoreProperties() != null && JourneymapClient.getInstance().enabled() && JourneymapClient.getInstance().getCoreProperties().allowMiniMapBehindScreens.get().booleanValue()) {
            try {
                boolean preview;
                boolean bl = preview = screen instanceof ClientOptionsManager && ((ClientOptionsManager)screen).previewMiniMap();
                if (this.allowableDrawScreens(screen) && JourneymapClient.getInstance().isMapping().booleanValue() && UIManager.INSTANCE.isMiniMapEnabled()) {
                    MiniMap miniMap = UIManager.INSTANCE.getMiniMap();
                    miniMap.drawMap(graphics, true);
                } else if (!preview) {
                    this.clicked = false;
                }
            }
            catch (Throwable t) {
                JMLogger.throwLogOnce("Unexpected error during onScreenPreRender: " + String.valueOf(t), t);
            }
        }
    }

    public boolean onScreenMousePressedEvent(Screen screen, MouseButtonEvent event) {
        if (JourneymapClient.getInstance().enabled() && !this.clicked && this.allowableDragScreens(screen) && JourneymapClient.getInstance().isMapping().booleanValue()) {
            this.clicked = UIManager.INSTANCE.getMiniMap().mouseClicked(event, false);
            return this.clicked;
        }
        return false;
    }

    public boolean onScreenMouseDraggedEvent(Screen screen, MouseButtonEvent event, double dragX, double dragY) {
        if (JourneymapClient.getInstance().enabled() && this.clicked && this.allowableDragScreens(screen) && JourneymapClient.getInstance().isMapping().booleanValue()) {
            this.didDrag = UIManager.INSTANCE.getMiniMap().mouseDragged(event, dragX, dragY);
            return this.didDrag;
        }
        return false;
    }

    public boolean onScreenMouseReleasedEvent(Screen screen, MouseButtonEvent event) {
        if (JourneymapClient.getInstance().enabled() && UIManager.INSTANCE.getMiniMap() != null && UIManager.INSTANCE.getMiniMap().mouseReleased(event)) {
            this.clicked = false;
            return true;
        }
        return false;
    }

    public void onScreenClosedEvent(Screen screen) {
        if (JourneymapClient.getInstance().enabled() && JourneymapClient.getInstance().isMapping().booleanValue() && UIManager.INSTANCE.getMiniMap() != null) {
            UIManager.INSTANCE.getMiniMap().mouseReleased(new MouseButtonEvent(0.0, 0.0, new MouseButtonInfo(0, 0)));
            this.clicked = false;
            this.didDrag = false;
        }
    }

    private boolean allowableDragScreens(Screen screen) {
        return screen instanceof ClientOptionsManager;
    }

    private boolean allowableDrawScreens(Screen screen) {
        if (screen instanceof LayeredScreen) {
            LayeredScreen layeredScreen = (LayeredScreen)screen;
            return this.allowableDrawScreens(layeredScreen.getBackgroundScreen());
        }
        return !(screen instanceof Fullscreen) && !(screen instanceof MinimapOptions) && !(screen instanceof OptionScreen) && !(screen instanceof ChatScreen) && !this.modScreens(screen);
    }

    private boolean modScreens(Screen screen) {
        return screen != null && (BLACK_LISTED_SCREENS.contains(screen.getClass().getSimpleName()) || BLACK_LISTED_SCREENS.contains(screen.getClass().getName()));
    }

    static {
        BLACK_LISTED_SCREENS.add("com.cobblemon.mod.common.client.gui.battle.BattleGUI");
        BLACK_LISTED_SCREENS.add("net.minecraft.client.gui.screens.TitleScreen");
        BLACK_LISTED_SCREENS.add("net.minecraft.client.gui.screens.worldselection.SelectWorldScreen");
        BLACK_LISTED_SCREENS.add("net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen");
        BLACK_LISTED_SCREENS.add("net.minecraft.client.gui.screens.LevelLoadingScreen");
        BLACK_LISTED_SCREENS.add("net.minecraft.client.gui.screens.GenericMessageScreen");
    }
}

